/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroIndeferimentoRedeSim;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.List;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@EloController(value="motivoIndeferimentoRedeSimController")
@Scope(value="flow")
public class MotivoIndeferimentoRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 7809900820490092087L;
    private List<IndeferimentoRedeSimEntity> motivosIndeferimentoRedeSim;
    private IndeferimentoRedeSimEntity motivoIndeferimento;
    private FiltroIndeferimentoRedeSim filtro;
    private Long codigo;
    private String descricao;
    private String situacao;

    public FiltroIndeferimentoRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroIndeferimentoRedeSim filtro) {
        this.filtro = filtro;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public void iniciar() throws BaseException {
        this.filtro = new FiltroIndeferimentoRedeSim();
        this.limparCampos();
        this.motivosIndeferimentoRedeSim = this.carregarListaMotivosIndeferimentoRedeSim();
    }

    public IndeferimentoRedeSimEntity getMotivoIndeferimento() {
        return this.motivoIndeferimento;
    }

    public void setMotivoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) {
        this.motivoIndeferimento = motivoIndeferimento;
    }

    public List<IndeferimentoRedeSimEntity> getMotivosIndeferimentoRedeSim() {
        return this.motivosIndeferimentoRedeSim;
    }

    public void setMotivosIndeferimentoRedeSim(List<IndeferimentoRedeSimEntity> motivosIndeferimentoRedeSim) {
        this.motivosIndeferimentoRedeSim = motivosIndeferimentoRedeSim;
    }

    public List<IndeferimentoRedeSimEntity> carregarListaMotivosIndeferimentoRedeSim() throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarListaMotivosIndeferimentoRedeSim(this.filtro);
    }

    public void salvarMotivoIndeferimento() throws BaseException {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarMotivoIndeferimento(this.motivoIndeferimento);
            this.iniciar();
            RequestContext.getCurrentInstance().execute("dialogNovoMotivoIndeferimento.hide();");
            ShowMessage.addInfoMessage((String)"msg", (String)"Motivo de Indeferimento salvo com sucesso.");
        }
        catch (ValidacaoException e) {
            ShowMessage.addErrorMessages((String)"msgDialog", (List)e.getMensagens());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msgDialog", (String)"Ocorreu um erro ao tentar salvar o Motivo do Indeferimento. Entre em contato com o Suporte.");
        }
    }

    public void removerMotivoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).removerMotivoIndeferimentoRedeSim(motivoIndeferimento);
            ShowMessage.addInfoMessage((String)"msg", (String)"Motivo de Indeferimento exclu\u00eddo com sucesso.");
            this.iniciar();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"Ocorreu uma falha ao deletar. Entre em contato com o Suporte.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void novoMotivoIndeferimento() {
        this.motivoIndeferimento = new IndeferimentoRedeSimEntity();
        this.motivoIndeferimento.setAtivo(SimNaoEnum.getSimShortText());
        this.motivoIndeferimento.setEdicao(Boolean.valueOf(false));
    }

    public void editarMotivoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) {
        this.motivoIndeferimento = motivoIndeferimento;
        this.motivoIndeferimento.setEdicao(Boolean.valueOf(true));
    }

    public void limparCampos() {
        this.codigo = null;
        this.descricao = null;
        this.situacao = null;
        this.motivosIndeferimentoRedeSim = null;
    }

    public Boolean existeCodigoIndeferimento(IndeferimentoRedeSimEntity motivoIndeferimento) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).existeCodigoIndeferimento(motivoIndeferimento);
    }

    public SimNaoEnum[] simNaoEnum() {
        return SimNaoEnum.values();
    }

    public void pesquisar() {
        this.limparFiltro();
        if (this.codigo != null) {
            this.filtro.setCodigo(this.codigo);
        }
        if (!EloStringUtils.isEmpty((String)this.descricao)) {
            this.filtro.setDescricao(this.descricao);
        }
        if (!EloStringUtils.isEmpty((String)this.situacao)) {
            this.filtro.setSituacao(this.situacao);
        }
        try {
            this.motivosIndeferimentoRedeSim = this.carregarListaMotivosIndeferimentoRedeSim();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao buscar os indeferimentos.");
        }
    }

    public void limparFiltro() {
        if (this.filtro != null) {
            this.filtro.setCodigo(null);
            this.filtro.setDescricao(null);
            this.filtro.setSituacao(null);
        } else {
            this.filtro = new FiltroIndeferimentoRedeSim();
        }
    }
}

