/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.CaptchaController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroFiscalizacaoEnum;
import br.com.elotech.portalarrecadacao.exception.LoginOAuthException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoConfiguradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeLoginPortal;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.validator.CpfCnpjValidador;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.domain.EntidadeEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioSeletorEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioSeletorPK;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.util.captcha.CaptchaUtil;
import br.com.elotech.util.crypto.EloCryptoUtils;
import br.com.elotech.util.enumerator.UsuarioMasterTecnicoEnum;
import br.com.elotech.util.exceptions.CryptoException;
import br.com.elotech.util.exceptions.HashException;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloHashUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.octo.captcha.service.CaptchaServiceException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.context.RequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.webflow.context.ExternalContext;

@Scope(value="session")
@EloController(value="loginPortalArrecadacaoController")
public class LoginPortalArrecadacao
extends EloLogger
implements Serializable {
    @Resource
    private CaptchaController captchaController;
    private static final String SELETORTELASOLICITACAOALVARA = "ROLE_TELASOLICITACAOALVARA";
    private static final String SELETORTELAACOMPANHAMENTO = "ROLE_TELAACOMPANHAMENTO";
    private String nomeUsuarioLogado;
    @Resource
    private CaptchaUtil captchaUtil;
    @Autowired
    public AuthenticationManager authenticationManager;
    @Resource
    private EntidadeController entidadeController;
    @Autowired
    private AuthenticationProviderAise authenticationProviderAise;
    private String captchaCodigo;
    private String cpfUsuario;
    private String senha;
    private String nome;
    private Boolean logado = false;
    private Boolean integradoIss;
    private Boolean paginaSolicitacaoAlvara = false;
    private Boolean redirecionaParaSolicitacao = false;

    public AuthenticationProviderAise getAuthenticationProviderAise() {
        return this.authenticationProviderAise;
    }

    public void setAuthenticationProviderAise(AuthenticationProviderAise authenticationProviderAise) {
        this.authenticationProviderAise = authenticationProviderAise;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public boolean isRedirecionaParaSolicitacao() {
        return this.redirecionaParaSolicitacao;
    }

    public void setRedirecionaParaSolicitacao(boolean redirecionaParaSolicitacao) {
        this.redirecionaParaSolicitacao = redirecionaParaSolicitacao;
    }

    public void setNomeUsuarioLogado(String nomeUsuarioLogado) {
        this.nomeUsuarioLogado = nomeUsuarioLogado;
    }

    public String getNomeUsuarioLogado() {
        return this.nomeUsuarioLogado;
    }

    public boolean isIntegradoIss() {
        return this.integradoIss;
    }

    public boolean isPaginaSolicitacaoAlvara() {
        return this.paginaSolicitacaoAlvara;
    }

    public void setPaginaSolicitacaoAlvara(boolean paginaSolicitacaoAlvara) {
        this.paginaSolicitacaoAlvara = paginaSolicitacaoAlvara;
    }

    public void setIntegradoIss(boolean integradoIss) {
        this.integradoIss = integradoIss;
    }

    public String getCaptchaCodigo() {
        return this.captchaCodigo;
    }

    public void setCaptchaCodigo(String captchaCodigo) {
        this.captchaCodigo = captchaCodigo;
    }

    public void setCaptchaUtil(CaptchaUtil captchaUtil) {
        this.captchaUtil = captchaUtil;
    }

    public String getCpfUsuario() {
        return this.cpfUsuario;
    }

    public void setCpfUsuario(String cpfUsuario) {
        this.cpfUsuario = cpfUsuario;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Boolean getLogado() {
        return this.logado;
    }

    public void setLogado(Boolean logado) {
        this.logado = logado;
    }

    public EntidadeController getEntidadeController() {
        return this.entidadeController;
    }

    public void logout() throws BaseException {
        this.cpfUsuario = "";
        this.limparCaptchaDigitado();
        this.authenticationProviderAise.logout();
        this.logado = false;
        ShowMessage.addInfoMessage((String)"msg", (String)"Usu\u00e1rio desconectado!");
    }

    public void limparCaptchaDigitado() {
        this.captchaCodigo = "";
    }

    public boolean validaCpfCnpj() {
        CpfCnpjValidador cpfCnpjValidador = new CpfCnpjValidador();
        cpfCnpjValidador.setIdMessage("msg");
        return cpfCnpjValidador.validarCpfCnpj(this.cpfUsuario);
    }

    public String logar(String retorno, String checkCaptcha) throws ServletException, IOException, BaseException {
        try {
            if (!UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)this.cpfUsuario)) {
                boolean isBaseHomologacao = this.entidadeController.isBaseHomologacao();
                if (!this.validaCpfCnpj()) {
                    return null;
                }
                if (!isBaseHomologacao && !this.entidadeController.isRegistroValido()) {
                    this.logger.info((Object)" Registro Inv\u00e1lido......... ");
                    this.logado = false;
                    return "toIndisponivel";
                }
                if (!isBaseHomologacao) {
                    String captchaId = this.captchaController.getCaptchaId();
                    if (checkCaptcha.equals("S")) {
                        if (captchaId != null) {
                            try {
                                if (!this.captchaUtil.validateCaptchaForId(captchaId, this.captchaCodigo)) {
                                    this.limparCaptchaDigitado();
                                    ShowMessage.addErrorMessage((String)"msg", (String)"C\u00f3digo Inv\u00e1lido! Tente novamente!");
                                    return null;
                                }
                                this.limparCaptchaDigitado();
                            }
                            catch (CaptchaServiceException e) {
                                ShowMessage.addErrorMessage((String)"msg", (String)"Problema na compara\u00e7\u00e3o!");
                                return null;
                            }
                        } else {
                            ShowMessage.addErrorMessage((String)"msg", (String)"Problema na compara\u00e7\u00e3o!");
                            return null;
                        }
                    }
                }
            }
            this.logado = this.efetuarLogin(this.cpfUsuario, this.senha);
            this.limparCaptchaDigitado();
            if (!this.logado.booleanValue()) {
                ShowMessage.addErrorMessage((String)"msg", (String)"Login/senha inv\u00e1lidos! Tente Novamente!");
                return null;
            }
            this.adicionarSenhaAcessoFiscalizacaoNaSessao();
            this.nomeUsuarioLogado = this.getUsuarioLogado();
            this.cpfUsuario = "";
            RequestContext.getCurrentInstance().execute("dlgAcessoRestrito.hide()");
            if (this.isRedirecionaParaSolicitacao()) {
                return "toSolicitacaoAlvara";
            }
            RequestContext.getCurrentInstance().execute("window.location.reload()");
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)("N\u00e3o foi poss\u00edvel efetuar o login. Erro: " + e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return retorno;
    }

    public Boolean efetuarLogin(String cpf, String senha) throws BaseException {
        Boolean logado = false;
        if (UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)cpf)) {
            logado = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).efetuaLoginAise(cpf, senha, this.authenticationManager);
        } else {
            if (UtilsController.isAutenticacaoKeyCloak() || this.possuiUsuarioAise(cpf)) {
                logado = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).efetuaLoginAise(cpf, senha, this.authenticationManager);
            }
            if (!logado.booleanValue() && this.possuiUsuarioAcessoWeb(cpf)) {
                logado = this.efetuarLoginContribuinte(cpf, senha);
                this.entidadeController.setVerificarCpfConsultaParaImprimirAlvara(logado.booleanValue());
            }
        }
        return logado;
    }

    protected void adicionarSenhaAcessoFiscalizacaoNaSessao() throws CryptoException {
        if (Objects.nonNull(this.senha)) {
            String senha = EloCryptoUtils.cifra((String)this.senha);
            FacesContext.getCurrentInstance().getExternalContext().getSessionMap().put(ParametroFiscalizacaoEnum.SENHA_ACESSO_FISCALIZACAO_SESSION.getDescricao(), senha);
        }
    }

    private boolean possuiUsuarioAise(String cpfUsuario) throws BaseException {
        return this.carregarUsuarioPorCpf(cpfUsuario);
    }

    private boolean carregarUsuarioPorCpf(String cpfUsuario) throws BaseException {
        return ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLogin(cpfUsuario) != null;
    }

    private boolean efetuarLoginContribuinte(String cpf, String senha) throws BaseException, HashException {
        return ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).efetuaLoginContribuinte(cpf, EloHashUtils.montarSenha((String)cpf, (String)senha).toUpperCase(), this.authenticationManager);
    }

    public String acessaLoginIntegradoIss() {
        block5: {
            try {
                if (!this.entidadeController.getVerificaIntegradoLoginExterno().booleanValue()) break block5;
                if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
                    String url = null;
                    String linkLoginExterno = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "LINKLOGINEXTERNO");
                    if (StringUtils.isNotBlank((CharSequence)linkLoginExterno)) {
                        String clientOauth = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "CLIENTOAUTH");
                        String redirectTelaLogin = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "REDIRECTTELALOGIN");
                        url = StringUtils.isNotBlank((CharSequence)clientOauth) && StringUtils.isNotBlank((CharSequence)redirectTelaLogin) ? String.format("%s?response_type=code&client_id=%s&redirect_uri=%s&scope=&state=", linkLoginExterno, clientOauth, redirectTelaLogin) : linkLoginExterno;
                    } else {
                        throw new ParametroNaoConfiguradoException("Par\u00e2metros de configura\u00e7\u00e3o do login externo n\u00e3o encontrado");
                    }
                    RequestContext.getCurrentInstance().execute("window.open('" + url + "','_self')");
                    break block5;
                }
                return "toSolicitacao";
            }
            catch (BaseException e) {
                ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel acessar a p\u00e1gina de Login do ISS-e");
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    public void verificarIntegracao() {
        try {
            this.integradoIss = this.entidadeController.getVerificaIntegradoLoginExterno();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel verificar a integra\u00e7\u00e3o do Login");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void getRequestParameter(String name, ExternalContext context) {
        try {
            String tokenTemporario = context.getRequestParameterMap().get(name);
            if (tokenTemporario != null) {
                String linkRedirecionarLoginExternoISS = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).getParamentroGeral(Modulo.ALVARAONLINE.getCodigo(), "REDIRECTTELALOGIN");
                this.getDadosUsuario((String)((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).getTokenOauth(Modulo.ALVARAONLINE.getCodigo(), tokenTemporario, linkRedirecionarLoginExternoISS).get("access_token"));
                this.paginaSolicitacaoAlvara = true;
                this.entidadeController.setVerificarCpfConsultaParaImprimirAlvara(true);
            } else {
                this.paginaSolicitacaoAlvara = false;
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"msg", (String)String.format("%s%s", "Ocorreu uma Falha na Integra\u00e7\u00e3o do Login  ERRO: ", e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.entidadeController.setVerificarCpfConsultaParaImprimirAlvara(false);
        }
    }

    public void checkOAuthResponse(JSONObject json) throws LoginOAuthException {
        if (json.has("error")) {
            LoginOAuthException oauthException = new LoginOAuthException();
            oauthException.formJson(json);
            this.logger.info((Object)"ERRO OAUTH ");
            throw oauthException;
        }
    }

    private void getDadosUsuario(String accessToken) throws ServletException, LoginOAuthException {
        try {
            UsuarioEntity usuario;
            JSONObject objetoJson = ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).getUsuarioOauth(Modulo.ALVARAONLINE.getCodigo(), accessToken);
            this.checkOAuthResponse(objetoJson);
            this.cpfUsuario = (String)objetoJson.get("cpfcgc");
            this.nome = (String)objetoJson.get("nome");
            this.senha = null;
            List listaPessoa = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaPessoasPorCpfCnpj(this.cpfUsuario);
            PessoaEntity pessoa = null;
            if (listaPessoa != null) {
                Long codigoPessoa = null;
                for (PessoaEntity pessoaEntity : listaPessoa) {
                    if (codigoPessoa == null) {
                        codigoPessoa = pessoaEntity.getId();
                        pessoa = pessoaEntity;
                        continue;
                    }
                    if (pessoaEntity.getId() >= codigoPessoa) continue;
                    codigoPessoa = pessoaEntity.getId();
                    pessoa = pessoaEntity;
                }
            }
            if (pessoa == null) {
                pessoa = new PessoaEntity();
                pessoa.setCnpjCpf(this.cpfUsuario);
                pessoa.setNome(this.nome);
                pessoa.setDataInclusao(new Date());
                pessoa.setInativo(SimNaoEnum.getNaoShortText());
                pessoa.setTipoPessoa(this.getTipoPessoa(this.cpfUsuario));
                pessoa.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
                pessoa.setEnderecos(new ArrayList());
                pessoa.setContatos(new ArrayList());
                pessoa = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirPessoa(pessoa);
            }
            if ((usuario = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLogin(this.cpfUsuario)) == null) {
                UsuarioEntity usuarioGravado = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).criarUsuarioAlvara(pessoa, ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).buscaSeletor(Modulo.ALVARAONLINE.getCodigo(), SELETORTELAACOMPANHAMENTO), ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).buscaSeletor(Modulo.ALVARAONLINE.getCodigo(), SELETORTELASOLICITACAOALVARA), (EntidadeEntity)this.entidadeController.getEntidade());
                String nome_replace = usuarioGravado.getPessoa().getNome().replace(" ", "").trim();
                this.senha = String.format("%s%s", usuarioGravado.getPessoa().getCnpjCpf(), nome_replace.toLowerCase());
            } else {
                UsuarioSeletorPK usuarioSeletorPK;
                UsuarioSeletorEntity usuarioSeletor;
                boolean seletorTelaCompanhamento = false;
                boolean seletorTelaSolicitacaoAlvara = false;
                List listaUsuarioSeletor = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getUsuarioSeletorByModuloSeletor(Modulo.ALVARAONLINE.getCodigo(), usuario.getUsuario());
                for (UsuarioSeletorEntity usuario_seletor : listaUsuarioSeletor) {
                    if (usuario_seletor.getId().getSeletor().getId().getSeletor().equals(SELETORTELAACOMPANHAMENTO)) {
                        seletorTelaCompanhamento = true;
                    }
                    if (!usuario_seletor.getId().getSeletor().getId().getSeletor().equals(SELETORTELASOLICITACAOALVARA)) continue;
                    seletorTelaSolicitacaoAlvara = true;
                }
                if (!seletorTelaCompanhamento) {
                    usuarioSeletor = new UsuarioSeletorEntity();
                    usuarioSeletor.setInserir("N");
                    usuarioSeletor.setAlterar("N");
                    usuarioSeletor.setExcluir("N");
                    usuarioSeletor.setFavorito("N");
                    usuarioSeletor.setFuncaoEspecial("N");
                    usuarioSeletorPK = new UsuarioSeletorPK();
                    usuarioSeletorPK.setEntidade((EntidadeEntity)this.entidadeController.getEntidade());
                    usuarioSeletorPK.setSeletor(((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).buscaSeletor(Modulo.ALVARAONLINE.getCodigo(), SELETORTELAACOMPANHAMENTO));
                    usuarioSeletorPK.setUsuario(usuario);
                    usuarioSeletor.setId(usuarioSeletorPK);
                    usuario.getUsuarioSeletores().add(usuarioSeletor);
                }
                if (!seletorTelaSolicitacaoAlvara) {
                    usuarioSeletor = new UsuarioSeletorEntity();
                    usuarioSeletor.setInserir("N");
                    usuarioSeletor.setAlterar("N");
                    usuarioSeletor.setExcluir("N");
                    usuarioSeletor.setFavorito("N");
                    usuarioSeletor.setFuncaoEspecial("N");
                    usuarioSeletorPK = new UsuarioSeletorPK();
                    usuarioSeletorPK.setEntidade((EntidadeEntity)this.entidadeController.getEntidade());
                    usuarioSeletorPK.setSeletor(((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).buscaSeletor(Modulo.ALVARAONLINE.getCodigo(), SELETORTELASOLICITACAOALVARA));
                    usuarioSeletorPK.setUsuario(usuario);
                    usuarioSeletor.setId(usuarioSeletorPK);
                    usuario.getUsuarioSeletores().add(usuarioSeletor);
                }
                if (!seletorTelaCompanhamento || !seletorTelaSolicitacaoAlvara) {
                    ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(usuario);
                }
            }
            this.logar("toSolicitacao", "N");
        }
        catch (BaseException | IOException e) {
            ShowMessage.addErrorMessage((String)"msg", (String)"N\u00e3o foi poss\u00edvel Criar o Usu\u00e1rio na base de dados.");
            this.logger.info((Object)"N\u00e3o foi poss\u00edvel Criar o Usu\u00e1rio na base de dados.>>>>");
            this.logger.error((Object)e.getMessage(), e);
        }
    }

    public void envioEmailTeste() throws BaseException {
        ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).enviarEmail();
    }

    public String getUsuarioLogado() throws BaseException {
        UserDetails usuarioLogado = this.getUsuario();
        if (usuarioLogado != null) {
            if (usuarioLogado instanceof UsuarioEntity && ((UsuarioEntity)usuarioLogado).getPessoa() != null) {
                return ((UsuarioEntity)usuarioLogado).getPessoa().getDoisPrimeirosNomes();
            }
            if (usuarioLogado instanceof AcessoWebEntity) {
                return ((AcessoWebEntity)usuarioLogado).getDoisPrimeirosNomes();
            }
        }
        return "Usu\u00e1rio";
    }

    public UserDetails getUsuario() {
        return this.authenticationProviderAise.getUsuarioLogado();
    }

    public String toSolicitacaoAlvara() throws BaseException {
        SolicitacaoAlvaraEntity solicitacao = this.entidadeController.getSolicitacaoAlvara();
        if (solicitacao != null) {
            solicitacao.validarInformacoesImovel();
            if (solicitacao.possuiErrosValidacaoImobiliario()) {
                ShowMessage.addErrorMessage((String)"validacaows", (String)"Atualize as informa\u00e7\u00f5es Imobili\u00e1rias junto \u00e0 prefeitura para continuar.");
                return "";
            }
        }
        if (!this.logado.booleanValue() && !this.entidadeController.getVerificaIntegradoLoginExterno().booleanValue()) {
            RequestContext.getCurrentInstance().execute("dlgAcessoRestrito.show()");
            return "";
        }
        return "toLoginIntegradoIss";
    }

    public boolean possuiUsuarioAcessoWeb(String cnpjCpf) throws UsernameNotFoundException {
        AcessoWebEntity user = null;
        try {
            user = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLoginAcessoWeb(cnpjCpf);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return user != null;
    }

    private String getTipoPessoa(String cpfCnpj) {
        if (EloStringUtils.retiraChars((String)cpfCnpj, (char[])new char[]{'.', ',', '-'}).length() == 14) {
            return "J";
        }
        return "F";
    }
}

