/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.portalarrecadacao.filter.FiltroCadastroRestricao;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.Scope;

@EloController
@Scope(value="flow")
public class LiberarRestricoesUsuarioController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5374045224755385867L;
    private String usuarioOuCpfCnpj;
    private UsuarioEntity usuarioSelecionado;
    private List<CadastroRestricaoAlvaraEntity> listaRestricoes = new ArrayList();
    private List<CadastroRestricaoAlvaraEntity> restricoesSelecionadas = new ArrayList();

    public String getUsuarioOuCpfCnpj() {
        return this.usuarioOuCpfCnpj;
    }

    public void setUsuarioOuCpfCnpj(String usuarioOuCpfCnpj) {
        this.usuarioOuCpfCnpj = usuarioOuCpfCnpj;
    }

    public UsuarioEntity getUsuarioSelecionado() {
        return this.usuarioSelecionado;
    }

    public void setUsuarioSelecionado(UsuarioEntity usuarioSelecionado) {
        this.usuarioSelecionado = usuarioSelecionado;
    }

    public List<CadastroRestricaoAlvaraEntity> getListaRestricoes() {
        return this.listaRestricoes;
    }

    public void setListaRestricoes(List<CadastroRestricaoAlvaraEntity> listaRestricoes) {
        this.listaRestricoes = listaRestricoes;
    }

    public List<CadastroRestricaoAlvaraEntity> getRestricoesSelecionadas() {
        return this.restricoesSelecionadas;
    }

    public void setRestricoesSelecionadas(List<CadastroRestricaoAlvaraEntity> restricoesSelecionadas) {
        this.restricoesSelecionadas = restricoesSelecionadas;
    }

    public void iniciar() throws BaseException {
        this.usuarioSelecionado = new UsuarioEntity();
        this.listaRestricoes = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).carregarListaCadastroRestricoes(new FiltroCadastroRestricao());
    }

    public void pesquisar() throws BaseException {
        if (this.validarCampos()) {
            this.usuarioSelecionado = this.recuperarUsuario(this.usuarioOuCpfCnpj);
            this.preencherRestricoesDoUsuario();
        }
    }

    protected UsuarioEntity recuperarUsuario(String usuarioOuCpfCnpj) {
        UsuarioEntity usuario = null;
        try {
            usuario = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).getRestricoesPorUsuarioCpfCnpj(usuarioOuCpfCnpj);
        }
        catch (BaseException e) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Usu\u00e1rio n\u00e3o encontrado.");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu um erro ao tentar consultar o Usu\u00e1rio");
            this.logger.error((Object)e.getCause(), (Throwable)e);
        }
        return usuario;
    }

    protected void preencherRestricoesDoUsuario() {
        if (Objects.nonNull(this.usuarioSelecionado)) {
            this.restricoesSelecionadas = this.usuarioSelecionado.getCadastroRestricoesAlvaras();
        }
    }

    protected boolean validarCampos() {
        if (EloStringUtils.isEmpty((String)this.usuarioOuCpfCnpj)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o campo Usu\u00e1rio ou CPF/CNPJ.");
            return false;
        }
        return true;
    }

    public void salvar() {
        if (!EloListUtils.safeIsEmpty((List)this.usuarioSelecionado.getCadastroRestricoesAlvaras()).booleanValue()) {
            this.usuarioSelecionado.getCadastroRestricoesAlvaras().clear();
        } else {
            this.usuarioSelecionado.setCadastroRestricoesAlvaras(new ArrayList());
        }
        this.usuarioSelecionado.getCadastroRestricoesAlvaras().addAll(this.restricoesSelecionadas);
        try {
            this.usuarioSelecionado = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(this.usuarioSelecionado);
            ShowMessage.addInfoMessage((String)"validacao", (String)"Restri\u00e7\u00f5es de usu\u00e1rio alteradas com sucesso.");
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("Erro ao salvar. " + e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void limparFormulario() {
        this.usuarioOuCpfCnpj = "";
        this.usuarioSelecionado = new UsuarioEntity();
        this.restricoesSelecionadas.clear();
    }
}

