/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.domain.AcessoWebTipoPermissaoEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.vo.AcessoWebVo;
import br.com.elotech.tributacao.enumerator.AtivoInativoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;

@EloController(value="liberarPermissaoUsuarioController")
@Scope(value="flow")
public class LiberarPermissaoUsuarioController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5374045224755385867L;
    private AcessoWebVo acessoWebVo = new AcessoWebVo();
    private AcessoWebEntity usuario;
    private List<AcessoWebEntity> usuarios = new ArrayList();
    private boolean habilitarVisualizacao;
    private List<AcessoWebTipoPermissaoEntity> permissoes;
    private List<AcessoWebTipoPermissaoEntity> permissoesSelecionadas = new ArrayList();
    private boolean usuarioAtivo;
    private EntidadeAiseEntity entidadePrincipal;

    public AcessoWebVo getAcessoWebVo() {
        return this.acessoWebVo;
    }

    public void setAcessoWebVo(AcessoWebVo acessoWebVo) {
        this.acessoWebVo = acessoWebVo;
    }

    public AcessoWebEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(AcessoWebEntity usuario) {
        this.usuario = usuario;
    }

    public List<AcessoWebEntity> getUsuarios() {
        return this.usuarios;
    }

    public boolean isHabilitarVisualizacao() {
        return this.habilitarVisualizacao;
    }

    public List<AcessoWebTipoPermissaoEntity> getPermissoes() {
        return this.permissoes;
    }

    public List<AcessoWebTipoPermissaoEntity> getPermissoesSelecionadas() {
        return this.permissoesSelecionadas;
    }

    public void setPermissoesSelecionadas(List<AcessoWebTipoPermissaoEntity> permissoesSelecionadas) {
        this.permissoesSelecionadas = permissoesSelecionadas;
    }

    public boolean isUsuarioAtivo() {
        return this.usuarioAtivo;
    }

    public void setUsuarioAtivo(boolean usuarioAtivo) {
        this.usuarioAtivo = usuarioAtivo;
        if (usuarioAtivo) {
            this.usuario.setAtivo(AtivoInativoEnum.ATIVO.getShortText());
        } else {
            this.usuario.setAtivo(AtivoInativoEnum.INATIVO.getShortText());
        }
    }

    public void pesquisarUsuarios() throws BaseException {
        this.habilitarVisualizacao = false;
        this.permissoesSelecionadas.clear();
        this.usuarios = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).carregarListaUsuariosAcessoWebPorNomeCpfSituacao(this.acessoWebVo);
    }

    public void limparFormulario() {
        this.usuarios.clear();
        this.habilitarVisualizacao = false;
        this.permissoesSelecionadas.clear();
        this.acessoWebVo = new AcessoWebVo();
    }

    public List<AtivoInativoEnum> ativoInativoEnumValues() {
        return Arrays.asList(AtivoInativoEnum.values());
    }

    public void visualizarUsuario(AcessoWebEntity usuario) throws BaseException {
        this.usuario = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLoginAcessoWeb(usuario.getCpf());
        this.usuarioAtivo = this.usuario.getAtivo().equals(AtivoInativoEnum.ATIVO.getShortText());
        this.permissoes = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).carregaListaAcessoWebTipoPermissaoPorModulo(new String[]{Modulo.ALVARAONLINE.toString()});
        this.permissoesSelecionadas.clear();
        if (!EloListUtils.safeIsEmpty((List)this.permissoes).booleanValue()) {
            for (AcessoWebTipoPermissaoEntity permissao : this.permissoes) {
                if (!this.usuario.getAcessoWebTipoPermissao().contains(permissao)) continue;
                this.permissoesSelecionadas.add(permissao);
            }
        }
        this.habilitarVisualizacao = true;
    }

    public void salvarAlteracoes() throws BaseException {
        if (this.usuarioAtivo) {
            if (!EloListUtils.safeIsEmpty((List)this.permissoesSelecionadas).booleanValue()) {
                this.salvarPermissoesUsuario();
                this.enviarEmailNotificandoAtivacao();
            } else {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Selecione ao menos uma permiss\u00e3o para salvar o usu\u00e1rio como ativo.");
            }
        } else {
            this.salvarPermissoesUsuario();
        }
    }

    private void salvarPermissoesUsuario() {
        this.usuario.getAcessoWebTipoPermissao().clear();
        this.usuario.getAcessoWebTipoPermissao().addAll(this.permissoesSelecionadas);
        try {
            this.salvarUsuario();
            this.habilitarVisualizacao = false;
            ShowMessage.addInfoMessage((String)"validacao", (String)"Permiss\u00f5es adicionadas com sucesso.");
            this.pesquisarUsuarios();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao salvar novas permiss\u00f5es.");
        }
    }

    private void salvarUsuario() throws BaseException {
        ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(this.usuario);
    }

    private void buscarEntidadePrincipal() throws BaseException {
        if (this.entidadePrincipal == null) {
            this.entidadePrincipal = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).buscarEntidadePrincipal();
        }
    }

    public void cancelarVisualizacao() {
        this.habilitarVisualizacao = false;
    }

    public void enviarEmailNotificandoAtivacao() throws BaseException {
        try {
            if (SimNaoEnum.getNaoShortText().equalsIgnoreCase(this.usuario.getNotificado())) {
                this.buscarEntidadePrincipal();
                EmailVo email = new EmailVo();
                email.setAssunto("Usu\u00e1rio Liberado - Alvar\u00e1 Online");
                email.setDestinatario(this.usuario.getEmail());
                email.setMensagem(EloStringUtils.replaceTemplates((String)this.getMensagemEmail(), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(email);
                this.usuario.setNotificado(SimNaoEnum.getSimShortText());
                this.salvarUsuario();
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao enviar e-mail de notifica\u00e7\u00e3o.");
        }
    }

    private String getMensagemEmail() throws BaseException {
        StringBuilder mensagem = new StringBuilder();
        mensagem.append("<div style='font-family: Arial, times, Serif;'>");
        mensagem.append("<b>Prezado(a) Sr.(a):</b>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("O seu usu\u00e1rio " + this.usuario.getNome() + " foi ativado com sucesso.");
        mensagem.append("<br>");
        mensagem.append("Para acessar o Alvar\u00e1 Online, <a href='" + PortalUtils.getUrlApplicacao() + "'>clique aqui e fa\u00e7a login</a>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Atenciosamente,");
        mensagem.append("<br>");
        mensagem.append("<p><b>" + this.entidadePrincipal.getNome() + "</b></p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<h5>Obs.: Esta \u00e9 uma mensagem autom\u00e1tica, por favor n\u00e3o responda este e-mail.</h5>");
        mensagem.append("</div>");
        return mensagem.toString();
    }
}

