/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.CadastroMobiliarioController;
import br.com.elotech.portalarrecadacao.controller.ConsultaCpfCnpjController;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoSegmentoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.math.EloNumberUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloController(value="informacoesAtividadesController")
@Scope(value="flow")
public class InformacoesAtividadesController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BigDecimal AREA_MAXIMA = new BigDecimal("999999");
    private boolean naveSuperior500m;
    private boolean comercioGas;
    private BigDecimal areaConstruida;
    private BigDecimal areaPatio;
    private boolean exibirInformacoesRIV;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private CadastroMobiliarioController cadastroMobiliarioController;
    @Resource
    private ConsultaCpfCnpjController consultaCpfCnpjController;
    @Resource
    private EntidadeController entidadeController;
    private TipoSegmentoEntity tipoSegmentoSelecionado;

    public TipoSegmentoEntity getTipoSegmentoSelecionado() {
        return this.tipoSegmentoSelecionado;
    }

    public void setTipoSegmentoSelecionado(TipoSegmentoEntity tipoSegmentoSelecionado) {
        this.tipoSegmentoSelecionado = tipoSegmentoSelecionado;
    }

    public void setConsultaCpfCnpjController(ConsultaCpfCnpjController consultaCpfCnpjController) {
        this.consultaCpfCnpjController = consultaCpfCnpjController;
    }

    public boolean isNaveSuperior500m() {
        return this.naveSuperior500m;
    }

    public void setNaveSuperior500m(boolean naveSuperior500m) {
        this.naveSuperior500m = naveSuperior500m;
    }

    public boolean isComercioGas() {
        return this.comercioGas;
    }

    public void setComercioGas(boolean comercioGas) {
        this.comercioGas = comercioGas;
    }

    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    public BigDecimal getAreaPatio() {
        return this.areaPatio;
    }

    public void setAreaPatio(BigDecimal areaPatio) {
        this.areaPatio = areaPatio;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public String avancar() throws BaseException {
        this.solicitacaoAlvara.setAreaConstruida(this.areaConstruida == null ? BigDecimal.ZERO : this.areaConstruida);
        this.solicitacaoAlvara.setAreaPatio(this.areaPatio == null ? BigDecimal.ZERO : this.areaPatio);
        if (this.solicitacaoAlvara.getAreaConstruida().add(this.solicitacaoAlvara.getAreaPatio()).compareTo(this.AREA_MAXIMA) <= 0) {
            if (this.solicitacaoAlvara.isNaturezaMudancaEndereco() && !this.solicitacaoAlvara.isNaturezaAlteracaoAtividade()) {
                return "toFinalizaConsulta";
            }
            if (this.naveSuperior500m) {
                this.solicitacaoAlvara.setRivNaveAcima500m(SimNaoEnum.SIM.getShortText());
            } else {
                this.solicitacaoAlvara.setRivNaveAcima500m(SimNaoEnum.NAO.getShortText());
            }
            if (this.comercioGas) {
                this.solicitacaoAlvara.setRivGasAcima1560k(SimNaoEnum.SIM.getShortText());
            } else {
                this.solicitacaoAlvara.setRivGasAcima1560k(SimNaoEnum.NAO.getShortText());
            }
            return "toAlteracaoAtividades";
        }
        ShowMessage.addErrorMessage((String)"validacao", (String)"A soma das \u00e1reas \u00e9 muito grande, verifique!");
        return "";
    }

    public void iniciar() throws BaseException {
        this.solicitacaoAlvara = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (this.solicitacaoAlvara.isNaturezaInicial()) {
            this.areaConstruida = EloNumberUtils.isBiggerThanZero((Number)this.solicitacaoAlvara.getAreaConstruida()) != false ? this.solicitacaoAlvara.getAreaConstruida() : BigDecimal.ZERO;
            this.areaPatio = EloNumberUtils.isBiggerThanZero((Number)this.solicitacaoAlvara.getAreaPatio()).booleanValue() ? this.solicitacaoAlvara.getAreaPatio() : BigDecimal.ZERO;
        } else {
            if (EloNumberUtils.isBiggerThanZero((Number)this.solicitacaoAlvara.getAreaConstruida()).booleanValue()) {
                this.areaConstruida = this.solicitacaoAlvara.getAreaConstruida();
            } else {
                BigDecimal bigDecimal = this.areaConstruida = this.solicitacaoAlvara.getCadastroMobiliario().getAreaConstruida() != null ? this.solicitacaoAlvara.getCadastroMobiliario().getAreaConstruida() : BigDecimal.ZERO;
            }
            this.areaPatio = EloNumberUtils.isBiggerThanZero((Number)this.solicitacaoAlvara.getAreaPatio()) != false ? this.solicitacaoAlvara.getAreaPatio() : (this.solicitacaoAlvara.getCadastroMobiliario().getAreaPatio() != null ? this.solicitacaoAlvara.getCadastroMobiliario().getAreaPatio() : BigDecimal.ZERO);
        }
        this.exibirInformacoesRIV = this.isExibirInformacoesRIV();
    }

    public boolean desabilitaAreaPatio() {
        return !this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
    }

    public boolean desabilitaAreaConstruida() {
        return !this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
    }

    public boolean desabilitaIgreja() {
        return !this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA});
    }

    public boolean desabilitaComercioGas() {
        return !this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA});
    }

    public boolean renderizaPanelRIV() throws BaseException {
        return !this.solicitacaoAlvara.isSolicitacaoCBO() && this.exibirInformacoesRIV;
    }

    public Boolean mostraInformacoesAtividades() {
        this.solicitacaoAlvara = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (this.solicitacaoAlvara.isSolicitacaoJuridicaNormal() && !this.solicitacaoAlvara.isPossuiPontoReferencia()) {
            if (this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
                return true;
            }
            if (this.solicitacaoAlvara.isAlteracaoRazaoOuRazaoESocio()) {
                return true;
            }
        } else {
            if (this.solicitacaoAlvara.isSolicitacaoPrestadorServico() || this.solicitacaoAlvara.isSolicitacaoMEIPrestador()) {
                this.solicitacaoAlvara.setAreaConstruida(BigDecimal.ZERO);
                this.solicitacaoAlvara.setAreaPatio(BigDecimal.ZERO);
                return false;
            }
            if (this.solicitacaoAlvara.isSolicitacaoMEINormal()) {
                return this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && !this.solicitacaoAlvara.isPossuiPontoReferencia();
            }
            if (this.solicitacaoAlvara.isSolicitacaoCBO()) {
                return this.solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO});
            }
        }
        return false;
    }

    public boolean isAlteracaoRazaoOuRazaoESocio() {
        return this.solicitacaoAlvara.isAlteracaoRazaoOuRazaoESocio();
    }

    private boolean isExibirInformacoesRIV() throws BaseException {
        try {
            ParametroAlvaraEntity param = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(this.entidadeController.getEntidade(), ParametroAlvaraEnum.EXIBIR_INFORMACOES_RIV);
            if (param != null) {
                return SimNaoEnum.SIM.getShortText().equals(param.getValor());
            }
            throw new SolicitacaoAlvaraException(String.format("Par\u00e2metro  %s n\u00e3o configurado.", ParametroAlvaraEnum.EXIBIR_INFORMACOES_RIV));
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao carregar o par\u00e2metro %s.", ParametroAlvaraEnum.EXIBIR_INFORMACOES_RIV));
        }
    }
}

