/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.LoginPortalArrecadacao;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeLoginPortal;
import br.com.elotech.portalarrecadacao.facade.FacadeMenu;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.common.MenuComponent;
import br.com.elotech.tributacao.domain.ParametroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.ParametroEntidadeExercicioEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloStringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.webflow.context.ExternalContext;

@EloController(value="entidadeController")
@Scope(value="session")
public class EntidadeController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MODULO = "90";
    private EntidadeAiseEntity entidade;
    private EntidadeTributacaoEntity entidadeTributacao;
    private Long numeroConsultaPrevia;
    private Long exercicioSolicitacao;
    private ParametroGeralEntity parametro;
    private List<ParametroEntidadeExercicioEntity> listaParametros;
    private boolean navMenu = true;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    private StreamedContent imagemRestricaoPerimetro;
    private String cnpjConsultaPrevia;
    private transient StreamedContent imagemCadastroImobiliario;
    private transient StreamedContent imagemCadastroImobiliarioAtividadeNaoPermitida;
    private String nomeBaseHomologacao;
    private Boolean verificaIntegradoGeo = null;
    private boolean registroValido = false;
    private boolean exibirAcessoContribuinte = false;
    private boolean verificarCpfConsultaParaImprimirAlvara = false;
    private MenuComponent menu = new MenuComponent();

    public long geraNumeroAleatorio() {
        return System.currentTimeMillis();
    }

    public boolean isNavMenu() {
        this.imagemCadastroImobiliario = null;
        this.imagemRestricaoPerimetro = null;
        this.imagemCadastroImobiliarioAtividadeNaoPermitida = null;
        return this.navMenu;
    }

    public void setNavMenu(boolean navMenu) {
        this.navMenu = navMenu;
    }

    public String getCnpjConsultaPrevia() {
        return this.cnpjConsultaPrevia;
    }

    public void setCnpjConsultaPrevia(String cnpjConsultaPrevia) {
        this.cnpjConsultaPrevia = cnpjConsultaPrevia;
    }

    public String getNomeBaseHomologacao() throws BaseException {
        this.nomeBaseHomologacao = "";
        if (this.isBaseHomologacao()) {
            this.nomeBaseHomologacao = "BASE DE TESTES";
        }
        return this.nomeBaseHomologacao;
    }

    public boolean isBaseHomologacao() throws BaseException {
        String valor = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getParametroGeralPorModulo(MODULO, "BASEHOMOLOGACAO");
        return SimNaoEnum.equalSim((String)valor);
    }

    public void setBaseHomologacao(String baseHomologacao) {
        this.nomeBaseHomologacao = baseHomologacao;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public StreamedContent getImagemRestricaoPerimetro() {
        return this.imagemRestricaoPerimetro;
    }

    public void setImagemRestricaoPerimetro(StreamedContent imagemRestricaoPerimetro) {
        this.imagemRestricaoPerimetro = imagemRestricaoPerimetro;
    }

    public StreamedContent getImagemCadastroImobiliario() {
        return this.imagemCadastroImobiliario;
    }

    public void setImagemCadastroImobiliario(StreamedContent imagemCadastroImobiliario) {
        this.imagemCadastroImobiliario = imagemCadastroImobiliario;
    }

    public Long getExercicioSolicitacao() {
        return this.exercicioSolicitacao;
    }

    public void setExercicioSolicitacao(Long exercicioSolicitacao) {
        this.exercicioSolicitacao = exercicioSolicitacao;
    }

    public Long getNumeroConsultaPrevia() {
        return this.numeroConsultaPrevia;
    }

    public void setNumeroConsultaPrevia(Long numeroConsultaPrevia) {
        this.numeroConsultaPrevia = numeroConsultaPrevia;
    }

    public EntidadeAiseEntity getEntidade() throws BaseException {
        if (this.entidade == null) {
            this.entidade = this.carregaEntidade().getId().getEntidade();
        }
        return this.entidade;
    }

    public void setEntidade(EntidadeAiseEntity entidade) {
        this.entidade = entidade;
    }

    public EntidadeTributacaoEntity getEntidadeTributacao() {
        return this.entidadeTributacao;
    }

    public void setEntidadeTributacao(EntidadeTributacaoEntity entidadeTributacao) {
        this.entidadeTributacao = entidadeTributacao;
    }

    public ParametroGeralEntity getParametro() {
        return this.parametro;
    }

    public void setParametro(ParametroGeralEntity parametro) {
        this.parametro = parametro;
    }

    public List<ParametroEntidadeExercicioEntity> getListaParametros() {
        return this.listaParametros;
    }

    public void setListaParametros(List<ParametroEntidadeExercicioEntity> listaParametros) {
        this.listaParametros = listaParametros;
    }

    public boolean isRegistroValido() {
        try {
            if (!this.registroValido) {
                this.verificarRegistroDoSistema();
            }
            return this.registroValido;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void setRegistroValido(boolean registroValido) {
        this.registroValido = registroValido;
    }

    public EntidadeTributacaoEntity carregaEntidade() throws BaseException {
        if (this.entidadeTributacao == null) {
            this.entidadeTributacao = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade();
        }
        return this.entidadeTributacao;
    }

    public Boolean getVerificaIntegradoGeo() throws BaseException {
        if (this.verificaIntegradoGeo == null) {
            this.verificaIntegradoGeo = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).verificaIntegradoGeo();
        }
        return this.verificaIntegradoGeo;
    }

    public Boolean getVerificaIntegradoLoginExterno() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).verificaIntegradoLoginExterno();
    }

    public void carregaParametros() throws BaseException {
        this.listaParametros = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).carregaParametros(this.getEntidade().getId(), Long.valueOf(EloDateUtils.getYear((Date)new Date())));
    }

    public String getValorParametro(String param) throws BaseException {
        if (this.listaParametros == null) {
            this.carregaParametros();
        }
        for (ParametroEntidadeExercicioEntity parametro : this.listaParametros) {
            if (!param.equals(parametro.getId().getParametro())) continue;
            return parametro.getValor();
        }
        return null;
    }

    public StreamedContent getBrasao() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.getEntidade().getBrasao());
        return new DefaultStreamedContent((InputStream)is, "image/jpg", "brasao.jpg");
    }

    public boolean isExibirAcessoContribuinte() {
        return this.exibirAcessoContribuinte;
    }

    public void setExibirAcessoContribuinte(boolean exibirAcessoContribuinte) {
        this.exibirAcessoContribuinte = exibirAcessoContribuinte;
    }

    public boolean isVerificarCpfConsultaParaImprimirAlvara() {
        return this.verificarCpfConsultaParaImprimirAlvara;
    }

    public void setVerificarCpfConsultaParaImprimirAlvara(boolean verificarCpfConsultaParaImprimirAlvara) {
        this.verificarCpfConsultaParaImprimirAlvara = verificarCpfConsultaParaImprimirAlvara;
    }

    public MenuComponent getMenu() {
        return this.menu;
    }

    public void setMenu(MenuComponent menu) {
        this.menu = menu;
    }

    public void verificarRegistroDoSistema() throws BaseException {
        this.registroValido = ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).isRegistroSistemaValido(this.carregaEntidade(), Modulo.ALVARAONLINE.toString());
    }

    public void verificarAcessoContribuinte() throws BaseException {
        if (this.getVerificaIntegradoLoginExterno().booleanValue()) {
            String linkLoginExternoPrefeitura = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).getValorParamGeral(Modulo.ALVARAONLINE.getCodigo(), "LINKLOGINEXTERNO");
            this.exibirAcessoContribuinte = StringUtils.isNotBlank((CharSequence)linkLoginExternoPrefeitura);
        }
    }

    public void getRequestParameter(String name, ExternalContext context) throws BaseException {
        this.verificarCpfConsultaParaImprimirAlvara = false;
        try {
            String token = context.getRequestParameterMap().get(name);
            if (StringUtils.isNotBlank((CharSequence)token) && this.getVerificaIntegradoLoginExterno().booleanValue()) {
                JSONObject objetoJson = ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).getUsuarioByToken(Modulo.ALVARAONLINE.getCodigo(), token);
                if (Objects.nonNull(objetoJson) && objetoJson.has("status")) {
                    if (objetoJson.getString("status").equalsIgnoreCase("ok")) {
                        this.verificarCpfConsultaParaImprimirAlvara = true;
                        String cpf = this.tratarCpf((String)objetoJson.get("cpf"));
                        Optional<PessoaEntity> pessoa = Optional.ofNullable(this.getPessoa(cpf));
                        UsuarioEntity usuario = ((FacadeLoginPortal)SpringContext.getBean(FacadeLoginPortal.class)).criaUsuarioPorToken(token, pessoa);
                        if (usuario == null) {
                            ShowMessage.addErrorMessage((String)"validacaows", (String)"Usu\u00e1rio n\u00e3o foi Autenticado!");
                        } else {
                            UsuarioEntity user = usuario;
                            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities()));
                            this.logger.info((Object)(" ## USUARIO logado " + usuario.getUsuario()));
                            ((LoginPortalArrecadacao)SpringContext.getBean(LoginPortalArrecadacao.class)).setLogado(Boolean.valueOf(true));
                            ((LoginPortalArrecadacao)SpringContext.getBean(LoginPortalArrecadacao.class)).setNomeUsuarioLogado(usuario.getPessoa().getNome());
                            this.verificarCpfConsultaParaImprimirAlvara = true;
                        }
                    } else {
                        StringBuilder messagem = new StringBuilder("");
                        messagem.append("N\u00e3o foi poss\u00edvel autenticar o usu\u00e1rio com status ");
                        messagem.append(objetoJson.getString("status") + ". ");
                        messagem.append("Clique em Acesso Contribuinte.");
                        ShowMessage.addWarnMessage((String)"validacaows", (String)messagem.toString());
                    }
                } else {
                    this.logger.info((Object)("JSONObject: " + objetoJson));
                    ShowMessage.addWarnMessage((String)"validacaows", (String)"N\u00e3o foi poss\u00edvel obter os dados do usu\u00e1rio. Token inv\u00e1lido.");
                }
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacaows", (String)("N\u00e3o foi poss\u00edvel obter o dados do usu\u00e1rio. " + e.getMessage()));
            this.logger.error((Object)"Erro ao obter dados do usu\u00e1rio", (Throwable)e);
            this.verificarCpfConsultaParaImprimirAlvara = false;
        }
    }

    private String tratarCpf(String cpf) {
        if (!EloStringUtils.isEmpty((String)cpf) && cpf.length() < 11) {
            return StringUtils.leftPad((String)cpf, (int)11, (String)"0");
        }
        return cpf;
    }

    private PessoaEntity getPessoa(String cpf) throws BaseException {
        List pessoas = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).carregaPessoasOrderById(cpf);
        PessoaEntity pessoa = null;
        if (!EloListUtils.safeIsEmpty((List)pessoas).booleanValue()) {
            Comparator comp = (p1, p2) -> Long.compare(p1.getId(), p2.getId());
            pessoa = (PessoaEntity)pessoas.stream().max(comp).get();
        }
        return pessoa;
    }

    public void carregarParametrosMenus() throws BaseException {
        this.menu = ((FacadeMenu)SpringContext.getBean(FacadeMenu.class)).carregarMenuComponent(null);
    }

    public StreamedContent getImagemCadastroImobiliarioAtividadeNaoPermitida() {
        return this.imagemCadastroImobiliarioAtividadeNaoPermitida;
    }

    public void setImagemCadastroImobiliarioAtividadeNaoPermitida(StreamedContent imagemCadastroImobiliarioAtividadeNaoPermitida) {
        this.imagemCadastroImobiliarioAtividadeNaoPermitida = imagemCadastroImobiliarioAtividadeNaoPermitida;
    }
}

