/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.ConsultaCadastroImobiliarioController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoRedeSimDataModel;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.IndeferimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.AnexoConsultaPreviaRedeSimVo;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaPreviaVo;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.MotivoIndeferimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.DeferimentoRedeSimSigFacilException;
import br.com.elotech.portalarrecadacao.exception.IndeferimentoRedeSimSigFacilException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosConsultaPrevia;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Endereco;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Natureza_imovel;
import br.com.elotech.portalarrecadacao.integration.transformer.ProcessaConsulta;
import br.com.elotech.portalarrecadacao.utils.JsonUtils;
import br.com.elotech.portalarrecadacao.utils.faces.FacesUtil;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.interfaces.Testada;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@EloController(value="consultaRedeSimController")
@Scope(value="flow")
public class ConsultaRedeSimController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 7809900820490092087L;
    private List<SolicitacaoRedeSimEntity> consultasRedeSim;
    private int currentIndex;
    private SolicitacaoRedeSimEntity consultaRedeSimAtual;
    private FiltroConsultaRedeSim filtro;
    private Boolean mostraMotivoIndeferimento;
    private ConsultaPreviaDTO arquivoConsultaRedeSim;
    private String arquivoConsultaNomeCidade;
    private List<String> tiposSituacoes;
    private List<String> tiposSituacoesSelecionadas;
    private Date dataInicial;
    private Date dataFinal;
    private String nomeSolicitante;
    private String protocolo;
    private IndeferimentoRedeSimEntity indeferimentoSelecionado;
    private List<IndeferimentoRedeSimEntity> codigosIndeferimento;
    private String msgRedirect;
    private List<AnexoConsultaPreviaRedeSimVo> anexosConsulta;
    private static final String TIPO_NATUREZA_RURAL = "1";
    private List<CadastroMobiliarioEntity> listagemCadastrosMobiliario;
    private CadastroMobiliarioEntity cadastroMobiliarioSelecionado;
    @Resource
    private ConsultaCadastroImobiliarioController cadastroImobiliarioController;
    private SolicitacaoRedeSimDataModel solicitacaoRedeSimDataModel;

    public CadastroMobiliarioEntity getCadastroMobiliarioSelecionado() {
        return this.cadastroMobiliarioSelecionado;
    }

    public void setCadastroMobiliarioSelecionado(CadastroMobiliarioEntity cadastroMobiliarioSelecionado) {
        this.cadastroMobiliarioSelecionado = cadastroMobiliarioSelecionado;
    }

    public void iniciar() throws BaseException {
        this.mostraMotivoIndeferimento = false;
        this.currentIndex = 0;
        this.limparCampos();
        this.filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        this.filtro.setTipo("C");
        this.filtro.setMaisAntigas(false);
        this.filtro.setAtivo("");
        this.getTiposSituacoesRedePrevia();
        this.pesquisar();
    }

    private void recuperarCadastroMobiliario() throws BaseException {
        this.listagemCadastrosMobiliario = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getCadastroMobiliarioPorCpfCnpj(this.arquivoConsultaRedeSim.getDados_consulta_previa().getNu_cnpj());
    }

    public List<SolicitacaoRedeSimEntity> getConsultasRedeSim() {
        return this.consultasRedeSim;
    }

    public void setConsultasRedeSim(List<SolicitacaoRedeSimEntity> consultasRedeSim) {
        this.consultasRedeSim = consultasRedeSim;
    }

    public SolicitacaoRedeSimEntity getConsultaRedeSimAtual() {
        return this.consultaRedeSimAtual;
    }

    public void setConsultaRedeSimAtual(SolicitacaoRedeSimEntity consultaRedeSimAtual) {
        this.consultaRedeSimAtual = consultaRedeSimAtual;
    }

    public List<CadastroMobiliarioEntity> getListagemCadastrosMobiliario() {
        return this.listagemCadastrosMobiliario;
    }

    public void setListagemCadastrosMobiliario(List<CadastroMobiliarioEntity> listagemCadastrosMobiliario) {
        this.listagemCadastrosMobiliario = listagemCadastrosMobiliario;
    }

    public void processarConsulta() {
        if (Objects.nonNull(this.solicitacaoRedeSimDataModel) && EloListUtils.safeIsEmpty((List)this.solicitacaoRedeSimDataModel.getDados().getData()).booleanValue()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o tem registro na lista para ser processado!");
            return;
        }
        if (Objects.nonNull(this.solicitacaoRedeSimDataModel) && !EloListUtils.safeIsEmpty((List)this.solicitacaoRedeSimDataModel.getDados().getData()).booleanValue() && !this.solicitacaoRedeSimDataModel.getDados().getData().stream().anyMatch(p -> SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla().equals(p.getSituacao()))) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o tem nenhum registro em an\u00e1lise para ser processado.");
            return;
        }
        ProcessaConsulta processaConsulta = (ProcessaConsulta)SpringContext.getBean(ProcessaConsulta.class);
        for (SolicitacaoRedeSimEntity consultaprevia : this.solicitacaoRedeSimDataModel.getDados().getData()) {
            if (!SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla().equals(consultaprevia.getSituacao())) continue;
            this.logger.info((Object)("#### INICIANDO PROCESSAR MANUAL Protocolo: " + consultaprevia.getProtocolo()));
            try {
                ConsultaPreviaDTO consultaPreviaDTO = (ConsultaPreviaDTO)EloJsonUtils.fromJson((String)consultaprevia.getArquivoConsulta(), ConsultaPreviaDTO.class);
                processaConsulta.process(consultaPreviaDTO);
            }
            catch (Exception e) {
                this.logger.error((Object)String.format("Erro no reprocessamento da consulta pr\u00e9via: %s", e.getMessage()), (Throwable)e);
            }
            this.logger.info((Object)("#### FINALIZANDO PROCESSAR MANUAL Protocolo: " + consultaprevia.getProtocolo()));
        }
        ShowMessage.addInfoMessage((String)"validacao", (String)"Processamento conclu\u00eddo, caso o registro continue em an\u00e1lise, verifique o log");
    }

    public void redirectToConsultaIndividual() throws BaseException {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        RequestControlContext rec = (RequestControlContext)requestContext;
        this.arquivoConsultaRedeSim = (ConsultaPreviaDTO)EloJsonUtils.fromJson((String)this.consultaRedeSimAtual.getArquivoConsulta(), ConsultaPreviaDTO.class);
        this.mostraMotivoIndeferimento = this.consultaRedeSimAtual.isIndeferido();
        this.montarAnexosVo();
        rec.handleEvent(new Event((Object)this, "toConsultaPreviaIndividualRedeSim"));
        this.recuperarCadastroMobiliario();
    }

    private void montarAnexosVo() {
        if (this.arquivoConsultaRedeSim.getDados_consulta_previa().getUtilizacao_solo() != null) {
            try {
                this.anexosConsulta = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).montarAnexoConsultaVo(this.arquivoConsultaRedeSim);
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            }
        }
    }

    public FiltroConsultaRedeSim getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroConsultaRedeSim filtro) {
        this.filtro = filtro;
    }

    public Boolean getMostraMotivoIndeferimento() {
        return this.mostraMotivoIndeferimento;
    }

    public void setMostraMotivoIndeferimento(Boolean mostraMotivoIndeferimento) {
        this.mostraMotivoIndeferimento = mostraMotivoIndeferimento;
    }

    public List<IndeferimentoRedeSimEntity> complete(String query) {
        List indeferimentos = null;
        try {
            indeferimentos = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getDescIndeferimentoRedeSim(query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return indeferimentos;
    }

    public void toggleMotivoIndeferimento() {
        this.mostraMotivoIndeferimento = this.mostraMotivoIndeferimento == false;
        try {
            this.indeferimentoSelecionado = new IndeferimentoRedeSimEntity();
            this.consultaRedeSimAtual.setMotivoIndeferimento(null);
            this.codigosIndeferimento = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).findAllIndeferimentoRedeSim();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getTiposSituacoes() {
        return this.tiposSituacoes;
    }

    public void setTiposSituacoes(List<String> tiposSituacoes) {
        this.tiposSituacoes = tiposSituacoes;
    }

    public List<String> getTiposSituacoesSelecionadas() {
        return this.tiposSituacoesSelecionadas;
    }

    public void setTiposSituacoesSelecionadas(List<String> tiposSituacoesSelecionadas) {
        this.tiposSituacoesSelecionadas = tiposSituacoesSelecionadas;
    }

    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getNomeSolicitante() {
        return this.nomeSolicitante;
    }

    public void setNomeSolicitante(String nomeSolicitante) {
        this.nomeSolicitante = nomeSolicitante;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public ConsultaCadastroImobiliarioController getCadastroImobiliarioController() {
        return this.cadastroImobiliarioController;
    }

    public void setCadastroImobiliarioController(ConsultaCadastroImobiliarioController cadastroImobiliarioController) {
        this.cadastroImobiliarioController = cadastroImobiliarioController;
    }

    public List<SolicitacaoRedeSimEntity> carregarListaConsultasRedeSim() throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarListaConsultaRedesim(this.filtro);
    }

    public String arquivoConsultaGetNomeCidade(long codigo, boolean comDigitoVerificador) throws BaseException {
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getNomeCidade(codigo, comDigitoVerificador);
    }

    public String getNomeSolicitante(SolicitacaoRedeSimEntity solicitacao) {
        ConsultaPreviaDTO arquivoConsultaRedeSim = (ConsultaPreviaDTO)EloJsonUtils.fromJson((String)solicitacao.getArquivoConsulta(), ConsultaPreviaDTO.class);
        return arquivoConsultaRedeSim.getDados_consulta_previa().getSolicitante().getDs_nome();
    }

    public String arquivoConsultaGetDescricaoCnae(String codigoAtividade) {
        String descricaoCnae = null;
        try {
            codigoAtividade = codigoAtividade.replace("/", "").replace("-", "");
            descricaoCnae = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getDescricaoCnae(codigoAtividade);
        }
        catch (BaseException e) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Filtro de pesquisa inv\u00e1lido. Preencha ao menos um campo.");
        }
        return descricaoCnae;
    }

    public String arquivoConsultaGetDescricaoEventoRedeSim(Long eventoCodigo) throws BaseException {
        EventoRedeSimEntity evento = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getEventoRedeSim(eventoCodigo);
        if (evento != null) {
            return evento.getDescricao();
        }
        return null;
    }

    public String arquivoConsultaGetDescNatJur(String id) throws BaseException {
        id = id.replace("-", "");
        NaturezaJuridicaEntity naturezaJuridica = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getNaturezaJuridica(id);
        if (naturezaJuridica != null) {
            return naturezaJuridica.getDescricao();
        }
        return null;
    }

    public ConsultaPreviaDTO getArquivoConsultaRedeSim() {
        return this.arquivoConsultaRedeSim;
    }

    public void setArquivoConsultaRedeSim(ConsultaPreviaDTO arquivoConsultaRedeSim) {
        this.arquivoConsultaRedeSim = arquivoConsultaRedeSim;
    }

    public IndeferimentoRedeSimEntity getIndeferimentoSelecionado() {
        return this.indeferimentoSelecionado;
    }

    public void setIndeferimentoSelecionado(IndeferimentoRedeSimEntity indeferimentoSelecionado) {
        this.indeferimentoSelecionado = indeferimentoSelecionado;
    }

    public List<IndeferimentoRedeSimEntity> getCodigosIndeferimento() {
        return this.codigosIndeferimento;
    }

    public void setCodigosIndeferimento(List<IndeferimentoRedeSimEntity> codigosIndeferimento) {
        this.codigosIndeferimento = codigosIndeferimento;
    }

    public String getArquivoConsultaNomeCidade() {
        return this.arquivoConsultaNomeCidade;
    }

    public void setArquivoConsultaNomeCidade(String arquivoConsultaNomeCidade) {
        this.arquivoConsultaNomeCidade = arquivoConsultaNomeCidade;
    }

    public void buscarSolicitacoesRedeSim() throws BaseException {
        if (this.filtro.isFiltroValido().booleanValue()) {
            this.consultasRedeSim = this.carregarListaConsultasRedeSim();
            if (EloListUtils.safeIsEmpty((List)this.consultasRedeSim).booleanValue()) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Nenhum registro encontrado!");
            }
        } else {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Filtro de pesquisa inv\u00e1lido. Preencha ao menos um campo.");
        }
    }

    public void setConsultaRedeSimAtual(String cid) throws IOException {
        this.consultaRedeSimAtual = null;
        for (SolicitacaoRedeSimEntity consulta : this.consultasRedeSim) {
            if (consulta.getId() != Long.parseLong(cid)) continue;
            this.consultaRedeSimAtual = consulta;
            return;
        }
        ShowMessage.addFatalMessage((String)"validacao", (String)"Erro! Solicita\u00e7\u00e3o n\u00e3o encontrada.");
    }

    public void getTiposSituacoesRedePrevia() {
        ArrayList<String> tiposSituacoes = new ArrayList<String>();
        for (SituacaoConsultaPreviaRedeSimEnum situacaoEnums : SituacaoConsultaPreviaRedeSimEnum.getSituacoesConsultaRedeSim()) {
            tiposSituacoes.add(situacaoEnums.getTexto());
        }
        this.tiposSituacoes = tiposSituacoes;
    }

    public void limparCampos() throws BaseException {
        this.filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        this.filtro.limpar();
        this.inicializarListaSolicitacoes();
    }

    public void inicializarListaSolicitacoes() {
        this.consultaRedeSimAtual = null;
        this.tiposSituacoes = null;
        this.tiposSituacoesSelecionadas = null;
        this.arquivoConsultaRedeSim = new ConsultaPreviaDTO();
        if (this.consultasRedeSim == null) {
            this.consultasRedeSim = new ArrayList();
        } else {
            this.consultasRedeSim.clear();
        }
    }

    public List<String> getListFromTextToSigla(List<String> situacoesSelecionadas) {
        ArrayList<String> situacoesSelecionadasSiglas = new ArrayList<String>();
        for (String texto : situacoesSelecionadas) {
            situacoesSelecionadasSiglas.add(SituacaoConsultaPreviaRedeSimEnum.getSiglaFromText((String)texto));
        }
        return situacoesSelecionadasSiglas;
    }

    public void pesquisar() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.tiposSituacoesSelecionadas).booleanValue()) {
            this.filtro.setSituacao(this.getListFromTextToSigla(this.tiposSituacoesSelecionadas));
        }
        if (!this.filtro.isFiltroValido().booleanValue()) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"Filtro inv\u00e1lido.");
        }
        if (this.filtro.getDataInicial() != null && this.filtro.getDataFinal() == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione uma data final.");
            return;
        }
        this.filtro.setDataFinal(EloDateUtils.getEnd((Date)this.filtro.getDataFinal()));
        this.setSolicitacaoRedeSimDataModel(new SolicitacaoRedeSimDataModel(this.filtro));
    }

    public void limparFiltro() throws BaseException {
        this.tiposSituacoesSelecionadas = new ArrayList();
        this.dataInicial = null;
        this.dataFinal = null;
        this.nomeSolicitante = null;
        this.protocolo = null;
        this.filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        this.filtro.setTipo("C");
        this.filtro.setAtivo("");
        this.pesquisar();
    }

    private void consultaCadastroImobiliarioDialog() {
        this.cadastroImobiliarioController.setRedeSim(true);
        FacesUtil.execute((String)"consultaCadastroImobiliarioDialog.show()");
    }

    public void salvarSolicitacaoRedeSim(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        try {
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarConsultaPrevia(solicitacaoAlvara, Boolean.valueOf(true));
            if (this.isIntegradoGeo()) {
                StringBuilder obs = new StringBuilder();
                obs.append(UtilsController.montarObservacaoGeral());
                obs.append(UtilsController.getRestricaoCadastro((SolicitacaoAlvaraEntity)solicitacaoAlvara));
                obs.append(solicitacaoAlvara.getObservacaoDasAtividades(Boolean.TRUE.booleanValue()));
                obs.append(Objects.nonNull(solicitacaoAlvara.getExigencias()) ? solicitacaoAlvara.getExigencias() : "");
                this.consultaRedeSimAtual.setObservacao(obs.toString());
            }
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarConsultaPrevia(solicitacaoAlvara, Boolean.valueOf(true));
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).respostaSolicitacaoRedeSim(this.consultaRedeSimAtual);
            this.completeDeferimentoConsultaPrevia();
        }
        catch (DeferimentoRedeSimSigFacilException ex) {
            this.logger.info((Object)ex.getMessage(), (Throwable)ex);
            FacesUtil.execute((String)"PF('dlgQuestionDeferimento').show();");
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isIntegradoGeo() throws BaseException {
        return ((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).verificaIntegradoGeo();
    }

    public void deferirSolicitacaoRedeSim() {
        try {
            this.cadastroImobiliarioController.limparInformacoesCadastroImobiliario();
            this.criarConsultaAlvara(this.consultaRedeSimAtual);
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isMostraSelecaoCadastroMob() {
        if (!SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla().equalsIgnoreCase(this.consultaRedeSimAtual.getSituacao())) {
            return false;
        }
        SolicitacaoAlvaraEntity solicitacao = this.consultaRedeSimAtual.getSolicitacaoAlvara();
        if (solicitacao == null) {
            return false;
        }
        return EloListUtils.safeIsEmpty((List)this.listagemCadastrosMobiliario) == false && Objects.isNull(solicitacao.getCadastroMobiliario());
    }

    public SolicitacaoAlvaraEntity consultaAlvaraTemplate(SolicitacaoRedeSimEntity consultaRedeSim) throws BaseException {
        try {
            if (Objects.isNull(this.cadastroImobiliarioController.getCadastroImobiliario()) && !this.isRural(consultaRedeSim)) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um cadastro imobili\u00e1rio.");
                return null;
            }
            if (!UtilsController.isUtilizaEnderecoCadastroGeral() && this.cadastroImobiliarioController.getSelectedTestada() == null && !this.isRural(consultaRedeSim)) {
                ShowMessage.addErrorMessage((String)"validacao", (String)"Testada principal n\u00e3o encontrada no cadastro imobili\u00e1rio.");
                return null;
            }
            SolicitacaoAlvaraEntity solicitacaoAlvara = consultaRedeSim.getSolicitacaoAlvara();
            ConsultaPreviaDTO consultaPreviaDTO = (ConsultaPreviaDTO)EloJsonUtils.fromJson((String)consultaRedeSim.getArquivoConsulta(), ConsultaPreviaDTO.class);
            consultaRedeSim.setIndeferido(SimNaoEnum.NAO.getShortText());
            ProcessaConsulta processaConsulta = (ProcessaConsulta)SpringContext.getBean(ProcessaConsulta.class);
            CadastroImobiliarioEntity cie = this.cadastroImobiliarioController.getCadastroImobiliario();
            if (SimNaoEnum.equalNao((String)consultaRedeSim.getResposta()).booleanValue()) {
                ConsultaPreviaVo consultaPreviaVo = processaConsulta.getConsultaPreviaVo(consultaPreviaDTO, this.consultaRedeSimAtual);
                if (Objects.nonNull(consultaPreviaVo.getCadastroMobiliario()) && Objects.isNull(consultaPreviaVo.getCadastroMobiliario().getCadastroImobiliario()) && !this.isRural(consultaRedeSim)) {
                    consultaPreviaVo.getCadastroMobiliario().setCadastroImobiliario(cie);
                }
                if (Objects.isNull(solicitacaoAlvara)) {
                    solicitacaoAlvara = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).iniciaConsultaPrevia(consultaPreviaVo);
                    consultaRedeSim.setSolicitacaoAlvara(solicitacaoAlvara);
                }
                processaConsulta.adicionarClassificacaoTipoInscricao(consultaPreviaDTO, solicitacaoAlvara);
                solicitacaoAlvara.setCadastroImobiliario(cie);
                solicitacaoAlvara.setAreaUtilizada(processaConsulta.getValorNumerico(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNu_area_utilizada()));
                if (this.cadastroMobiliarioSelecionado != null) {
                    solicitacaoAlvara.setCadastroMobiliario(this.cadastroMobiliarioSelecionado);
                }
                if (!UtilsController.isUtilizaEnderecoCadastroGeral() && !this.isRural(consultaRedeSim)) {
                    if (UtilsController.isTestadaGenerica()) {
                        solicitacaoAlvara.setImobiliarioTestadaGenerica(cie.getTestadaPrincipalGenerica());
                    } else if (Objects.nonNull(cie.getTestadaPrincipal())) {
                        solicitacaoAlvara.setImobiliarioTestada(cie.getTestadaPrincipal());
                    } else {
                        solicitacaoAlvara.setImobiliarioTestada((CadastroImobiliarioTestadaEntity)this.cadastroImobiliarioController.getSelectedTestada());
                    }
                }
                if (!solicitacaoAlvara.isNaturezaInicial()) {
                    if (!processaConsulta.validarAlteracaoAlvaraTipoInscricaoCadastroMobiliario(solicitacaoAlvara, consultaPreviaVo.getTipoInscricaoAlvara())) {
                        throw new SolicitacaoAlvaraRedeSimException("O cadastro selecionado n\u00e3o possui Tipo de Inscri\u00e7\u00e3o permitida para altera\u00e7\u00e3o.");
                    }
                    if (solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
                        if (!this.isRural(consultaRedeSim)) {
                            solicitacaoAlvara = processaConsulta.consultaCadastroImobiliario(solicitacaoAlvara, Boolean.TRUE.booleanValue());
                        }
                        processaConsulta.processaAtividadesNaSolicitacaoAlvara(solicitacaoAlvara, consultaPreviaDTO);
                    }
                } else {
                    if (!this.isRural(consultaRedeSim)) {
                        solicitacaoAlvara = processaConsulta.consultaCadastroImobiliario(solicitacaoAlvara, Boolean.TRUE.booleanValue());
                    }
                    processaConsulta.processaAtividadesNaSolicitacaoAlvara(solicitacaoAlvara, consultaPreviaDTO);
                }
                this.salvarSolicitacaoRedeSim(solicitacaoAlvara);
            } else {
                ShowMessage.addErrorMessage((String)"validacao", (String)"A consulta j\u00e1 foi Respondida.");
            }
            return solicitacaoAlvara;
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("Ocorreu uma falha ao deferir a consulta: " + e.getMessage()));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException("Falha ao deferir a consulta", e.getCause());
        }
    }

    private boolean isRural(SolicitacaoRedeSimEntity consultaRedeSim) {
        ConsultaPreviaDTO consultaPreviaDTO = (ConsultaPreviaDTO)new Gson().fromJson(JsonUtils.sanitize((String)consultaRedeSim.getArquivoConsulta()), ConsultaPreviaDTO.class);
        return Optional.ofNullable(consultaPreviaDTO.getDados_consulta_previa()).map(DadosConsultaPrevia::getEndereco).map(Endereco::getNatureza_imovel).map(Natureza_imovel::getCo_tipo_natureza).map(tipoNatureza -> TIPO_NATUREZA_RURAL.equals(tipoNatureza)).orElse(false);
    }

    private void criarConsultaAlvara(SolicitacaoRedeSimEntity consultaRedeSim) throws BaseException {
        ConsultaPreviaDTO consultaPreviaDTO = (ConsultaPreviaDTO)EloJsonUtils.fromJson((String)consultaRedeSim.getArquivoConsulta(), ConsultaPreviaDTO.class);
        String codigoImobiliario = this.getNuInscricaoImovel(consultaPreviaDTO);
        if (codigoImobiliario != null) {
            CadastroImobiliarioEntity cadastroImobiliario = null;
            try {
                cadastroImobiliario = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getCadastroImobiliarioPorCodigo(Long.valueOf(1L), Long.valueOf(EloStringUtils.somenteNumeros((String)codigoImobiliario)));
                if (cadastroImobiliario != null) {
                    try {
                        this.cadastroImobiliarioController.setCadastroImobiliario(cadastroImobiliario);
                        this.cadastroImobiliarioController.setSelectedTestada((Testada)cadastroImobiliario.getTestadaPrincipal());
                        this.cadastroImobiliarioController.setCadastroGeral(cadastroImobiliario.getCadastroGeral().getId().getCodigo());
                        this.cadastroImobiliarioController.consultaCadastro();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                        ShowMessage.addErrorMessage((String)"validacao", (String)"Houve um erro ao consultar o Cadastro Imobili\u00e1rio.");
                    }
                }
            }
            catch (Exception e) {
                cadastroImobiliario = null;
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!this.isRural(consultaRedeSim)) {
            this.consultaCadastroImobiliarioDialog();
        } else {
            this.consultaAlvaraTemplate(consultaRedeSim);
        }
    }

    private String getNuInscricaoImovel(ConsultaPreviaDTO consultaPreviaDTO) {
        if (Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNatureza_imovel()) && Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNatureza_imovel().getNu_inscricao())) {
            return consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNatureza_imovel().getNu_inscricao();
        }
        return null;
    }

    public void confirmarIndeferimento() {
        if (this.indeferimentoSelecionado == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione um indeferimento.");
            return;
        }
        try {
            if (MotivoIndeferimentoRedeSimEnum.OUTROS.getCodigo().equals(this.indeferimentoSelecionado.getCodigo()) && EloStringUtils.isEmpty((String)this.consultaRedeSimAtual.getMotivoIndeferimento())) {
                ShowMessage.addInfoMessage((String)"validacao", (String)"Adicione uma observa\u00e7\u00e3o.");
            } else {
                this.consultaRedeSimAtual.setIndeferido(SimNaoEnum.SIM.getShortText());
                this.consultaRedeSimAtual.setIndeferimentos((List)Lists.newArrayList((Object[])new IndeferimentoRedeSimEntity[]{this.indeferimentoSelecionado}));
                this.consultaRedeSimAtual.setSituacao(SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO.getSigla());
                this.consultaRedeSimAtual.setUsuarioTramitacao(UtilsController.usuarioAutenticado().getUsuario());
                this.consultaRedeSimAtual.setDataTramitacao(new Date());
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).respostaSolicitacaoRedeSim(this.consultaRedeSimAtual);
                this.completeIndeferimentoConsultaPrevia();
            }
        }
        catch (IndeferimentoRedeSimSigFacilException ex) {
            this.logger.info((Object)ex.getMessage(), (Throwable)ex);
            this.consultaRedeSimAtual.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            FacesUtil.execute((String)"PF('dlgQuestionIndeferimento').show();");
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.consultaRedeSimAtual.setIndeferido(SimNaoEnum.getNaoShortText());
            this.consultaRedeSimAtual.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
        }
    }

    public void redirectNovaConsulta() throws BaseException {
        Optional solicitacao;
        if (this.consultasRedeSim != null && (solicitacao = this.getSolicitacoesEmAnaliseOrdenadaPorData()).isPresent()) {
            this.setConsultaRedeSimAtual((SolicitacaoRedeSimEntity)solicitacao.get());
            this.redirectToConsultaIndividual();
            return;
        }
        FacesUtil.execute((String)"PF('dlgRedirectNovaConsulta').hide();");
        FacesUtil.execute((String)"PF('naoHaMaisConsultasDialog').show();");
    }

    public void visualizarArquivoAnexo(String url) {
        try {
            String token = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SERVER_TOKEN_CONSULTA_PREVIA_REDESIM).getValor();
            UtilsController.imprimirRelatorio((byte[])((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).visualizarArquivoAnexo(url, token));
        }
        catch (BaseException | IOException e) {
            this.logger.error((Object)e.getMessage(), e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    protected Optional<SolicitacaoRedeSimEntity> getSolicitacoesEmAnaliseOrdenadaPorData() {
        return this.getSolicitacaoDataModel().stream().filter(p -> SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla().equals(p.getSituacao())).sorted(Comparator.comparing(SolicitacaoRedeSimEntity::getId).reversed()).findFirst();
    }

    public SolicitacaoRedeSimDataModel getSolicitacaoRedeSimDataModel() {
        return this.solicitacaoRedeSimDataModel;
    }

    public void setSolicitacaoRedeSimDataModel(SolicitacaoRedeSimDataModel solicitacaoRedeSimDataModel) {
        this.solicitacaoRedeSimDataModel = solicitacaoRedeSimDataModel;
    }

    public String getMsgRedirect() {
        return this.msgRedirect;
    }

    public void setMsgRedirect(String msgRedirect) {
        this.msgRedirect = msgRedirect;
    }

    public List<SolicitacaoRedeSimEntity> getSolicitacaoDataModel() {
        return this.getSolicitacaoRedeSimDataModel().getDados().getData();
    }

    public List<AnexoConsultaPreviaRedeSimVo> getAnexosConsulta() {
        return this.anexosConsulta;
    }

    public void setAnexosConsulta(List<AnexoConsultaPreviaRedeSimVo> anexosConsulta) {
        this.anexosConsulta = anexosConsulta;
    }

    public String getIdRespostaIntegracao() {
        if (Objects.nonNull(this.consultaRedeSimAtual) && Objects.nonNull(this.consultaRedeSimAtual.getIdRespostaConsulta())) {
            return Long.toString(this.consultaRedeSimAtual.getIdRespostaConsulta());
        }
        return "";
    }

    public void completeDeferimentoConsultaPrevia() throws BaseException {
        this.saveDeferimentoConsulta();
        this.setMsgRedirect("Deferimento Realizado com Sucesso!");
        FacesUtil.execute((String)"consultaCadastroImobiliarioDialog.hide()");
        FacesUtil.execute((String)"dlgRedirectNovaConsulta.show()");
    }

    public SolicitacaoRedeSimEntity saveDeferimentoConsulta() throws BaseException {
        this.consultaRedeSimAtual.setSituacao(SituacaoConsultaPreviaRedeSimEnum.DEFERIDO.getSigla());
        this.consultaRedeSimAtual.setUsuarioTramitacao(UtilsController.usuarioAutenticado().getUsuario());
        this.consultaRedeSimAtual.setDataTramitacao(new Date());
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.consultaRedeSimAtual);
        this.consultaRedeSimAtual.setResposta(SimNaoEnum.SIM.getShortText());
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.consultaRedeSimAtual);
    }

    public void completeIndeferimentoConsultaPrevia() throws BaseException {
        this.saveIndeferimentoConsulta();
        this.setMsgRedirect("Indeferimento Realizado com Sucesso!");
        FacesUtil.execute((String)"dlgRedirectNovaConsulta.show()");
    }

    private SolicitacaoRedeSimEntity saveIndeferimentoConsulta() throws BaseException {
        this.consultaRedeSimAtual.setResposta(SimNaoEnum.NAO.getShortText());
        this.consultaRedeSimAtual.setSituacao(SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO.getSigla());
        this.mostraMotivoIndeferimento = false;
        return ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.consultaRedeSimAtual);
    }

    public void ativarOrDesativarConsultaShowDialog(SolicitacaoRedeSimEntity consulta) {
        try {
            this.setConsultaRedeSimAtual(consulta);
            SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(consulta.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            if (Objects.nonNull(solicitacaoRedeSim)) {
                FacesUtil.execute((String)"dlgConsultaAtivaInativa.show()");
                return;
            }
            this.ativarOrDesativarConsulta();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao salvar.");
        }
    }

    public void ativarOrDesativarConsulta() throws BaseException {
        try {
            SolicitacaoRedeSimEntity solicitacaoRedeSim = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(this.consultaRedeSimAtual.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            this.consultaRedeSimAtual.setAtivo(!this.consultaRedeSimAtual.isAtivo());
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(this.consultaRedeSimAtual);
            if (Objects.nonNull(solicitacaoRedeSim)) {
                solicitacaoRedeSim.setAtivo(!solicitacaoRedeSim.isAtivo());
                ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Erro ao salvar.");
        }
    }
}

