/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.CidadeEntity;
import br.com.elotech.tributacao.domain.UnidadeFederacaoEntity;
import br.com.elotech.tributacao.domain.UnidadeFederacaoPK;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaPK;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroPK;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.util.Strings;
import org.primefaces.event.SelectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;

@EloController(value="consultaEnderecoCadastroGeralController")
@Scope(value="flow")
public class ConsultaEnderecoCadastroGeralController
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConsultaEnderecoCadastroGeralController.class);
    public BairroEntity bairro;
    public LogradouroEntity logradouro;
    public String numero;
    public String complemento;
    public String cep;
    private CidadeEntity cidade;

    public void loadCidadeAtual() throws BaseException {
        this.setCidade(((FacadeEntidade)SpringContext.getBean(FacadeEntidade.class)).getEntidade().getId().getEntidade().getBairro().getId().getCidade());
    }

    public List<BairroEntity> completeBairro(String descBairro) {
        List bairros = null;
        try {
            if (Objects.nonNull(this.cidade)) {
                bairros = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaBairroPorDescricaoECidade(this.cidade.getId(), descBairro);
            }
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bairros;
    }

    public List<LogradouroEntity> completeLogradouro(String descLogradouro) {
        List enderecos = null;
        try {
            if (Objects.nonNull(this.cidade)) {
                enderecos = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaListaLogradouroPorCidade(this.cidade.getId(), descLogradouro);
            }
        }
        catch (BaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return enderecos;
    }

    public Boolean isEnderecoInvalido() {
        return Objects.isNull(this.getBairro()) || Objects.isNull(this.getLogradouro()) || Strings.isEmpty((CharSequence)this.getNumero()) || Strings.isEmpty((CharSequence)this.getCep());
    }

    public void setNewAddress(CadastroGeralAiseEntity cadastroGeral) throws BaseException {
        cadastroGeral.setBairro(this.getBairro());
        cadastroGeral.setLogradouro(this.getLogradouro());
        cadastroGeral.setNumero(String.valueOf(this.getNumero()));
        Optional.ofNullable(this.cep).ifPresent(cep -> cadastroGeral.setCep(new BigDecimal(EloStringUtils.retiraChars((String)cep, (char[])new char[]{'.', '-', '/'}))));
        cadastroGeral.setComplemento(this.getComplemento());
        if (EloListUtils.safeIsEmpty((List)cadastroGeral.getPessoa().getEnderecos()).booleanValue()) {
            EnderecoPessoaEntity enderecoPessoa = new EnderecoPessoaEntity();
            EnderecoPessoaPK enderecoPessoaPK = new EnderecoPessoaPK();
            enderecoPessoaPK.setPessoa(cadastroGeral.getPessoa());
            enderecoPessoa.setId(enderecoPessoaPK);
            enderecoPessoa.setBairro(cadastroGeral.getBairro());
            enderecoPessoa.setLogradouroEndereco(cadastroGeral.getLogradouro());
            enderecoPessoa.setNumero(cadastroGeral.getNumero());
            enderecoPessoa.setCep(Long.valueOf(cadastroGeral.getCep().longValue()));
            enderecoPessoa.setComplemento(cadastroGeral.getComplemento());
            enderecoPessoa.setUnidadeFederacao((String)Optional.ofNullable(cadastroGeral.getLogradouro()).map(LogradouroEntity::getId).map(LogradouroPK::getCidade).map(CidadeEntity::getUnidadeFederacao).map(UnidadeFederacaoEntity::getId).map(UnidadeFederacaoPK::getUnidadeFederacao).orElse(null));
            cadastroGeral.getPessoa().getEnderecos().add(enderecoPessoa);
        }
    }

    public void selectBairro(SelectEvent event) {
        this.setBairro((BairroEntity)event.getObject());
    }

    public void selectLogradouro(SelectEvent event) {
        this.setLogradouro((LogradouroEntity)event.getObject());
    }

    public BairroEntity getBairro() {
        return this.bairro;
    }

    public void setBairro(BairroEntity bairro) {
        this.bairro = bairro;
    }

    public LogradouroEntity getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(LogradouroEntity logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public CidadeEntity getCidade() {
        return this.cidade;
    }

    public void setCidade(CidadeEntity cidade) {
        this.cidade = cidade;
    }
}

