/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoTipoInscricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaPreviaVo;
import br.com.elotech.portalarrecadacao.domain.vo.MensagemTipoInscricaoVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoPessoaEnum;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeNaturezaSolicitacaoTipoInscricao;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.filter.NaturezaSolicitacaoTipoInscricaoFilter;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;

@EloController(value="consultaCpfCnpjController")
@Scope(value="flow")
public class ConsultaCpfCnpjController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, TipoInscricaoAlvaraEntity> tiposInscricao = new HashMap();
    private List<CadastroMobiliarioEntity> cadastrosMobiliarios;
    private CadastroMobiliarioEntity cadastroMobiliario;
    private String tipoRequerente;
    private String cpfcnpj = "";
    private List<NaturezaSolicitacaoTipoInscricaoAlvaraEntity> naturezasSolicitacaoTipoInscricao;
    private List<NaturezaSolicitacaoAlvaraEntity> naturezas;
    private List<String> selectedNaturezas;
    private boolean checkBoxNaturezaInicial;
    private boolean naturezaMudancaEnd;
    private boolean naturezaMudancaArea;
    private boolean naturezaAlteracaoAtividade;
    private boolean naturezaMudancaRazao;
    private boolean naturezaAlteracaoSocios;
    private boolean naturezaBaixaAlvara;
    private boolean checkBoxAlteracaoAlvara;
    private String tituloClassificacao;
    private TipoInscricaoAlvaraEntity tipoInscricao;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    private List<TipoInscricaoAlvaraEntity> listaTipoInscricaoAlvara;
    private List<TipoPessoaEnum> tiposPessoa;
    @Resource
    private EntidadeController entidadeController;
    private boolean desabilitaOpcoesClassificacao;
    private boolean desabilitaPontoReferencia;

    public List<TipoPessoaEnum> getTiposPessoa() {
        if (this.tiposPessoa == null) {
            this.tiposPessoa = Arrays.asList(TipoPessoaEnum.values());
        }
        return this.tiposPessoa;
    }

    public List<TipoInscricaoAlvaraEntity> getListaTipoInscricaoAlvara() {
        return this.listaTipoInscricaoAlvara;
    }

    public void setListaTipoInscricaoAlvara(List<TipoInscricaoAlvaraEntity> listaTipoInscricaoAlvara) {
        this.listaTipoInscricaoAlvara = listaTipoInscricaoAlvara;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getNaturezas() {
        return this.naturezas;
    }

    public void setNaturezas(List<NaturezaSolicitacaoAlvaraEntity> naturezas) {
        this.naturezas = naturezas;
    }

    public List<String> getSelectedNaturezas() {
        return this.selectedNaturezas;
    }

    public void setSelectedNaturezas(List<String> selectedNaturezas) {
        this.selectedNaturezas = selectedNaturezas;
    }

    public List<CadastroMobiliarioEntity> getCadastrosMobiliarios() {
        return this.cadastrosMobiliarios;
    }

    public void setCadastrosMobiliarios(List<CadastroMobiliarioEntity> cadastrosMobiliarios) {
        this.cadastrosMobiliarios = cadastrosMobiliarios;
    }

    public CadastroMobiliarioEntity getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    public void setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    public boolean isCheckBoxAlteracaoAlvara() {
        return this.checkBoxAlteracaoAlvara;
    }

    public void setCheckBoxAlteracaoAlvara(boolean checkBoxAlteracaoAlvara) {
        this.checkBoxAlteracaoAlvara = checkBoxAlteracaoAlvara;
    }

    public boolean isCheckBoxNaturezaInicial() {
        return this.checkBoxNaturezaInicial;
    }

    public void setCheckBoxNaturezaInicial(boolean checkBoxNaturezaInicial) {
        this.checkBoxNaturezaInicial = checkBoxNaturezaInicial;
    }

    public boolean isNaturezaMudancaEnd() {
        return this.naturezaMudancaEnd;
    }

    public void setNaturezaMudancaEnd(boolean isNaturezaMudancaEnd) {
        this.naturezaMudancaEnd = isNaturezaMudancaEnd;
    }

    public boolean isNaturezaAlteracaoAtividade() {
        return this.naturezaAlteracaoAtividade;
    }

    public void setNaturezaAlteracaoAtividade(boolean naturezaAlteracaoAtividade) {
        this.naturezaAlteracaoAtividade = naturezaAlteracaoAtividade;
    }

    public boolean isNaturezaMudancaArea() {
        return this.naturezaMudancaArea;
    }

    public void setNaturezaMudancaArea(boolean naturezaMudancaArea) {
        this.naturezaMudancaArea = naturezaMudancaArea;
    }

    public boolean isNaturezaMudancaRazao() {
        return this.naturezaMudancaRazao;
    }

    public void setNaturezaMudancaRazao(boolean naturezaMudancaRazao) {
        this.naturezaMudancaRazao = naturezaMudancaRazao;
    }

    public boolean isNaturezaAlteracaoSocios() {
        return this.naturezaAlteracaoSocios;
    }

    public void setNaturezaAlteracaoSocios(boolean naturezaAlteracaoSocios) {
        this.naturezaAlteracaoSocios = naturezaAlteracaoSocios;
    }

    public boolean isNaturezaBaixaAlvara() {
        return this.naturezaBaixaAlvara;
    }

    public void setNaturezaBaixaAlvara(boolean naturezaBaixaAlvara) {
        this.naturezaBaixaAlvara = naturezaBaixaAlvara;
    }

    public SolicitacaoAlvaraController getSolicitacaoAlvaraController() {
        return this.solicitacaoAlvaraController;
    }

    public void setSolicitacaoAlvaraController(SolicitacaoAlvaraController solicitacaoAlvaraController) {
        this.solicitacaoAlvaraController = solicitacaoAlvaraController;
    }

    public String getTipoRequerente() {
        return this.tipoRequerente;
    }

    public void setTipoRequerente(String tipoRequerente) {
        this.tipoRequerente = tipoRequerente;
    }

    public TipoInscricaoAlvaraEntity getTipoInscricao() {
        return this.tipoInscricao;
    }

    public void setTipoInscricao(TipoInscricaoAlvaraEntity tipoInscricao) {
        this.tipoInscricao = tipoInscricao;
    }

    public boolean isDesabilitaOpcoesClassificacao() {
        return this.desabilitaOpcoesClassificacao;
    }

    public void setDesabilitaOpcoesClassificacao(boolean desabilitaOpcoesClassificacao) {
        this.desabilitaOpcoesClassificacao = desabilitaOpcoesClassificacao;
    }

    public boolean isDesabilitaPontoReferencia() {
        return this.desabilitaPontoReferencia;
    }

    public void setDesabilitaPontoReferencia(boolean desabilitaPontoReferencia) {
        this.desabilitaPontoReferencia = desabilitaPontoReferencia;
    }

    public List<CadastroMobiliarioEntity> carregaCadastroMobiliario() throws BaseException {
        String cpfcnpjSemCaracterSpecial = this.cpfcnpj.replaceAll("[.,-/]", "");
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregaCadastrosMobiliarios(cpfcnpjSemCaracterSpecial);
    }

    public MobiliarioSituacaoEntity verificaSituacao(Long codigo) throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).verificaSituacaoCadastroMobiliario(codigo);
    }

    public void carregarDados() throws BaseException {
        for (TipoInscricaoAlvaraEntity tipo : ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarTipoInscricaoAlvara()) {
            this.tiposInscricao.put(tipo.getSigla(), tipo);
        }
        this.cadastroMobiliario = null;
        this.naturezas = Lists.newArrayList();
        this.cadastrosMobiliarios = this.carregaCadastroMobiliario();
        if (EloListUtils.safeIsEmpty((List)this.cadastrosMobiliarios).booleanValue()) {
            this.cadastroMobiliario = null;
            ShowMessage.addErrorMessage((String)"validacao", (String)"Nenhum Registro Encontrado!");
        } else if (this.cadastrosMobiliarios.size() == 1) {
            this.cadastroMobiliario = (CadastroMobiliarioEntity)this.cadastrosMobiliarios.stream().findFirst().get();
            this.selecionouCadastroMobiliario();
        }
    }

    public TipoInscricaoAlvaraEntity pesquisaTipoInscricaoAlvaraPorSigla(String sigla) throws BaseException {
        if (!EloStringUtils.isEmpty((String)sigla)) {
            List tiposInscricao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarTipoInscricaoAlvara();
            for (TipoInscricaoAlvaraEntity tipoInscricao : tiposInscricao) {
                if (!tipoInscricao.getSigla().equals(sigla)) continue;
                return tipoInscricao;
            }
        }
        return null;
    }

    public String getCpfcnpj() {
        return this.cpfcnpj;
    }

    public void setCpfcnpj(String cpfcnpj) {
        this.cpfcnpj = cpfcnpj;
    }

    public String getTituloClassificacao() {
        return this.tituloClassificacao;
    }

    public String avancar() {
        try {
            boolean permitirInserirClassificacaoPessoaJuridica;
            ConsultaPreviaVo consultaPreviaVo = new ConsultaPreviaVo();
            consultaPreviaVo.setCpfCnpj(this.cpfcnpj.replaceAll("[.,-/]", ""));
            if (!this.checkBoxNaturezaInicial) {
                if (this.selectedNaturezas == null || this.selectedNaturezas.size() <= 0) {
                    ShowMessage.addWarnMessage((String)"validacao", (String)"Favor selecionar pelo menos uma op\u00e7\u00e3o de Mudan\u00e7a ou Altera\u00e7\u00e3o!");
                    return "";
                }
                if (this.cadastroMobiliario == null) {
                    ShowMessage.addInfoMessage((String)"validacao", (String)"Selecione um Cadastro Mobili\u00e1rio para continuar.");
                    return "";
                }
                if (!this.isSituacaoMobiliarioValidaParaAlteracao()) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"A situa\u00e7\u00e3o do cadastro n\u00e3o \u00e9 v\u00e1lida para altera\u00e7\u00e3o.");
                    return "";
                }
                if (!this.validarAlteracaoAlvaraTipoInscricaoCadastroMobiliario()) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"O cadastro selecionado n\u00e3o possui Tipo de Inscri\u00e7\u00e3o permitida para altera\u00e7\u00e3o.");
                    return "";
                }
                this.validarEnderecoMobiliario();
                if (this.cadastrosMobiliarios == null) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)"Nenhum Registro Encontrado!");
                    return null;
                }
                consultaPreviaVo.setNaturezas(this.carregaNaturezaNaSolicitacao());
            } else {
                consultaPreviaVo.setNaturezas(new ArrayList());
                consultaPreviaVo.getNaturezas().add(((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaNaturezaInicial());
            }
            consultaPreviaVo.setTipoInscricaoAlvara(this.tipoInscricao);
            consultaPreviaVo.setTipoRequerente(this.tipoRequerente);
            consultaPreviaVo.setCadastroMobiliario(this.cadastroMobiliario);
            SolicitacaoAlvaraEntity solicitacao = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).iniciaConsultaPrevia(consultaPreviaVo);
            boolean bl = permitirInserirClassificacaoPessoaJuridica = solicitacao.isSolicitacaoJuridicaNormal() && this.isPermitirInserirClassificacaoPessoaJuridica();
            if (this.isMeiInicial(solicitacao) || this.isSolicitacaoMeiComMudancaAreaOuEndereco(solicitacao) || permitirInserirClassificacaoPessoaJuridica) {
                this.definirTituloClassificacao(solicitacao);
                this.desabilitaOpcoesClassificacao = this.isDesabilitaCamposClassificacao(solicitacao, permitirInserirClassificacaoPessoaJuridica);
                this.desabilitaPontoReferencia = false;
                if (solicitacao.isSomenteMudancaAreaSemAreaUtilizada()) {
                    this.desabilitaPontoReferencia = true;
                    solicitacao.getClassificacaoTipoInscricao().setPontoReferencia("N");
                }
                this.solicitacaoAlvaraController.setSolicitacaoAlvara(solicitacao);
                RequestContext.getCurrentInstance().update("dlgClassificacaoMei");
                RequestContext.getCurrentInstance().execute("dialogClassificacaoMei.show()");
                return null;
            }
            this.solicitacaoAlvaraController.setSolicitacaoAlvara(solicitacao);
            return "toMostraConsultaImobiliario";
        }
        catch (SolicitacaoAlvaraException se) {
            ShowMessage.addErrorMessage((String)"validacao", (String)se.getMessage());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
        }
        return null;
    }

    private void definirTituloClassificacao(SolicitacaoAlvaraEntity solicitacao) {
        this.tituloClassificacao = "";
        this.tituloClassificacao = solicitacao.isSolicitacaoMEI() ? "Classifica\u00e7\u00e3o de Microempreendedor Individual" : (solicitacao.isSolicitacaoJuridicaNormal() ? "Classifica\u00e7\u00e3o de Pessoa Jur\u00eddica" : "Classifica\u00e7\u00e3o");
    }

    private boolean isMeiInicial(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.isNaturezaInicial() && solicitacao.isSolicitacaoMEI();
    }

    private boolean validarAlteracaoAlvaraTipoInscricaoCadastroMobiliario() throws BaseException {
        for (String codigoNatureza : this.selectedNaturezas) {
            if (((FacadeNaturezaSolicitacaoTipoInscricao)SpringContext.getBean(FacadeNaturezaSolicitacaoTipoInscricao.class)).isNaturezaSolicitacaoTipoInscricaoAtiva(codigoNatureza, this.tipoInscricao)) continue;
            return false;
        }
        return true;
    }

    private boolean isDesabilitaCamposClassificacao(SolicitacaoAlvaraEntity solicitacao, boolean permitirInserirClassificacaoPessoaJuridica) {
        if (this.isSolicitacaoMeiComMudancaAreaOuEndereco(solicitacao) || solicitacao.isNaturezaInicial() || permitirInserirClassificacaoPessoaJuridica) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean isSolicitacaoMeiComMudancaAreaOuEndereco(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.isSolicitacaoMEI() && (solicitacao.isNaturezaMudancaArea() || solicitacao.isNaturezaMudancaEndereco());
    }

    private void validarEnderecoMobiliario() throws BaseException {
        ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).validarImobiliarioVinculadoMobiliario(this.cadastroMobiliario);
    }

    private boolean isSituacaoMobiliarioValidaParaAlteracao() throws BaseException {
        ParametroAlvaraEntity parametro = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(this.entidadeController.getEntidade(), ParametroAlvaraEnum.SITUACOES_MOBILIARIO_INVALIDAS_PARA_ALTERACAO);
        if (EloStringUtils.isEmpty((String)parametro.getValor())) {
            throw new ParametroNaoEncontradoException("Par\u00e2metro " + ParametroAlvaraEnum.SITUACOES_MOBILIARIO_INVALIDAS_PARA_ALTERACAO + " n\u00e3o encontrado");
        }
        String[] invalidos = null;
        if (!EloStringUtils.isEmpty((String)parametro.getValor())) {
            for (String invalido : invalidos = parametro.getValor().split(",")) {
                if (!invalido.equals(this.cadastroMobiliario.getMobiliarioSituacaoAtual().getId().toString())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPermitirInserirClassificacaoPessoaJuridica() throws BaseException {
        try {
            ParametroAlvaraEntity param = ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).getParametros(this.entidadeController.getEntidade(), ParametroAlvaraEnum.PERMITE_INSERIR_CLASSIFICACAO_PESSOA_JURIDICA);
            if (param != null) {
                return SimNaoEnum.SIM.getShortText().equals(param.getValor());
            }
            throw new SolicitacaoAlvaraException(String.format("Par\u00e2metro  %s n\u00e3o configurado.", ParametroAlvaraEnum.PERMITE_INSERIR_CLASSIFICACAO_PESSOA_JURIDICA));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao carregar o par\u00e2metro %s.", ParametroAlvaraEnum.PERMITE_INSERIR_CLASSIFICACAO_PESSOA_JURIDICA));
        }
    }

    private List<NaturezaSolicitacaoAlvaraEntity> carregaNaturezaNaSolicitacao() {
        ArrayList<NaturezaSolicitacaoAlvaraEntity> naturezasSelecionadas = new ArrayList<NaturezaSolicitacaoAlvaraEntity>();
        this.iniciaNaturezasAlteracao();
        for (String codigo : this.selectedNaturezas) {
            if ("ME".equals(codigo)) {
                this.solicitacaoAlvaraController.getSolicitacaoAlvara().setCadastroImobiliario(this.cadastroMobiliario.getCadastroImobiliario());
                this.naturezaMudancaEnd = true;
            } else if ("MA".equals(codigo)) {
                this.naturezaMudancaArea = true;
            } else if ("AA".equals(codigo)) {
                this.naturezaAlteracaoAtividade = true;
            } else if ("MR".equals(codigo)) {
                this.naturezaMudancaRazao = true;
            } else if ("AS".equals(codigo)) {
                this.naturezaAlteracaoSocios = true;
            } else if ("BA".equals(codigo)) {
                this.naturezaBaixaAlvara = true;
            }
            naturezasSelecionadas.add(this.getNaturezaPorCodigo(codigo));
        }
        return naturezasSelecionadas;
    }

    public NaturezaSolicitacaoAlvaraEntity getNaturezaPorCodigo(String codigo) {
        for (NaturezaSolicitacaoAlvaraEntity natureza : this.naturezas) {
            if (!codigo.equals(natureza.getCodigo())) continue;
            return natureza;
        }
        return null;
    }

    public void carregarNaturezasSolicitacao(TipoInscricaoAlvaraEntity tipoInscricao) {
        this.naturezas = Lists.newArrayList();
        this.naturezasSolicitacaoTipoInscricao.stream().filter(naturezaTipo -> naturezaTipo.isAtivo()).forEach(naturezaTipo -> {
            if (tipoInscricao == null || tipoInscricao.equals((Object)naturezaTipo.getTipoInscricao())) {
                this.naturezas.add(naturezaTipo.getNaturezaSolicitacao());
            }
        });
    }

    public void iniciar() throws BaseException {
        this.solicitacaoAlvaraController.setSolicitacaoAlvara(null);
        ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemRestricaoPerimetro(null);
        this.carregarNaturezasSolicitacaoTipoInscricao();
    }

    private void carregarNaturezasSolicitacaoTipoInscricao() {
        try {
            NaturezaSolicitacaoTipoInscricaoFilter filter = new NaturezaSolicitacaoTipoInscricaoFilter.BuilderNaturezaSolicitacaoTipoInscricaoFilter().ativo(Boolean.valueOf(true)).build();
            this.naturezasSolicitacaoTipoInscricao = ((FacadeNaturezaSolicitacaoTipoInscricao)SpringContext.getBean(FacadeNaturezaSolicitacaoTipoInscricao.class)).carregarNaturezasSolicitacaoTipoInscricao(filter);
            this.carregarTiposInscricaoAlvara();
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Erro ao carregar as naturezas de solicita\u00e7\u00e3o por tipo de inscri\u00e7\u00e3o");
            this.logger.error((Object)e);
        }
    }

    public boolean habilitarNaturezaInicial() {
        return EloListUtils.safeIsEmpty((List)this.naturezasSolicitacaoTipoInscricao) == false && this.naturezasSolicitacaoTipoInscricao.stream().anyMatch(naturezaTipo -> naturezaTipo.isAtivo() && naturezaTipo.getNaturezaSolicitacao().getCodigo().equalsIgnoreCase("IN"));
    }

    public boolean habilitarNaturezaAlteracao() {
        return EloListUtils.safeIsEmpty((List)this.naturezasSolicitacaoTipoInscricao) == false && this.naturezasSolicitacaoTipoInscricao.stream().anyMatch(naturezaTipo -> naturezaTipo.isAtivo() && !naturezaTipo.getNaturezaSolicitacao().getCodigo().equalsIgnoreCase("IN"));
    }

    protected void iniciaNaturezasAlteracao() {
        this.naturezaAlteracaoAtividade = false;
        this.naturezaAlteracaoSocios = false;
        this.naturezaBaixaAlvara = false;
        this.naturezaMudancaArea = false;
        this.naturezaMudancaEnd = false;
        this.naturezaMudancaRazao = false;
    }

    public void selecionouCadastroMobiliario() throws BaseException {
        this.naturezas = Lists.newArrayList();
        this.tipoInscricao = this.tipoInscricaoCadastroMobiliario(this.cadastroMobiliario);
        if (this.tipoInscricao != null) {
            this.carregarNaturezasSolicitacao(this.tipoInscricao);
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Somente inscri\u00e7\u00e3o de prestador de servi\u00e7o sem alvar\u00e1 n\u00e3o autorizado pelo sistema alvar\u00e1 online.");
        }
    }

    public void definirMensagemTipoInscricao() throws BaseException {
        if (this.tipoInscricao == null) {
            return;
        }
        MensagemTipoInscricaoVo mensagem = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).definirMensagemTipoInscricao(this.tipoInscricao);
        ShowMessage.addMessage((String)"validacao", (FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)mensagem.getTitulo(), (String)mensagem.getMensagem());
    }

    public boolean verificaRestricaoPerimetro() {
        return this.checkBoxNaturezaInicial || this.naturezaAlteracaoAtividade || this.naturezaMudancaEnd;
    }

    public void carregarTiposInscricaoAlvara() {
        this.listaTipoInscricaoAlvara = this.naturezasSolicitacaoTipoInscricao.stream().filter(naturezaTipo -> naturezaTipo.isAtivo()).map(naturezaTipo -> naturezaTipo.getTipoInscricao()).distinct().collect(Collectors.toList());
    }

    public TipoInscricaoAlvaraEntity tipoInscricaoCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        return ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).carregarTipoInscricaoDoCadastroMobiliario(cadastroMobiliario);
    }

    public void cancelarClassificacaoMei() {
        this.solicitacaoAlvaraController.getSolicitacaoAlvara().getClassificacaoTipoInscricao().setPontoReferencia(null);
        this.solicitacaoAlvaraController.getSolicitacaoAlvara().getClassificacaoTipoInscricao().setTipoClassificacao(null);
    }

    public String confirmaClassificacaoMei() {
        SolicitacaoAlvaraEntity solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (EloStringUtils.isEmpty((String)solicitacao.getClassificacaoTipoInscricao().getPontoReferencia()) && EloStringUtils.isEmpty((String)solicitacao.getClassificacaoTipoInscricao().getTipoClassificacao())) {
            ShowMessage.addErrorMessage((String)"msgClassificacao", (String)"Informe a Classifica\u00e7\u00e3o");
            return null;
        }
        if (!solicitacao.getClassificacaoTipoInscricao().isPrestadorServico() && EloStringUtils.isEmpty((String)solicitacao.getClassificacaoTipoInscricao().getTipoClassificacao())) {
            ShowMessage.addErrorMessage((String)"msgClassificacao", (String)"Informe o Tipo da Classifica\u00e7\u00e3o Alvar\u00e1");
            return null;
        }
        return "toMostraConsultaImobiliario";
    }

    public List<SimNaoEnum> opcoesPontoReferencia() {
        return Arrays.asList(SimNaoEnum.values());
    }

    protected SolicitacaoAlvaraEntity carregarAtividadesMobNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        try {
            ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregarAtividadesMobNaSolicitacao(solicitacao);
        }
        catch (BaseException be) {
            this.logger.error((Object)be.getMessage(), (Throwable)be);
            ShowMessage.addErrorMessage((String)"validacao", (String)be.getMessage());
        }
        return solicitacao;
    }

    public void adicionarNaturezaSelecionada(String natureza) {
        if (this.selectedNaturezas.contains(natureza)) {
            this.selectedNaturezas.remove(natureza);
        } else {
            this.selectedNaturezas.add(natureza);
        }
    }

    public boolean mudancaEnderecoAtivo() {
        if (EloListUtils.safeIsEmpty((List)this.naturezas).booleanValue()) {
            return false;
        }
        Predicate<NaturezaSolicitacaoAlvaraEntity> n = e -> e.getCodigo().equals(NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO.getValue());
        return this.naturezas.stream().anyMatch(n);
    }

    public boolean mudancaAtividadeAtivo() {
        if (EloListUtils.safeIsEmpty((List)this.naturezas).booleanValue()) {
            return false;
        }
        Predicate<NaturezaSolicitacaoAlvaraEntity> n = e -> e.getCodigo().equals(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE.getValue());
        return this.naturezas.stream().anyMatch(n);
    }

    public boolean mudancaAreaAtivo() {
        if (EloListUtils.safeIsEmpty((List)this.naturezas).booleanValue()) {
            return false;
        }
        Predicate<NaturezaSolicitacaoAlvaraEntity> n = e -> e.getCodigo().equals(NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA.getValue());
        return this.naturezas.stream().anyMatch(n);
    }

    public boolean mudancaRazaoAtivo() {
        if (EloListUtils.safeIsEmpty((List)this.naturezas).booleanValue()) {
            return false;
        }
        Predicate<NaturezaSolicitacaoAlvaraEntity> n = e -> e.getCodigo().equals(NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue());
        return this.naturezas.stream().anyMatch(n);
    }

    public boolean mudancaSocioAtivo() {
        if (EloListUtils.safeIsEmpty((List)this.naturezas).booleanValue()) {
            return false;
        }
        Predicate<NaturezaSolicitacaoAlvaraEntity> n = e -> e.getCodigo().equals(NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS.getValue());
        return this.naturezas.stream().anyMatch(n);
    }

    public boolean renderizarPanelSolicitante() {
        return this.checkBoxNaturezaInicial || this.checkBoxAlteracaoAlvara;
    }

    public boolean renderizarPanelAlteracao() {
        return this.checkBoxAlteracaoAlvara;
    }

    public boolean renderizarPanelCadastrosMobiliarios() {
        return this.checkBoxAlteracaoAlvara && EloListUtils.safeIsEmpty((List)this.cadastrosMobiliarios) == false;
    }

    public void clickCheckBoxNaturezaInicial() {
        this.inicializarFiltros();
    }

    public void clickCheckBoxAlteracaoAlvara() {
        this.inicializarFiltros();
    }

    private void inicializarFiltros() {
        this.cpfcnpj = "";
        this.tipoInscricao = null;
        this.naturezas = Lists.newArrayList();
        this.selectedNaturezas = Lists.newArrayList();
        this.cadastroMobiliario = null;
        this.cadastrosMobiliarios = Lists.newArrayList();
        this.naturezaAlteracaoAtividade = false;
        this.naturezaAlteracaoSocios = false;
        this.naturezaBaixaAlvara = false;
        this.naturezaMudancaArea = false;
        this.naturezaMudancaEnd = false;
        this.naturezaMudancaRazao = false;
    }
}

