/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.util.captcha.CaptchaUtil;
import br.com.elotech.util.exceptions.HashException;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Scope(value="session")
@Controller(value="captchaController")
public class CaptchaController
extends EloLogger
implements Serializable {
    @Resource
    private CaptchaUtil captchaUtil;
    @Resource
    private String captchaId;

    public void setCaptchaUtil(CaptchaUtil captchaUtil) {
        this.captchaUtil = captchaUtil;
    }

    public String getCaptchaId() {
        return this.captchaId;
    }

    public void setCaptchaId(String captchaId) {
        this.captchaId = captchaId;
    }

    @RequestMapping(value={"/captcha/{id}.jpg"})
    public void captcha(@PathVariable(value="id") String id, HttpServletResponse response) throws HashException {
        Cache c;
        Element date;
        if (CacheManager.getInstance().getCache("cache") == null) {
            CacheManager.getInstance().addCache("cache");
        }
        if ((date = (c = CacheManager.getInstance().getCache("cache")).get((Serializable)((Object)"time"))) == null) {
            c.put(new Element((Serializable)((Object)"time"), (Serializable)new Date()));
            c.put(new Element((Serializable)((Object)"captchaKey"), (Serializable)((Object)id)));
            this.logger.info((Object)String.format("Captcha para o id: \"%s\"", id));
            this.captchaUtil.sendImgCaptcha(id, response);
        } else {
            Date d1 = (Date)date.getObjectValue();
            Long l1 = d1.getTime();
            Date d2 = new Date();
            Long l2 = d2.getTime();
            if (l2 - l1 > 800L) {
                c.replace(new Element((Serializable)((Object)"time"), (Serializable)new Date()));
                c.replace(new Element((Serializable)((Object)"captchaKey"), (Serializable)((Object)id)));
                this.logger.info((Object)String.format("Captcha para o id: \"%s\"", id));
                this.captchaUtil.sendImgCaptcha(id, response);
            }
        }
    }
}

