/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.util.exceptions.HashException;
import br.com.elotech.util.string.EloHashUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@EloController(value="alterarSenhaController")
@Scope(value="flow")
public class AlterarSenhaController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = -5374045224755385867L;
    private AcessoWebEntity usuario;
    private String senhaAtual;

    public AcessoWebEntity getUsuario() {
        return this.usuario;
    }

    public void setUsuario(AcessoWebEntity usuario) {
        this.usuario = usuario;
    }

    public void iniciar() throws BaseException {
        this.usuario = new AcessoWebEntity();
    }

    public String getSenhaAtual() {
        return this.senhaAtual;
    }

    public void setSenhaAtual(String senhaAtual) {
        this.senhaAtual = senhaAtual;
    }

    protected AcessoWebEntity recuperarUsuario() {
        UserDetails user = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        AcessoWebEntity usuarioAcessoWeb = (AcessoWebEntity)user;
        if (user instanceof AcessoWebEntity) {
            return usuarioAcessoWeb;
        }
        ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o foi poss\u00edvel recuperar o usu\u00e1rio.");
        return null;
    }

    protected void salvarUsuario(AcessoWebEntity usuario) throws BaseException {
        ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).incluirUsuario(usuario);
    }

    public void salvarNovaSenha() throws BaseException {
        AcessoWebEntity usuarioLogado = this.recuperarUsuario();
        if (usuarioLogado != null && usuarioLogado.getId() != null && this.validarCamposNovaSenha(usuarioLogado)) {
            usuarioLogado.setSenha(this.hashNovaSenha(usuarioLogado));
            usuarioLogado.setCodigoAlteracaoSenha(null);
            this.salvarUsuario(usuarioLogado);
            this.usuario = new AcessoWebEntity();
            this.senhaAtual = null;
            ShowMessage.addInfoMessage((String)"validacao", (String)"Sua senha foi alterada com sucesso.");
        }
    }

    protected String hashNovaSenha(AcessoWebEntity usuarioLogado) throws HashException {
        return EloHashUtils.hashMD5((String)EloStringUtils.build((Object[])new Object[]{usuarioLogado.getCpf(), ":", this.usuario.getSenha()})).toUpperCase();
    }

    protected boolean validarCamposNovaSenha(AcessoWebEntity usuarioLogado) throws HashException {
        String senhaAtualHash;
        boolean valido = true;
        if (EloStringUtils.isEmpty((String)this.senhaAtual)) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Senha Atual \u00e9 obrigat\u00f3rio");
        } else if (EloStringUtils.isEmpty((String)this.usuario.getSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Nova Senha \u00e9 obrigat\u00f3rio.");
        } else if (this.usuario.getSenha().length() < 6 || this.usuario.getSenha().length() > 15) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"A senha deve possuir de 6 a 15 caracteres.");
        } else if (EloStringUtils.isEmpty((String)this.usuario.getConfirmacaoSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"O campo Confirmar Senha \u00e9 obrigat\u00f3rio.");
        } else if (!this.usuario.getSenha().equals(this.usuario.getConfirmacaoSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"As senhas informadas n\u00e3o conferem.");
        }
        if (valido && !(senhaAtualHash = EloHashUtils.hashMD5((String)EloStringUtils.build((Object[])new Object[]{usuarioLogado.getCpf(), ":", this.senhaAtual})).toUpperCase()).equals(usuarioLogado.getSenha())) {
            valido = false;
            ShowMessage.addErrorMessage((String)"validacao", (String)"A senha atual est\u00e1 incorreta.");
        }
        return valido;
    }
}

