/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeRestricaoCadastro;
import br.com.elotech.portalarrecadacao.filter.FiltroCadastroRestricao;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;

@EloController(value="alterarCadastroRestricaoController")
@Scope(value="flow")
public class AlterarCadastroRestricaoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 7809900820490092087L;
    private List<CadastroRestricaoAlvaraEntity> consultasCadastroRestricao;
    private FiltroCadastroRestricao filtro;

    public FiltroCadastroRestricao getFiltro() {
        return this.filtro;
    }

    public void setFiltro(FiltroCadastroRestricao filtro) {
        this.filtro = filtro;
    }

    public List<CadastroRestricaoAlvaraEntity> getConsultasCadastroRestricao() {
        return this.consultasCadastroRestricao;
    }

    public void setConsultasCadastroRestricao(List<CadastroRestricaoAlvaraEntity> consultasCadastroRestricao) {
        this.consultasCadastroRestricao = consultasCadastroRestricao;
    }

    private List<CadastroRestricaoAlvaraEntity> carregarListaCadastroRestricoes() throws BaseException {
        return ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).carregarListaCadastroRestricoes(this.filtro);
    }

    public void buscarCadastroRestricoes() throws BaseException {
        this.consultasCadastroRestricao = this.carregarListaCadastroRestricoes();
    }

    public void salvarCadastroRestricao(CadastroRestricaoAlvaraEntity cadastroRestricao) {
        try {
            ((FacadeRestricaoCadastro)SpringContext.getBean(FacadeRestricaoCadastro.class)).salvarCadastroRestricao(cadastroRestricao);
            ShowMessage.addInfoMessage((String)"msg", (String)"Campo atualizado.");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"msg", (String)"Falha ao salvar o registro.");
        }
    }

    public void iniciar() throws BaseException {
        this.limparCampos();
    }

    public void limparCampos() throws BaseException {
        this.filtro = new FiltroCadastroRestricao();
        this.buscarCadastroRestricoes();
    }

    public SimNaoEnum[] simNaoEnum() {
        return SimNaoEnum.values();
    }
}

