/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.InformacoesAtividadesController;
import br.com.elotech.portalarrecadacao.controller.SolicitacaoAlvaraController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.AtividadesPermitidasResposta;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaGenericaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.primefaces.context.RequestContext;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;

@EloController(value="alteracaoAtividadeController")
@Scope(value="flow")
public class AlteracaoAtividadesController
extends EloLogger
implements Serializable {
    private static final int TAMANHO_MINIMO_CODIGO_CBO = 4;
    private static final int TAMANHO_MAXIMO_CODIGO_CBO = 6;
    private static final int TAMANHO_MAXIMO_CODIGO_CNAE = 7;
    private static final long serialVersionUID = 1L;
    private List<Atividade> atividadeCnaeOcupacoes;
    private Atividade atividadeCnaeOcupacoesSelecionada;
    private Atividade atividadePermitidaSelecionada;
    private Atividade atividadeNaoPermitidaSelecionada;
    private List<Atividade> listaAtividadesExcluidas;
    private byte[] imagemWS;
    private byte[] imagemMapaRetornoConsulta;
    private List<Atividade> atividadesComRestricoes;
    private boolean flagCampoAreaProcessamento = false;
    private boolean flagSomenteEscritorio = false;
    private boolean flagSomenteEscritorioConcomitante = false;
    private boolean flagAtividadeConcomitante = false;
    private boolean renderMapRetornoConsulta = false;
    @Resource
    private SolicitacaoAlvaraController solicitacaoAlvaraController;
    @Resource
    private EntidadeController entidadeController;
    @Resource
    private InformacoesAtividadesController informacoesAtividadesController;
    private ConsultaAtividadeVo consultaAtividadeVo;
    private SolicitacaoAlvaraEntity solicitacao;

    public ConsultaAtividadeVo getConsultaAtividadeVo() {
        return this.consultaAtividadeVo;
    }

    public void setConsultaAtividadeVo(ConsultaAtividadeVo consultaAtividadeVo) {
        this.consultaAtividadeVo = consultaAtividadeVo;
    }

    public boolean isFlagSomenteEscritorio() {
        return this.flagSomenteEscritorio;
    }

    public void setFlagSomenteEscritorio(boolean flagSomenteEscritorio) {
        this.flagSomenteEscritorio = flagSomenteEscritorio;
    }

    public boolean isFlagSomenteEscritorioConcomitante() {
        return this.flagSomenteEscritorioConcomitante;
    }

    public void setFlagSomenteEscritorioConcomitante(boolean flagSomenteEscritorioConcomitante) {
        this.flagSomenteEscritorioConcomitante = flagSomenteEscritorioConcomitante;
    }

    public boolean isFlagAtividadeConcomitante() {
        return this.flagAtividadeConcomitante;
    }

    public void setFlagAtividadeConcomitante(boolean flagAtividadeConcomitante) {
        this.flagAtividadeConcomitante = flagAtividadeConcomitante;
    }

    public boolean isFlagCampoAreaProcessamento() {
        return this.flagCampoAreaProcessamento;
    }

    public void setFlagCampoAreaProcessamento(boolean flagCampoAreaProcessamento) {
        this.flagCampoAreaProcessamento = flagCampoAreaProcessamento;
    }

    public List<Atividade> getListaAtividadesExcluidas() {
        return this.listaAtividadesExcluidas;
    }

    public List<Atividade> getAtividadesComRestricoes() {
        return this.atividadesComRestricoes;
    }

    public void setAtividadesComRestricoes(List<Atividade> atividadesComRestricoes) {
        this.atividadesComRestricoes = atividadesComRestricoes;
    }

    public void setListaAtividadesExcluidas(List<Atividade> listaAtividadesExcluidas) {
        this.listaAtividadesExcluidas = listaAtividadesExcluidas;
    }

    public Atividade getAtividadePermitidaSelecionada() {
        return this.atividadePermitidaSelecionada;
    }

    public void setAtividadePermitidaSelecionada(Atividade atividadePermitidaSelecionada) {
        this.atividadePermitidaSelecionada = atividadePermitidaSelecionada;
    }

    public Atividade getAtividadeNaoPermitidaSelecionada() {
        return this.atividadeNaoPermitidaSelecionada;
    }

    public void setAtividadeNaoPermitidaSelecionada(Atividade atividadeNaoPermitidaSelecionada) {
        this.atividadeNaoPermitidaSelecionada = atividadeNaoPermitidaSelecionada;
    }

    public List<Atividade> getAtividadeCnaeOcupacoes() {
        return this.atividadeCnaeOcupacoes;
    }

    public void setAtividadeCnaeOcupacoes(List<Atividade> atividadeCnaeOcupacoes) {
        this.atividadeCnaeOcupacoes = atividadeCnaeOcupacoes;
    }

    public Atividade getAtividadeCnaeOcupacoesSelecionada() {
        return this.atividadeCnaeOcupacoesSelecionada;
    }

    public void setAtividadeCnaeOcupacoesSelecionada(Atividade atividadeCnaeOcupacoesSelecionada) {
        this.atividadeCnaeOcupacoesSelecionada = atividadeCnaeOcupacoesSelecionada;
    }

    public void setImagemWS(byte[] imagemWS) {
        this.imagemWS = imagemWS;
    }

    public List<MobiliarioCnaeEntity> carregaListaAtividadesAtuais(Long codigo) throws BaseException {
        return ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregaListaAtividadesCnaePorMobiliario(codigo);
    }

    public void carregaTabelaAtividadesAtuais() throws BaseException {
        if (this.solicitacao.getCadastroMobiliario() != null) {
            this.consultaAtividadeVo.setListaAtiv(new ArrayList());
            if (this.solicitacao.isNaturezaAlteracaoAtividade() && !this.solicitacao.isNaturezaMudancaEndereco()) {
                if (UtilsController.isTestadaGenerica()) {
                    this.solicitacao.setImobiliarioTestadaGenerica(this.buscarTestadaGenericaPrincipal(this.solicitacao.getCadastroMobiliario().getCadastroImobiliario().getId()));
                } else {
                    CadastroImobiliarioTestadaEntity testadaPrincipal = this.buscarTestadaPrincipalPorCodImob();
                    this.solicitacao.setImobiliarioTestada(testadaPrincipal);
                }
            }
            ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarTabelaAtividadesAtuais(this.consultaAtividadeVo);
        }
    }

    private CadastroImobiliarioTestadaEntity buscarTestadaPrincipalPorCodImob() throws BaseException {
        CadastroImobiliarioTestadaEntity testadaPrincipal = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).buscarTestadaPrincipalByCodImob(this.solicitacao.getCadastroMobiliario().getCadastroImobiliario().getId().getCodigo());
        return testadaPrincipal;
    }

    private CadastroImobiliarioTestadaGenericaEntity buscarTestadaGenericaPrincipal(CadastroGeralAisePK cadastroGeralPK) throws BaseException {
        return ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).buscarTestadaGenericaPrincipal(cadastroGeralPK);
    }

    public String voltar() {
        this.consultaAtividadeVo.setListaAtiv(new ArrayList());
        if (this.solicitacao.isSolicitacaoJuridicaNormal()) {
            if (this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
                if (this.solicitacao.isPossuiPontoReferencia()) {
                    return "toMostraConsultaImobiliario";
                }
                return "toInformacoesAtividades";
            }
        } else if (this.solicitacao.isSolicitacaoMEINormal()) {
            if (this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                if (this.solicitacao.isPossuiPontoReferencia()) {
                    return "toMostraConsultaImobiliario";
                }
                return "toInformacoesAtividades";
            }
        } else if (this.solicitacao.isSolicitacaoMEIPrestador()) {
            if (this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
                return "toMostraConsultaImobiliario";
            }
        } else if (this.solicitacao.isSolicitacaoCBO()) {
            if (this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                return "toInformacoesAtividades";
            }
        } else if (this.solicitacao.isSolicitacaoPrestadorServico() && this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            return "toMostraConsultaImobiliario";
        }
        return "toConsultaCpfCnpj";
    }

    public void removerAtividadeDaTabelaPermitida(Atividade atividade) {
        if ("A".equalsIgnoreCase(atividade.getSituacao())) {
            atividade.setSituacao("E");
            if (this.listaAtividadesExcluidas == null) {
                this.listaAtividadesExcluidas = new ArrayList();
            }
            this.listaAtividadesExcluidas.add(atividade);
        }
        this.consultaAtividadeVo.getListaAtiv().remove(atividade);
    }

    public Boolean mostraAlteracaoAtividades() {
        return this.solicitacaoAlvaraController.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE});
    }

    public String avancar() throws BaseException, IOException {
        if (this.temAtividadesNaLista()) {
            ArrayList listaCompletaAtividades = new ArrayList();
            this.solicitacao.atribuirGrauRisco(this.consultaAtividadeVo.getListaAtiv());
            listaCompletaAtividades.addAll(this.consultaAtividadeVo.getListaAtiv());
            this.solicitacao.getListaDeAtividades().clear();
            this.solicitacao.getListaDeAtividades().addAll(listaCompletaAtividades);
            if (this.solicitacao.isNaturezaMudancaArea() || this.houveAlteracaoAtividade(listaCompletaAtividades)) {
                this.solicitacao.setTaxaLocalizacao(((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).getTaxaLocalizacao(this.solicitacao, listaCompletaAtividades));
                this.solicitacao.setSolicitacaoAlvaraAtividades(((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).atribuiValoresSolicitacaoAtividade(this.solicitacao, listaCompletaAtividades));
                this.imagemWS = null;
                return "toFinalizaConsulta";
            }
        }
        return null;
    }

    private boolean houveAlteracaoAtividade(List<Atividade> listaCompletaAtividades) {
        boolean houveAlteracao = false;
        if (EloListUtils.safeIsEmpty((List)this.listaAtividadesExcluidas).booleanValue()) {
            for (Atividade atividade : listaCompletaAtividades) {
                if (atividade.getSituacao() == null) {
                    ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o \u00e9 poss\u00edvel prosseguir, situa\u00e7\u00e3o n\u00e3o encontrada. Atividade : " + atividade.getDescricao()));
                }
                if (!atividade.getSituacao().equals("I")) continue;
                houveAlteracao = true;
                break;
            }
        } else {
            houveAlteracao = true;
        }
        if (!houveAlteracao) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o \u00e9 poss\u00edvel prosseguir sem efetuar altera\u00e7\u00e3o.");
        }
        return houveAlteracao;
    }

    private boolean temAtividadesNaLista() {
        if (this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getListaAtiv()).booleanValue()) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione pelo menos uma atividade para continuar.");
            return false;
        }
        return true;
    }

    private void atribuiImagemRestricaoPerimetro(AtividadesPermitidasResposta resposta) throws IOException {
        this.imagemWS = resposta.getAtividadesPermitidas().getImagem();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.imagemWS);
        ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemRestricaoPerimetro((StreamedContent)new DefaultStreamedContent((InputStream)bais, "image/jpeg"));
    }

    public void iniciar() {
        this.consultaAtividadeVo = new ConsultaAtividadeVo();
        this.consultaAtividadeVo.setCodigoAtividade("");
        this.solicitacao = this.solicitacaoAlvaraController.getSolicitacaoAlvara();
        if (!this.solicitacao.getListaDeAtividades().isEmpty()) {
            this.consultaAtividadeVo.setListaAtiv(this.solicitacao.getListaDeAtividades());
        }
        this.consultaAtividadeVo.setSolicitacaoAlvara(this.solicitacao);
        this.entidadeController.setImagemRestricaoPerimetro(null);
        if (!this.solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
            try {
                this.carregaTabelaAtividadesAtuais();
                this.descartarAtividadesAtuais();
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            }
        }
        this.consultaAtividadeVo.setAtividadeSelecionada(null);
    }

    private void descartarAtividadesAtuais() {
        if (this.solicitacao.isNaturezaMudancaEndereco() && this.solicitacao.isNaturezaAlteracaoAtividade()) {
            this.removerTodasAsAtividades();
            ShowMessage.addInfoMessage((String)"validacao", (String)"Nas consultas de altera\u00e7\u00e3o de endere\u00e7o e atividade(s), as atividades existentes no cadastro s\u00e3o descartadas, favor informar a(s) atividade(s) novamente.");
        }
    }

    private void removerTodasAsAtividades() {
        this.listaAtividadesExcluidas = new ArrayList();
        this.consultaAtividadeVo.getListaAtiv().forEach(ati -> {
            ati.setSituacao("E");
            this.listaAtividadesExcluidas.add(ati);
        });
        this.consultaAtividadeVo.getListaAtiv().clear();
    }

    private List<Atividade> carregarAtividadeCbo(String query) {
        List listaAtividadesCbo = null;
        ArrayList<Atividade> atividades = new ArrayList<Atividade>();
        try {
            listaAtividadesCbo = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregaListaAtividadesCboPorDescricao(query);
            atividades.addAll(listaAtividadesCbo);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return atividades;
    }

    private List<Atividade> carregarAtividadeMei(String descricao) {
        ArrayList<Atividade> atividades = new ArrayList<Atividade>();
        List listaMei = new ArrayList();
        try {
            listaMei = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarListaMeiPorDescricao(descricao, SimNaoEnum.NAO.getShortText());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        atividades.addAll(listaMei);
        return atividades;
    }

    private List<Atividade> carregarAtividadeCnae(String query) {
        ArrayList<Atividade> atividades = new ArrayList<Atividade>();
        List listaCnae = new ArrayList();
        try {
            listaCnae = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).carregarListaCnaePorDescricao(query);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        atividades.addAll(listaCnae);
        return atividades;
    }

    public List<Atividade> complete(String query) throws BaseException {
        List atividades = new ArrayList();
        if (this.solicitacao.isSolicitacaoCBO()) {
            atividades = this.carregarAtividadeCbo(query);
        } else if (this.solicitacao.isSolicitacaoMEI()) {
            atividades = this.carregarAtividadeMei(query);
        } else if (this.solicitacao.isSolicitacaoJuridicaNormal() || this.solicitacao.isSolicitacaoPrestadorServico()) {
            atividades = this.carregarAtividadeCnae(query);
        }
        return atividades;
    }

    private boolean atividadeExistenteNaTabela(Atividade atividade) {
        if (this.consultaAtividadeVo.atividadeExistenteNaTabela(atividade)) {
            ShowMessage.addErrorMessage((String)"validacao", (String)("A atividade " + atividade.getDescricao() + " j\u00e1 foi adicionada!"));
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void consultaAtividadePorCodigo() {
        if (!this.validarCodigoAtividade(this.consultaAtividadeVo.getCodigoAtividade())) return;
        try {
            block7: {
                if (this.solicitacao.isSolicitacaoMEI()) {
                    List atividadesPorCnae = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).consultaAtividadeMeiPorCnae(this.consultaAtividadeVo.getCodigoAtividade(), SimNaoEnum.NAO.getShortText());
                    if (atividadesPorCnae.size() == 1) {
                        this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividadesPorCnae.get(0));
                        break block7;
                    } else {
                        if (atividadesPorCnae.size() > 1) {
                            this.atividadeCnaeOcupacoes = atividadesPorCnae;
                            this.abrirDlgOcupacoesCnae();
                            return;
                        }
                        ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o foi encontrada nenhuma atividade com c\u00f3digo: " + this.consultaAtividadeVo.getCodigoAtividade()));
                        this.consultaAtividadeVo.setCodigoAtividade("");
                        return;
                    }
                }
                this.consultaAtividadeVo.setAtividadeSelecionada(((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).consultaAtividadePorCodigo(this.consultaAtividadeVo));
            }
            if (this.consultaAtividadeVo.getAtividadeSelecionada() == null) {
                ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o foi encontrada nenhuma atividade com c\u00f3digo: " + this.consultaAtividadeVo.getCodigoAtividade()));
                this.consultaAtividadeVo.setCodigoAtividade("");
                return;
            }
            this.consultarAtividade();
            return;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o foi poss\u00edvel consultar a atividade. " + e.getMessage()));
        }
    }

    public void verificarInformacoes() throws BaseException {
        try {
            this.verificarAtividade();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnErrorMessage((String)"validacaoInfo", (String)e.getMessage());
        }
    }

    public void verificarAtividade() throws BaseException {
        ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).consultarAtividade(this.consultaAtividadeVo);
    }

    public void consultarAtividade() {
        if (this.consultaAtividadeVo.getAtividadeSelecionada() == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Selecione uma atividade para adicionar.");
            return;
        }
        try {
            this.verificarListaDeExcluidos();
            this.imagemMapaRetornoConsulta = null;
            this.setRenderMapRetornoConsulta(false);
            if (!this.atividadeExistenteNaTabela(this.consultaAtividadeVo.getAtividadeSelecionada())) {
                if (this.solicitacao.isSolicitacaoPrestadorServico()) {
                    this.verificaCnaePrestadorServico();
                } else if (this.solicitacao.isSolicitacaoMEIPrestador()) {
                    this.consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
                    this.consultaAtividadeVo.getListaAtiv().add(this.consultaAtividadeVo.getAtividadeSelecionada());
                    this.consultaAtividadeVo.setAtividadeSelecionada(null);
                } else if (this.solicitacao.isSolicitacaoJuridicaNormal() || this.solicitacao.isSolicitacaoMEINormal() || this.solicitacao.isSolicitacaoCBO()) {
                    if (this.solicitacao.isNaturezaMudancaEndereco() && this.solicitacao.isNaturezaAlteracaoAtividade() || !this.solicitacao.isNaturezaAlteracaoAtividade()) {
                        this.consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
                        this.executaConsultaAtividade();
                    } else if (this.cadastroPossuiAtividade(this.consultaAtividadeVo.getAtividadeSelecionada()).booleanValue()) {
                        this.consultaAtividadeVo.getListaAtiv().add(this.consultaAtividadeVo.getAtividadeSelecionada());
                        this.consultaAtividadeVo.setAtividadeSelecionada(null);
                    } else {
                        this.consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
                        this.executaConsultaAtividade();
                    }
                }
            }
            this.consultaAtividadeVo.setAtividadeSelecionada(null);
            if (Objects.nonNull(this.consultaAtividadeVo.getMapaRetornoConsulta()) && Objects.nonNull(this.consultaAtividadeVo.getMapaRetornoConsulta().getImagemEmBase64())) {
                this.setRenderMapRetornoConsulta(true);
                this.imagemMapaRetornoConsulta = Base64.getDecoder().decode(this.consultaAtividadeVo.getMapaRetornoConsulta().getImagemEmBase64());
                ByteArrayInputStream bais = new ByteArrayInputStream(this.imagemMapaRetornoConsulta);
                ((EntidadeController)SpringContext.getBean(EntidadeController.class)).setImagemCadastroImobiliarioAtividadeNaoPermitida((StreamedContent)new DefaultStreamedContent((InputStream)bais, "image/jpeg"));
            }
        }
        catch (Exception e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void verificarListaDeExcluidos() {
        if (!EloListUtils.safeIsEmpty((List)this.listaAtividadesExcluidas).booleanValue() && this.listaAtividadesExcluidas.contains(this.consultaAtividadeVo.getAtividadeSelecionada())) {
            int index = this.listaAtividadesExcluidas.indexOf(this.consultaAtividadeVo.getAtividadeSelecionada());
            this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)this.listaAtividadesExcluidas.get(index));
            this.listaAtividadesExcluidas.remove(this.consultaAtividadeVo.getAtividadeSelecionada());
        }
    }

    private void executaConsultaAtividade() {
        try {
            this.verificarAtividade();
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addWarnErrorMessage((String)"validacao", (String)e.getMessage());
        }
    }

    private Boolean cadastroPossuiAtividade(Atividade atividade) {
        block3: {
            CadastroMobiliarioEntity cadastro;
            block5: {
                block4: {
                    cadastro = this.solicitacao.getCadastroMobiliario();
                    if (cadastro == null) break block3;
                    if (!this.solicitacao.isSolicitacaoJuridicaNormal()) break block4;
                    for (MobiliarioCnaeEntity cnae : cadastro.getMobiliarioCnaes()) {
                        if (!atividade.getCodigo().equals(cnae.getId().getCnae().getCodigo())) continue;
                        atividade.setSituacao("A");
                        return true;
                    }
                    break block3;
                }
                if (!this.solicitacao.isSolicitacaoMEI()) break block5;
                for (CadastroMobiliarioAtividadeMeiEntity mobMei : cadastro.getMobiliarioAtividadeMeis()) {
                    if (!atividade.getId().equals(mobMei.getAtividadeMei().getId())) continue;
                    atividade.setSituacao("A");
                    return true;
                }
                break block3;
            }
            if (!this.solicitacao.isSolicitacaoCBO()) break block3;
            for (CadastroMobiliarioCboEntity mobCBO : cadastro.getMobiliarioCbos()) {
                if (!atividade.getCodigo().equals(mobCBO.getRhCbo().getCodigo())) continue;
                atividade.setSituacao("A");
                return true;
            }
        }
        return false;
    }

    private void verificaCnaePrestadorServico() throws BaseException {
        Boolean cnaePermitido = ((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).verificaCnaePrestadorServico(this.consultaAtividadeVo.getAtividadeSelecionada());
        if (cnaePermitido.booleanValue()) {
            this.consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
            this.consultaAtividadeVo.getListaAtiv().add(this.consultaAtividadeVo.getAtividadeSelecionada());
        } else {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Atividade n\u00e3o permitida para Prestador de Servi\u00e7o.");
        }
        this.consultaAtividadeVo.setAtividadeSelecionada(null);
    }

    private void abrirDlgOcupacoesCnae() {
        this.consultaAtividadeVo.setAtividadeSelecionada(null);
        this.atividadeCnaeOcupacoesSelecionada = (Atividade)this.atividadeCnaeOcupacoes.get(0);
        RequestContext.getCurrentInstance().execute("dlgOcupacoesCnae.show()");
    }

    /*
     * Unable to fully structure code
     */
    public void selecionarOcupacao() {
        if (!EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getAtividadesSelecionadas()).booleanValue()) {
            RequestContext.getCurrentInstance().execute("dlgOcupacoesCnae.hide()");
            try {
                if (this.entidadeController.getVerificaIntegradoGeo().booleanValue()) ** GOTO lbl18
                if (this.solicitacao.isNaturezaMudancaEndereco() && this.solicitacao.isNaturezaAlteracaoAtividade() || !this.solicitacao.isNaturezaAlteracaoAtividade()) {
                    this.consultaAtividadeVo.getAtividadesSelecionadas().stream().forEach((Consumer<Atividade>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$selecionarOcupacao$1(br.com.elotech.tributacao.interfaces.Atividade ), (Lbr/com/elotech/tributacao/interfaces/Atividade;)V)());
                }
                for (Atividade atividade : this.consultaAtividadeVo.getAtividadesSelecionadas()) {
                    if (this.atividadeExistenteNaTabela(atividade)) continue;
                    this.consultaAtividadeVo.setAtividadeSelecionada(atividade);
                    this.consultarAtividade();
                }
            }
            catch (BaseException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ShowMessage.addErrorMessage((String)"validacao", (String)("N\u00e3o foi poss\u00edvel consultar a atividade. " + e.getMessage()));
            }
        } else {
            ShowMessage.addErrorMessage((String)"validacaoOcupacao", (String)"Selecione ao menos uma ocupa\u00e7\u00e3o.");
        }
lbl18:
        // 4 sources

        this.consultaAtividadeVo.setAtividadesSelecionadas(null);
        this.consultaAtividadeVo.setCodigoAtividade("");
    }

    public Integer tamanhoMaximoCodigoAtividade() {
        if (this.solicitacao.isSolicitacaoCBO()) {
            return 6;
        }
        return 7;
    }

    public String mascaraCodigoAtividade() {
        if (this.solicitacao.isSolicitacaoCBO()) {
            return "9?99999";
        }
        return "9?999999";
    }

    public boolean validarCodigoAtividade(String codigoAtividade) {
        if (!EloStringUtils.isEmpty((String)codigoAtividade.replaceAll("_", ""))) {
            if (this.solicitacao.isSolicitacaoCBO() && codigoAtividade.length() >= 4 && codigoAtividade.length() <= 6) {
                return true;
            }
            if (!this.solicitacao.isSolicitacaoCBO() && codigoAtividade.length() == 7) {
                return true;
            }
            ShowMessage.addErrorMessage((String)"validacao", (String)"C\u00f3digo inv\u00e1lido!");
            return false;
        }
        ShowMessage.addErrorMessage((String)"validacao", (String)"Escolha uma atividade!");
        return false;
    }

    private boolean naoEPrestadorEIntegradoGeo() throws BaseException {
        return !this.solicitacao.isSolicitacaoPrestadorServico() && !this.solicitacao.isSolicitacaoMEIPrestador() && this.entidadeController.getVerificaIntegradoGeo() != false;
    }

    public byte[] getImagemMapaRetornoConsulta() {
        return this.imagemMapaRetornoConsulta;
    }

    public void setImagemMapaRetornoConsulta(byte[] imagemMapaRetornoConsulta) {
        this.imagemMapaRetornoConsulta = imagemMapaRetornoConsulta;
    }

    public boolean isRenderMapRetornoConsulta() {
        return this.renderMapRetornoConsulta;
    }

    public void setRenderMapRetornoConsulta(boolean renderMapRetornoConsulta) {
        this.renderMapRetornoConsulta = renderMapRetornoConsulta;
    }

    private static /* synthetic */ void lambda$selecionarOcupacao$1(Atividade atividade) {
        atividade.setSituacao("I");
    }
}

