/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.controller;

import br.com.elotech.annotations.spring.EloController;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.EntidadeController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeStatusLaudoAlvara;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.date.EloDateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.primefaces.context.RequestContext;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.context.SecurityContextHolder;

@EloController(value="adicionarLaudoController")
@Scope(value="flow")
public class AdicionarLaudoController
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<LaudoAlvaraEntity> listaLaudos = new ArrayList();
    private SolicitacaoAlvaraEntity solicitacaoSelecionada;
    private String numeroSolicitacao;
    private String dataValidadeCadastro;
    private String razaoSocial;
    private String cpfCnpj;
    private String cadastroMobiliario;
    private TipoLaudoEntity tipoLaudoSelecionado;
    private List<TipoLaudoEntity> listaTipoLaudos;
    private StatusLaudoAlvara situacaoLaudo;
    private Date dataValidadeSelecionada;
    private Boolean disableDataProvisorio;
    private boolean renderizaDadosCadastrais;
    @Resource
    private EntidadeController entidadeController;
    private LaudoAlvaraEntity laudoSelecionado;
    private boolean solicitacaoComLaudosCancelados;

    public boolean isSolicitacaoComLaudosCancelados() {
        return this.solicitacaoComLaudosCancelados;
    }

    public void setSolicitacaoComLaudosCancelados(boolean solicitacaoComLaudosCancelados) {
        this.solicitacaoComLaudosCancelados = solicitacaoComLaudosCancelados;
    }

    public TipoLaudoEntity getTipoLaudoSelecionado() {
        return this.tipoLaudoSelecionado;
    }

    public void setTipoLaudoSelecionado(TipoLaudoEntity tipoLaudoSelecionado) {
        this.tipoLaudoSelecionado = tipoLaudoSelecionado;
    }

    public List<TipoLaudoEntity> getListaTipoLaudos() {
        return this.listaTipoLaudos;
    }

    public void setListaTipoLaudos(List<TipoLaudoEntity> listaTipoLaudos) {
        this.listaTipoLaudos = listaTipoLaudos;
    }

    public StatusLaudoAlvara getSituacaoLaudo() {
        return this.situacaoLaudo;
    }

    public void setSituacaoLaudo(StatusLaudoAlvara situacaoLaudo) {
        this.situacaoLaudo = situacaoLaudo;
    }

    public Date getDataValidadeSelecionada() {
        return this.dataValidadeSelecionada;
    }

    public void setDataValidadeSelecionada(Date dataValidadeSelecionada) {
        this.dataValidadeSelecionada = dataValidadeSelecionada;
    }

    public boolean isRenderizaDadosCadastrais() {
        return this.renderizaDadosCadastrais;
    }

    public String getDataValidadeCadastro() {
        this.dataValidadeCadastro = null;
        if (this.solicitacaoSelecionada != null) {
            this.dataValidadeCadastro = this.formataData(this.solicitacaoSelecionada.getCadastroMobiliario().getDataValidadeAlvara());
        }
        return this.dataValidadeCadastro;
    }

    public String getRazaoSocial() {
        this.razaoSocial = null;
        if (this.solicitacaoSelecionada != null) {
            this.razaoSocial = this.solicitacaoSelecionada.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome();
        }
        return this.razaoSocial;
    }

    public String getCpfCnpj() {
        this.cpfCnpj = null;
        if (this.solicitacaoSelecionada != null) {
            this.cpfCnpj = this.solicitacaoSelecionada.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf();
        }
        return this.cpfCnpj;
    }

    public String getCadastroMobiliario() {
        this.cadastroMobiliario = null;
        if (this.solicitacaoSelecionada != null) {
            this.cadastroMobiliario = this.solicitacaoSelecionada.getCadastroMobiliario().getId().getCodigo().toString();
        }
        return this.cadastroMobiliario;
    }

    public String getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    public void setNumeroSolicitacao(String numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    public List<LaudoAlvaraEntity> getListaLaudos() {
        return this.listaLaudos;
    }

    public void setListaLaudos(List<LaudoAlvaraEntity> listaLaudos) {
        this.listaLaudos = listaLaudos;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoSelecionada() {
        return this.solicitacaoSelecionada;
    }

    public void setSolicitacaoSelecionada(SolicitacaoAlvaraEntity solicitacaoSelecionada) {
        this.solicitacaoSelecionada = solicitacaoSelecionada;
    }

    public Boolean getDisableDataProvisorio() {
        return this.disableDataProvisorio;
    }

    public void setDisableDataProvisorio(Boolean disableDataProvisorio) {
        this.disableDataProvisorio = disableDataProvisorio;
    }

    public LaudoAlvaraEntity getLaudoSelecionado() {
        return this.laudoSelecionado;
    }

    public void setLaudoSelecionado(LaudoAlvaraEntity laudoSelecionado) {
        this.laudoSelecionado = laudoSelecionado;
    }

    public void pesquisarSolicitacao() {
        try {
            this.solicitacaoSelecionada = null;
            this.renderizaDadosCadastrais = false;
            Long[] numeroExercicioSolicitacao = UtilsController.separarNumeroExercicioSolicitacao((String)this.numeroSolicitacao);
            if (Objects.nonNull(numeroExercicioSolicitacao)) {
                Long numero = (long)numeroExercicioSolicitacao[0];
                Long exercicio = (long)numeroExercicioSolicitacao[1];
                this.solicitacaoSelecionada = this.getSolicitacao(numero, exercicio);
                if (this.validarSolicitacao()) {
                    this.renderizaDadosCadastrais = true;
                    this.listaLaudos = this.getLaudos(this.solicitacaoSelecionada.getSolicitacaoAlvara());
                    this.verificaLaudoProvisorio();
                }
            }
        }
        catch (BaseException e) {
            this.listaLaudos.clear();
            this.solicitacaoSelecionada = null;
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addInfoMessage((String)"validacao", (String)"Verifique o n\u00famero da Solicitacao. O n\u00famero deve estar no formato 'n\u00famero/ano' ");
        }
    }

    protected boolean validarSolicitacao() throws BaseException {
        if (this.solicitacaoSelecionada == null) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o possui solicita\u00e7\u00e3o finalizada com este n\u00famero ");
            return Boolean.FALSE;
        }
        if (this.solicitacaoSelecionada.getFinalizado() == null || SimNaoEnum.NAO.getShortText().equals(this.solicitacaoSelecionada.getFinalizado())) {
            ShowMessage.addInfoMessage((String)"validacao", (String)"N\u00e3o possui solicita\u00e7\u00e3o finalizada com este n\u00famero ");
            return Boolean.FALSE;
        }
        this.solicitacaoComLaudosCancelados = ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).isExisteLaudoComSituacaoCancelado(this.solicitacaoSelecionada);
        if (this.solicitacaoComLaudosCancelados) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Solicita\u00e7\u00e3o com os laudos cancelados.");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected List<LaudoAlvaraEntity> getLaudos(Long solicitacao) throws BaseException {
        return ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).buscaLaudosPorSolicitacao(solicitacao);
    }

    protected SolicitacaoAlvaraEntity getSolicitacao(Long numero, Long exercicio) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpjExercicioNumSolic(numero, exercicio, null);
    }

    public String formataData(Date data) {
        String dataFormatada = "";
        if (data != null) {
            dataFormatada = EloDateUtils.toAnsiDateString((Date)data, (String)"dd/MM/yyyy");
        }
        return dataFormatada;
    }

    public void verificaLaudoProvisorio() {
        if (this.situacaoLaudo == StatusLaudoAlvara.LIBERADO_PROVISORIO) {
            this.disableDataProvisorio = false;
        } else {
            this.disableDataProvisorio = true;
            this.dataValidadeSelecionada = null;
        }
    }

    public void iniciar() {
        try {
            this.listaTipoLaudos = this.getTipoLaudos();
            this.listaLaudos = new ArrayList();
            this.renderizaDadosCadastrais = false;
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma falha na inicializa\u00e7\u00e3o da p\u00e1gina.");
        }
    }

    public List<TipoLaudoEntity> getTipoLaudos() throws BaseException {
        return ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).getListaTipoLaudo();
    }

    public void adicionarLaudo() {
        try {
            if (this.validarCamposAdicionarLaudo()) {
                LaudoAlvaraEntity laudo = new LaudoAlvaraEntity();
                laudo.setIdSolicitacaoAlvara(this.solicitacaoSelecionada);
                laudo.setStatus(this.situacaoLaudo);
                laudo.setTipoLaudo(this.tipoLaudoSelecionado);
                laudo.setUsuario(this.getUsuarioConectado());
                laudo.setDataValidade(this.dataValidadeSelecionada);
                ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoAlvara(laudo);
                this.pesquisarSolicitacao();
            }
        }
        catch (BaseException e) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma falha na grava\u00e7\u00e3o.");
        }
    }

    protected boolean validarCamposAdicionarLaudo() {
        if (this.solicitacaoSelecionada == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o n\u00famero da solicita\u00e7\u00e3o e clique em pesquisar.");
            return false;
        }
        if (this.tipoLaudoSelecionado == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe o laudo que deseja adicionar.");
            return false;
        }
        if (this.solicitacaoJaPossuiLaudo()) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A solicita\u00e7\u00e3o j\u00e1 possui este laudo.");
            return false;
        }
        if (this.situacaoLaudo == StatusLaudoAlvara.LIBERADO_PROVISORIO && this.dataValidadeSelecionada == null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Adicionar uma data de validade para um laudo provis\u00f3rio.");
            return false;
        }
        return true;
    }

    private boolean solicitacaoJaPossuiLaudo() {
        for (LaudoAlvaraEntity laudoAlvara : this.listaLaudos) {
            if (!laudoAlvara.getTipoLaudo().equals((Object)this.tipoLaudoSelecionado)) continue;
            return true;
        }
        return false;
    }

    private UsuarioEntity getUsuarioConectado() {
        return (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    public void delete(LaudoAlvaraEntity laudo) {
        try {
            ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).deleteLaudoAlvara(laudo);
            this.listaLaudos = this.getLaudos(this.solicitacaoSelecionada.getSolicitacaoAlvara());
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"N\u00e3o \u00e9 poss\u00edvel remover este laudo porque possui v\u00ednculo com outras informa\u00e7\u00f5es.");
        }
    }

    public List<StatusLaudoAlvara> getStatus() throws BaseException {
        return ((FacadeStatusLaudoAlvara)SpringContext.getBean(FacadeStatusLaudoAlvara.class)).getStatusLaudoAlvaraPermitidos(this.entidadeController.getEntidade());
    }

    public void editar(LaudoAlvaraEntity laudo) {
        this.laudoSelecionado = laudo;
        RequestContext.getCurrentInstance().execute("dialogEditarParecer.show()");
    }

    public void salvarValidadeLaudo() {
        try {
            ((FacadeLaudoAlvara)SpringContext.getBean(FacadeLaudoAlvara.class)).salvarLaudoAlvara(this.laudoSelecionado);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            ShowMessage.addErrorMessage((String)"validacao", (String)"Ocorreu uma falha ao atualizar a validade do Laudo");
        }
        RequestContext.getCurrentInstance().execute("dialogEditarParecer.hide()");
    }
}

