/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.common;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.rest.AlvaraObjectMapper;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommonGeraDocumento
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 4162676709897576076L;
    public static final Boolean GERAR_ITEM_APOS_DOCUMENTO = Boolean.FALSE;
    public static final String MODULO_RELATORIO = "05";
    public static final String CLASS_NAME = "TDocumentoExecuteAlvaraLocalizacao";
    @JsonProperty(value="ClassName")
    private String className;
    @JsonProperty(value="Entidade")
    private Integer entidade;
    @JsonProperty(value="Exercicio")
    private Integer exercicio;
    @JsonProperty(value="TipoDocumento")
    private Integer tipoDocumento;
    @JsonProperty(value="Documento")
    private Integer documento;
    @JsonProperty(value="Impresso")
    private Boolean impresso;
    @JsonProperty(value="DataEmissao")
    private Date dataEmissao;
    @JsonProperty(value="Usuario")
    private String usuario;
    @JsonProperty(value="DataSolicitacao")
    private Date dataSolicitacao;
    @JsonProperty(value="Requerente")
    private String requerente;
    @JsonProperty(value="CpfRequerente")
    private String cpfRequerente;
    @JsonProperty(value="TipoCadastro")
    private Integer tipoCadastro;
    @JsonProperty(value="CadastroGeral")
    private Integer cadastroGeral;
    @JsonProperty(value="Pessoa")
    private Integer pessoa;
    @JsonProperty(value="subTipo")
    private String subTipo;
    @JsonProperty(value="ModuloRelatorio")
    private String moduloRelatorio;
    @JsonProperty(value="TipoRelatorio")
    private String tipoRelatorio;
    @JsonProperty(value="Relatorio")
    private Integer relatorio;
    @JsonProperty(value="PorCadastro")
    private Boolean porCadastro;
    @JsonProperty(value="Web")
    private Boolean web;
    @JsonProperty(value="TipoPessoaRequerente")
    private String tipoPessoaRequerente;
    @JsonProperty(value="CNPJ_CPF")
    private String cnpjCpf;
    @JsonProperty(value="CasoEspecial")
    private Boolean casoEspecial;
    @JsonProperty(value="TipoDocumento_Descricao")
    private String tipoDocumentoDescricao;
    @JsonProperty(value="EmitirCertidaoEspecial")
    private Boolean emitirCertidaoEspecial;
    @JsonProperty(value="NaoAlteradoDocumentoCadastro")
    private Boolean naoAlteradoDocumentoCadastro;
    @JsonProperty(value="AnoEmissaoAlvara")
    private String anoEmissaoAlvara;
    @JsonProperty(value="MaisDeUmLayout")
    private Boolean maisDeUmLayout;
    @JsonProperty(value="GerarItemAposDocumento")
    private Boolean gerarItemAposDocumento;
    @JsonProperty(value="DataPrimeiroAlvara")
    private Date dataPrimeiroAlvara;
    @JsonProperty(value="Cancelado")
    private String cancelado;
    @JsonProperty(value="Situacao")
    private Integer situacao;
    @JsonProperty(value="CodigoValidacao")
    private String codigoValidacao;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Integer getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Integer entidade) {
        this.entidade = entidade;
    }

    public Integer getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    public Integer getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(Integer tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public Boolean getImpresso() {
        return this.impresso;
    }

    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getRequerente() {
        return this.requerente;
    }

    public void setRequerente(String requerente) {
        this.requerente = requerente;
    }

    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Integer getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Integer cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Integer getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Integer pessoa) {
        this.pessoa = pessoa;
    }

    public String getSubTipo() {
        return this.subTipo;
    }

    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }

    public String getModuloRelatorio() {
        return this.moduloRelatorio;
    }

    public void setModuloRelatorio(String moduloRelatorio) {
        this.moduloRelatorio = moduloRelatorio;
    }

    public String getTipoRelatorio() {
        return this.tipoRelatorio;
    }

    public void setTipoRelatorio(String tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
    }

    public Integer getRelatorio() {
        return this.relatorio;
    }

    public void setRelatorio(Integer relatorio) {
        this.relatorio = relatorio;
    }

    public Boolean getPorCadastro() {
        return this.porCadastro;
    }

    public void setPorCadastro(Boolean porCadastro) {
        this.porCadastro = porCadastro;
    }

    public Boolean getWeb() {
        return this.web;
    }

    public void setWeb(Boolean web) {
        this.web = web;
    }

    public String getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    public void setTipoPessoaRequerente(String tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Boolean getCasoEspecial() {
        return this.casoEspecial;
    }

    public void setCasoEspecial(Boolean casoEspecial) {
        this.casoEspecial = casoEspecial;
    }

    public String getTipoDocumentoDescricao() {
        return this.tipoDocumentoDescricao;
    }

    public void setTipoDocumentoDescricao(String tipoDocumentoDescricao) {
        this.tipoDocumentoDescricao = tipoDocumentoDescricao;
    }

    public Boolean getEmitirCertidaoEspecial() {
        return this.emitirCertidaoEspecial;
    }

    public void setEmitirCertidaoEspecial(Boolean emitirCertidaoEspecial) {
        this.emitirCertidaoEspecial = emitirCertidaoEspecial;
    }

    public Boolean getNaoAlteradoDocumentoCadastro() {
        return this.naoAlteradoDocumentoCadastro;
    }

    public void setNaoAlteradoDocumentoCadastro(Boolean naoAlteradoDocumentoCadastro) {
        this.naoAlteradoDocumentoCadastro = naoAlteradoDocumentoCadastro;
    }

    public String getAnoEmissaoAlvara() {
        return this.anoEmissaoAlvara;
    }

    public void setAnoEmissaoAlvara(String anoEmissaoAlvara) {
        this.anoEmissaoAlvara = anoEmissaoAlvara;
    }

    public Boolean getMaisDeUmLayout() {
        return this.maisDeUmLayout;
    }

    public void setMaisDeUmLayout(Boolean maisDeUmLayout) {
        this.maisDeUmLayout = maisDeUmLayout;
    }

    public Boolean getGerarItemAposDocumento() {
        return this.gerarItemAposDocumento;
    }

    public void setGerarItemAposDocumento(Boolean gerarItemAposDocumento) {
        this.gerarItemAposDocumento = gerarItemAposDocumento;
    }

    public Date getDataPrimeiroAlvara() {
        return this.dataPrimeiroAlvara;
    }

    public void setDataPrimeiroAlvara(Date dataPrimeiroAlvara) {
        this.dataPrimeiroAlvara = dataPrimeiroAlvara;
    }

    public String getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(String cancelado) {
        this.cancelado = cancelado;
    }

    public Integer getSituacao() {
        return this.situacao;
    }

    public void setSituacao(Integer situacao) {
        this.situacao = situacao;
    }

    public Integer getDocumento() {
        return this.documento;
    }

    public void setDocumento(Integer documento) {
        this.documento = documento;
    }

    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    public void criarJson(SolicitacaoAlvaraEntity solicitacao, EntidadeTributacaoEntity entidadeTributacao) {
        this.setClassName(CLASS_NAME);
        this.setAnoEmissaoAlvara(entidadeTributacao.getId().getExercicioTributacao().getExercicio().toString());
        this.setCadastroGeral(Integer.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getId().getCodigo().intValue()));
        this.setCasoEspecial(Boolean.FALSE);
        this.setCnpjCpf(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
        this.setCpfRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
        this.setDataEmissao(new Date());
        this.setDataSolicitacao(solicitacao.getDataSolicitacao());
        this.setEmitirCertidaoEspecial(Boolean.FALSE);
        this.setEntidade(Integer.valueOf(entidadeTributacao.getId().getEntidade().getId().intValue()));
        this.setExercicio(Integer.valueOf(entidadeTributacao.getId().getExercicioTributacao().getExercicio().intValue()));
        this.setImpresso(Boolean.TRUE);
        this.setMaisDeUmLayout(Boolean.FALSE);
        this.setModuloRelatorio(MODULO_RELATORIO);
        this.setNaoAlteradoDocumentoCadastro(Boolean.FALSE);
        this.setPessoa(Integer.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getPessoa().intValue()));
        this.setPorCadastro(Boolean.TRUE);
        this.setRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
        this.setSubTipo(SimNaoEnum.NAO.getShortText());
        this.setTipoCadastro(Integer.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getId().getTipo().intValue()));
        this.setTipoPessoaRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getTipoPessoa());
        this.setTipoRelatorio(SimNaoEnum.SIM.getShortText());
        this.setUsuario(PortalUtils.getUsuarioalvaraonline());
        this.setGerarItemAposDocumento(GERAR_ITEM_APOS_DOCUMENTO);
        this.setWeb(Boolean.TRUE);
        this.setCancelado(SimNaoEnum.NAO.getShortText());
        this.setSituacao(Integer.valueOf(1));
        this.setDataPrimeiroAlvara(new Date());
    }

    public void criarJsonObservacao(EntidadeTributacaoEntity entidadeTributacao) {
        this.setClassName(CLASS_NAME);
        this.setAnoEmissaoAlvara(entidadeTributacao.getId().getExercicioTributacao().getExercicio().toString());
        this.setCasoEspecial(Boolean.FALSE);
        this.setDataEmissao(new Date());
        this.setEmitirCertidaoEspecial(Boolean.FALSE);
        this.setEntidade(Integer.valueOf(entidadeTributacao.getId().getEntidade().getId().intValue()));
        this.setExercicio(Integer.valueOf(entidadeTributacao.getId().getExercicioTributacao().getExercicio().intValue()));
        this.setImpresso(Boolean.TRUE);
        this.setMaisDeUmLayout(Boolean.FALSE);
        this.setModuloRelatorio(MODULO_RELATORIO);
        this.setNaoAlteradoDocumentoCadastro(Boolean.FALSE);
        this.setPorCadastro(Boolean.TRUE);
        this.setSubTipo(SimNaoEnum.NAO.getShortText());
        this.setTipoRelatorio(SimNaoEnum.SIM.getShortText());
        this.setUsuario(PortalUtils.getUsuarioalvaraonline());
        this.setGerarItemAposDocumento(GERAR_ITEM_APOS_DOCUMENTO);
        this.setWeb(Boolean.TRUE);
        this.setCancelado(SimNaoEnum.NAO.getShortText());
        this.setSituacao(Integer.valueOf(1));
        this.setDataPrimeiroAlvara(new Date());
    }

    public String formatJson() {
        return AlvaraObjectMapper.jsonToString((Object)this);
    }
}

