/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.domainLayer.EntityDef;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandSincronizarWebIss;
import br.com.elotech.portalarrecadacao.dao.DaoAlvaraSincronizacaoCadastro;
import br.com.elotech.portalarrecadacao.domain.AlvaraSincronizacaoCadastroEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RegimeAlvaraWebIssEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.dto.webiss.AtividadeWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.CnaeWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.ContatoWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.ContribuinteWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.EnderecoWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.PessoaJuridicaWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.RespostaSincronizacaoWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.SincronizacaoWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.SituacaoPessoaJuridicaWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.SocioWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.TelefoneWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.TipoContribuinteWebIssDTO;
import br.com.elotech.portalarrecadacao.dto.webiss.TipoEnderecoWebIssDTO;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryRegimeAlvaraWebIss;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.domain.aise.RegimeFiscalPeriodoRealAiseEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryRegimeFiscalPeriodoRealAise;
import br.com.elotech.tributacao.repository.aise.RepositoryRepresentanteLegal;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@EloCommand(value="commandSincronizarWebIss")
@Scope(value="prototype")
public class CommandSincronizarWebIssImpl
implements CommandSincronizarWebIss {
    private static final Logger log = LoggerFactory.getLogger(CommandSincronizarWebIssImpl.class);
    private SolicitacaoRedeSimEntity solicitacaoRedeSimEntity;
    private AlvaraSincronizacaoCadastroEntity sincronizacao;
    private RespostaSincronizacaoWebIssDTO respostaSincronizacaoWebIssDTO;
    @Autowired
    private DaoAlvaraSincronizacaoCadastro daoAlvaraSincronizacaoCadastro;
    @Autowired
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Autowired
    private RepositoryRepresentanteLegal repositoryRepresentanteLegal;
    @Autowired
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;
    @Autowired
    private RepositoryRegimeFiscalPeriodoRealAise repositoryRegimeFiscalPeriodoRealAise;
    @Autowired
    private RepositoryRegimeAlvaraWebIss repositoryRegimeAlvaraWebIss;
    @Autowired
    private RestTemplate restTemplate;

    public void setSolicitacaoRedeSimEntity(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) {
        this.solicitacaoRedeSimEntity = solicitacaoRedeSimEntity;
    }

    public void setSincronizacao(AlvaraSincronizacaoCadastroEntity sincronizacao) {
        this.sincronizacao = sincronizacao;
    }

    private List<String> getCpfCnpjRepresentantesCadastroMobiliario(Long idCadastroGeral) {
        return this.repositoryRepresentanteLegal.findByIdCadastroGeral(idCadastroGeral).stream().map(a -> a.getPessoa().getCnpjCpf()).distinct().collect(Collectors.toList());
    }

    public void execute() throws BaseException {
        ParametroAlvaraEntity urlWebiss = this.srvSolicitacaoAlvaraHelper.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.URL_WEBISS);
        if (StringUtils.isEmpty((String)urlWebiss.getValor())) {
            return;
        }
        try {
            SolicitacaoAlvaraEntity solicitacaoAlvaraEntity = Optional.ofNullable(this.solicitacaoRedeSimEntity.getSolicitacaoAlvara()).map(arg_0 -> ((RepositorySolicitacaoAlvara)this.repositorySolicitacaoAlvara).inicializarDadosSolicitacaoAlvara(arg_0)).orElseThrow(() -> new RuntimeException("A solicita\u00e7\u00e3o da rede sim n\u00e3o possui nenhuma solicita\u00e7\u00e3o de alvar\u00e1 associado."));
            CadastroMobiliarioEntity cadastroMobiliario = Optional.ofNullable(solicitacaoAlvaraEntity.getCadastroMobiliario()).orElseThrow(() -> new RuntimeException("A solicita\u00e7\u00e3o da rede sim n\u00e3o possui nenhuma solicita\u00e7\u00e3o de alvar\u00e1 associado."));
            PessoaJuridicaWebIssDTO pessoaJuridicaDto = new PessoaJuridicaWebIssDTO();
            pessoaJuridicaDto.setSituacao(SituacaoPessoaJuridicaWebIssDTO.ATIVA);
            pessoaJuridicaDto.setRazaoSocial(cadastroMobiliario.getCadastroGeral().getPessoa().getNome());
            pessoaJuridicaDto.setCnpj(cadastroMobiliario.getCadastroGeral().getPessoa().getCnpjCpf());
            pessoaJuridicaDto.setNomeFantasia(cadastroMobiliario.getCadastroGeral().getPessoa().getNomeFantasia());
            pessoaJuridicaDto.setInscricaoEstadual(cadastroMobiliario.getCadastroGeral().getPessoa().getInscricaoEstadual());
            pessoaJuridicaDto.setDataAbertura(cadastroMobiliario.getDataAbertura());
            pessoaJuridicaDto.setNaturezaJuridica(cadastroMobiliario.getNaturezaJuridica().getIdNaturezaJuridica().toString());
            pessoaJuridicaDto.setCnaes(cadastroMobiliario.getMobiliarioCnaes().stream().map(a -> CnaeWebIssDTO.from((MobiliarioCnaeEntity)a, (CadastroMobiliarioEntity)cadastroMobiliario)).collect(Collectors.toList()));
            EnderecoWebIssDTO enderecoLocalizacao = EnderecoWebIssDTO.from((CadastroGeralAiseEntity)cadastroMobiliario.getCadastroGeral(), (TipoEnderecoWebIssDTO)TipoEnderecoWebIssDTO.LOCALIZACAO);
            EnderecoWebIssDTO enderecoCorrespondencia = EnderecoWebIssDTO.from((CadastroGeralAiseEntity)cadastroMobiliario.getCadastroGeral(), (TipoEnderecoWebIssDTO)TipoEnderecoWebIssDTO.CORRESPONDENCIA);
            pessoaJuridicaDto.setEnderecos(Arrays.asList(enderecoLocalizacao, enderecoCorrespondencia));
            pessoaJuridicaDto.setTelefones(Arrays.asList(new TelefoneWebIssDTO("Comercial", cadastroMobiliario.getTelefone())));
            pessoaJuridicaDto.setEmails(Arrays.asList(cadastroMobiliario.getCadastroGeral().getPessoa().getContatoPessoaPrincipal().getEmail()));
            pessoaJuridicaDto.setSocios(SocioWebIssDTO.from((CadastroMobiliarioEntity)cadastroMobiliario, (String)this.solicitacaoRedeSimEntity.getArquivoDadosEmpresa(), (List)this.getCpfCnpjRepresentantesCadastroMobiliario(cadastroMobiliario.getCadastroGeral().getId().getCodigo())));
            ContribuinteWebIssDTO dtoContribuinte = new ContribuinteWebIssDTO();
            dtoContribuinte.setTipo(TipoContribuinteWebIssDTO.NORMAL);
            dtoContribuinte.setRegime(this.getRegimeAlvara(cadastroMobiliario));
            dtoContribuinte.setDataInicio(cadastroMobiliario.getDataAbertura());
            dtoContribuinte.setValorEstimado(new BigDecimal(0));
            dtoContribuinte.setEndereco(EnderecoWebIssDTO.from((CadastroGeralAiseEntity)cadastroMobiliario.getCadastroGeral(), (TipoEnderecoWebIssDTO)TipoEnderecoWebIssDTO.LOCALIZACAO));
            dtoContribuinte.setContato(ContatoWebIssDTO.from((ContatoPessoaEntity)cadastroMobiliario.getCadastroGeral().getPessoa().getContatoPessoaPrincipal()));
            dtoContribuinte.setInscricaoMunicipal(cadastroMobiliario.getCadastroGeral().getId().getCodigo().toString());
            dtoContribuinte.setAtividades(cadastroMobiliario.getMobiliarioServicos().stream().map(AtividadeWebIssDTO::from).distinct().collect(Collectors.toList()));
            SincronizacaoWebIssDTO dto = new SincronizacaoWebIssDTO();
            dto.setPessoaJuridicaWebIssDTO(pessoaJuridicaDto);
            dto.setContribuintes(Arrays.asList(dtoContribuinte));
            ParametroAlvaraEntity tokenAcessoWebiss = this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.TOKEN_ACESSO_WEBISS);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("autenticacao", tokenAcessoWebiss.getValor());
            HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(urlWebiss.getValor() + "/api/dados/sincronizar", (Object)request, RespostaSincronizacaoWebIssDTO.class, new Object[0]);
            this.respostaSincronizacaoWebIssDTO = (RespostaSincronizacaoWebIssDTO)response.getBody();
            this.salvarSincronizacao((RespostaSincronizacaoWebIssDTO)response.getBody(), new ObjectMapper().writeValueAsString((Object)request));
        }
        catch (JsonProcessingException e) {
            log.error("Erro ao salvar o log da sincroniza\u00e7\u00e3o", (Throwable)e);
        }
        catch (Exception ex) {
            throw new SolicitacaoAlvaraException(String.format("Erro ao integrar com a webiss: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    private Long getRegimeAlvara(CadastroMobiliarioEntity cadastroMobiliario) {
        RegimeAlvaraWebIssEntity regimeWebIss;
        List regimes = this.repositoryRegimeFiscalPeriodoRealAise.findByIdUnico(cadastroMobiliario.getCadastroGeral().getIdUnico());
        RegimeFiscalPeriodoRealAiseEntity regimeVigente = regimes.stream().filter(RegimeFiscalPeriodoRealAiseEntity::isActual).findFirst().orElse(null);
        if (Objects.nonNull(regimeVigente) && Objects.nonNull(regimeWebIss = this.repositoryRegimeAlvaraWebIss.getByRegimeFiscal(regimeVigente.getIdRegimeFiscal()))) {
            return regimeWebIss.getRegimeWebIss();
        }
        return null;
    }

    private void salvarSincronizacao(RespostaSincronizacaoWebIssDTO response, String request) {
        AlvaraSincronizacaoCadastroEntity alvaraSincronizacao = Optional.ofNullable(this.sincronizacao).orElse(new AlvaraSincronizacaoCadastroEntity());
        alvaraSincronizacao.setDataHora(new Date());
        alvaraSincronizacao.setMotivo(response.getMotivo());
        alvaraSincronizacao.setProtocolo(response.getProtocolo());
        alvaraSincronizacao.setSolicitacaoRedeSim(this.solicitacaoRedeSimEntity);
        alvaraSincronizacao.setStatus(response.getStatus());
        alvaraSincronizacao.setRequest(request);
        this.daoAlvaraSincronizacaoCadastro.saveOrUpdate((EntityDef)alvaraSincronizacao);
    }

    public RespostaSincronizacaoWebIssDTO getRespostaSincronizacaoWebIssDTO() {
        return this.respostaSincronizacaoWebIssDTO;
    }
}

