/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandSalvarCadastroGeral;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandSalvarCadastroGeral")
@Scope(value="prototype")
public class CommandSalvarCadastroGeralImpl
implements CommandSalvarCadastroGeral {
    private CadastroGeralAiseEntity cadastroGeral;
    private SolicitacaoAlvaraEntity solicitacao;
    @Resource
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;

    public void execute() throws BaseException {
        if (this.solicitacao.isSolicitacaoJuridicaNormal()) {
            this.cadastroGeral = this.srvSolicitacaoAlvara.salvarCadastroGeral(this.solicitacao.getCadastroMobiliario().getCadastroGeral(), this.solicitacao);
        } else if (this.solicitacao.isSolicitacaoMEI()) {
            this.cadastroGeral = this.srvSolicitacaoAlvaraMEI.salvarCadastroGeral(this.solicitacao.getCadastroMobiliario().getCadastroGeral(), this.solicitacao);
        } else if (this.solicitacao.isSolicitacaoPrestadorServico()) {
            this.cadastroGeral = this.srvSolicitacaoAlvaraPrestadorServico.salvarCadastroGeral(this.solicitacao.getCadastroMobiliario().getCadastroGeral(), this.solicitacao);
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public CadastroGeralAiseEntity getCadastroGeral() {
        return this.cadastroGeral;
    }
}

