/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.agendamento.job.JobEnvioEmailAlteracoesSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandProcessarFilaEnvioEmailSolicitacao;
import br.com.elotech.portalarrecadacao.domain.FilaEnvioEmailSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.StatusFilaEnvioEmailSolicitacaoEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryFilaEnvioEmailSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvEnviaEmailAlteracoesSolicitacao;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandProcessarFilaEnvioEmailSolicitacao")
@Scope(value="prototype")
public class CommandProcessarFilaEnvioEmailSolicitacaoImpl
implements CommandProcessarFilaEnvioEmailSolicitacao {
    @Resource
    private RepositoryFilaEnvioEmailSolicitacaoAlvara repositoryFilaEnvioEmailSolicitacaoAlvara;
    @Resource
    private SrvEnviaEmailAlteracoesSolicitacao srvEnviaEmailAlteracoesSolicitacao;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        List filaEnvio = this.repositoryFilaEnvioEmailSolicitacaoAlvara.getAguardandoProcessamento();
        for (FilaEnvioEmailSolicitacaoAlvaraEntity item : filaEnvio) {
            item.setStatus(StatusFilaEnvioEmailSolicitacaoEnum.PROCESSANDO);
            this.repositoryFilaEnvioEmailSolicitacaoAlvara.saveOrUpdate(item);
        }
        Map<SolicitacaoAlvaraEntity, List<FilaEnvioEmailSolicitacaoAlvaraEntity>> filaAgrupadaPorSolicitacao = filaEnvio.stream().collect(Collectors.groupingBy(FilaEnvioEmailSolicitacaoAlvaraEntity::getSolicitacaoAlvara));
        for (SolicitacaoAlvaraEntity solicitacao : filaAgrupadaPorSolicitacao.keySet()) {
            List<Object> fila = filaAgrupadaPorSolicitacao.get(solicitacao);
            fila = fila.stream().sorted((f1, f2) -> f1.getId().compareTo(f2.getId())).collect(Collectors.toList());
            try {
                this.srvEnviaEmailAlteracoesSolicitacao.enviaEmailDireto(solicitacao, fila);
                this.repositoryFilaEnvioEmailSolicitacaoAlvara.remove(fila);
            }
            catch (BaseException e) {
                for (FilaEnvioEmailSolicitacaoAlvaraEntity filaEnvioEmailSolicitacaoAlvaraEntity : fila) {
                    filaEnvioEmailSolicitacaoAlvaraEntity.setStatus(StatusFilaEnvioEmailSolicitacaoEnum.AGUARDANDO_PROCESSAMENTO);
                    this.repositoryFilaEnvioEmailSolicitacaoAlvara.saveOrUpdate(filaEnvioEmailSolicitacaoAlvaraEntity);
                }
                Logger.getLogger(JobEnvioEmailAlteracoesSolicitacao.class.getName()).log(Level.SEVERE, "Erro ao tentar enviar email de altera\u00e7\u00f5es da solicita\u00e7\u00e3o", solicitacao.getNumeroSolicitacaoExercicio());
                Logger.getLogger(JobEnvioEmailAlteracoesSolicitacao.class.getName()).log(Level.SEVERE, "Exception", e);
            }
        }
    }
}

