/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandHibernateInitializeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroImobiliario;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandHibernateInitializeSolicitacaoAlvara")
public class CommandHibernateInitializeSolicitacaoAlvaraImpl
extends EloLogger
implements CommandHibernateInitializeSolicitacaoAlvara {
    @Resource
    private RepositoryCadastroImobiliario repositoryCadastroImobiliario;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;

    public void execute() throws BaseException {
        this.inicializarDadosSolicitacaoAlvara();
    }

    private void inicializarDadosSolicitacaoAlvara() {
        Hibernate.initialize((Object)this.solicitacaoAlvara.getDebitos());
        Hibernate.initialize((Object)this.solicitacaoAlvara.getLaudos());
        if (!EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getLaudos()).booleanValue()) {
            for (LaudoAlvaraEntity laudoAlvara : this.solicitacaoAlvara.getLaudos()) {
                laudoAlvara = this.repositoryLaudoAlvara.refresh(laudoAlvara);
                Hibernate.initialize((Object)laudoAlvara.getDocumentos());
                Hibernate.initialize((Object)laudoAlvara.getObservacoesTipoLaudo());
                Hibernate.initialize((Object)laudoAlvara.getHistoricosRenovacao());
            }
        }
        if (Objects.nonNull(this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades())) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades());
            this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades().forEach(p -> Hibernate.initialize((Object)p.getNumerosConselho()));
        }
        if (!EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getNaturezas()).booleanValue()) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getNaturezas());
        }
        if (!EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getDocumentos()).booleanValue()) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getDocumentos());
        }
        if (!EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getSefazDocumentos()).booleanValue()) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getSefazDocumentos());
            this.solicitacaoAlvara.getSefazDocumentos().forEach(sefazDocumento -> Hibernate.initialize((Object)sefazDocumento.getTipoDocumento()));
        }
        if (!EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades());
            for (SolicitacaoAlvaraAtividadeEntity atividade : this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                Hibernate.initialize((Object)atividade.getNumerosConselho());
            }
        }
        Optional.ofNullable(this.solicitacaoAlvara.getCadastroMobiliario()).ifPresent(cadastroMobiliario -> {
            SituacaoMobiliarioEntity situacaoAtual;
            Hibernate.initialize((Object)cadastroMobiliario);
            this.repositoryCadastroGeral.refresh(cadastroMobiliario.getCadastroGeral());
            Hibernate.initialize((Object)cadastroMobiliario.getCadastroGeral().getIsencoes());
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioHorarioEspecial());
            Hibernate.initialize((Object)cadastroMobiliario.getContratosSociais());
            if (!EloListUtils.safeIsEmpty((List)cadastroMobiliario.getContratosSociais()).booleanValue()) {
                for (ContratoSocialEntity contratoSocial : cadastroMobiliario.getContratosSociais()) {
                    Hibernate.initialize((Object)contratoSocial.getPessoas());
                    for (ContratoSocialPessoaEntity contratoPessoa : contratoSocial.getPessoas()) {
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getEnderecos());
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getContatos());
                    }
                }
            }
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioCnaes());
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioAtividadeMeis());
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioCbos());
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioSituacao());
            Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioServicos());
            if (Objects.nonNull(cadastroMobiliario.getCadastroGeral()) && Objects.nonNull(cadastroMobiliario.getCadastroGeral().getPessoa())) {
                Hibernate.initialize((Object)cadastroMobiliario.getCadastroGeral().getPessoa().getEnderecos());
            }
            cadastroMobiliario.getMobiliarioSituacao().forEach(s -> {
                if (Objects.nonNull(s.getSituacaoMobiliario())) {
                    Hibernate.initialize((Object)s.getSituacaoMobiliario().getSituacoesMobiliarioAlvara());
                }
            });
            if (Objects.nonNull(cadastroMobiliario.getCadastroImobiliario())) {
                Hibernate.initialize((Object)cadastroMobiliario.getCadastroImobiliario());
                Hibernate.initialize((Object)cadastroMobiliario.getCadastroImobiliario().getSegmentos());
                Hibernate.initialize((Object)cadastroMobiliario.getCadastroImobiliario().getTestadas());
                Hibernate.initialize((Object)cadastroMobiliario.getCadastroImobiliario().getTestadasGenericas());
            }
            if (Objects.nonNull(situacaoAtual = cadastroMobiliario.getMobiliarioSituacaoAtual())) {
                Hibernate.initialize((Object)situacaoAtual.getSituacoesMobiliarioAlvara());
            }
            if (Objects.nonNull(cadastroMobiliario.getCadastroGeral()) && Objects.nonNull(cadastroMobiliario.getCadastroGeral().getPessoa())) {
                Hibernate.initialize((Object)cadastroMobiliario.getCadastroGeral().getPessoa().getContatos());
            }
        });
        if (Objects.nonNull(this.solicitacaoAlvara.getContratoSocial())) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getContratoSocial().getPessoas());
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }
}

