/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandGeracaoEnvioTermoDispensaRedeSim;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandGeracaoEnvioTermoDispensaRedeSim")
@Scope(value="prototype")
public class CommandGeracaoEnvioTermoDispensaRedeSimImpl
extends EloLogger
implements CommandGeracaoEnvioTermoDispensaRedeSim {
    private SolicitacaoRedeSimEntity solicitacaoRedeSimEntity;
    @Resource
    private SrvConsultaPrevia srvConsultaPrevia;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;

    public void execute() throws BaseException {
        this.reloadSolicitacaoRedeSim();
        this.solicitacaoRedeSimEntity.setAlvaraEnviado(TipoAlvaraEnum.LIBERDADE_ECONOMICA);
        this.srvSolicitacaoAlvaraRedeSim.generateTermoDispensa(this.solicitacaoRedeSimEntity, Boolean.TRUE.booleanValue());
        this.reloadSolicitacaoRedeSim();
        this.srvSolicitacaoAlvaraRedeSim.sendDocumentoTermoDispensa(this.solicitacaoRedeSimEntity);
    }

    public void setSolicitacaoRedeSimEntity(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) {
        this.solicitacaoRedeSimEntity = solicitacaoRedeSimEntity;
    }

    private void reloadSolicitacaoRedeSim() {
        this.repositoryConsultaRedeSim.flush();
        this.solicitacaoRedeSimEntity = this.srvConsultaPrevia.getSolicitacaoByProtocoloAndTipo(this.solicitacaoRedeSimEntity.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }
}

