/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandFindSolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ModeloDocumentoNotFoundException;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoDocumentosDTO;
import br.com.elotech.portalarrecadacao.utils.JsonUtils;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandFindSolicitacaoDocRedeSim")
@Scope(value="prototype")
public class CommandFindSolicitacaoDocRedeSimImpl
implements CommandFindSolicitacaoDocRedeSim {
    private SolicitacaoDocumentosDTO solicitacaoDocumentosDTO;
    private SolicitacaoDocRedeSimEntity solicitacaoDocRedeSim;
    @Autowired
    private RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim;

    public void execute() throws BaseException {
        Integer tipoModeloDocumento = this.solicitacaoDocumentosDTO.getDados_solicitacao_documento().getCo_tipo_modelo_documento();
        String protocolo = this.solicitacaoDocumentosDTO.getDados_solicitacao_documento().getCo_protocolo_redesim();
        if (Objects.nonNull(tipoModeloDocumento)) {
            ModeloDocumentoRedeSimEnum modeloDocumento = ModeloDocumentoRedeSimEnum.fromCodigo((Integer)tipoModeloDocumento);
            if (Objects.isNull(modeloDocumento)) {
                throw new ModeloDocumentoNotFoundException(String.format("N\u00e3o foi poss\u00edvel localizar o modelo de documento tipo: %d", tipoModeloDocumento));
            }
            this.solicitacaoDocRedeSim = this.findByDataBase(protocolo, tipoModeloDocumento);
        } else {
            this.solicitacaoDocRedeSim = this.findByHasCode(protocolo);
        }
    }

    private SolicitacaoDocRedeSimEntity findByDataBase(String protocolo, Integer tipoModeloDocumento) {
        return this.repositorySolicitacaoDocRedeSim.findSolicitacaoDocumentoByProtocoloAndTipoDocumento(protocolo, Long.valueOf(tipoModeloDocumento.intValue())).stream().min(Comparator.comparing(SolicitacaoDocRedeSimEntity::getId)).orElse(null);
    }

    private SolicitacaoDocRedeSimEntity findByHasCode(String protocolo) {
        Gson gson = new Gson();
        return this.repositorySolicitacaoDocRedeSim.findSolicitacaoDocumentoByProtocoloAndTipoDocumento(protocolo, null).stream().filter(solicitacaoDoc -> {
            SolicitacaoDocumentosDTO dto = (SolicitacaoDocumentosDTO)gson.fromJson(JsonUtils.sanitize((String)solicitacaoDoc.getArquivoSolicitacao()), SolicitacaoDocumentosDTO.class);
            return dto.hashCode() == this.solicitacaoDocumentosDTO.hashCode();
        }).min(Comparator.comparing(SolicitacaoDocRedeSimEntity::getId)).orElse(null);
    }

    public void setSolicitacaoDTO(SolicitacaoDocumentosDTO solicitacaoDocumentosDTO) {
        this.solicitacaoDocumentosDTO = solicitacaoDocumentosDTO;
    }

    public SolicitacaoDocRedeSimEntity getSolicitacaoDoc() {
        return this.solicitacaoDocRedeSim;
    }
}

