/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandEnviarEmail;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AppWebConfEntity;
import br.com.elotech.tributacao.repository.RepositoryAppWebConf;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.util.email.EloMailUtils;
import br.com.elotech.util.string.EloStringUtils;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandEnviarEmail")
@Scope(value="prototype")
public class CommandEnviarEmailImpl
extends EloLogger
implements CommandEnviarEmail {
    private static final String DESENVOLVIMENTO = "D";
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    private EmailVo emailVo;
    @Resource
    private RepositoryAppWebConf repositoryAppWebConf;

    public void setEmailVo(EmailVo emailVo) {
        this.emailVo = emailVo;
    }

    public void execute() throws BaseException {
        AppWebConfEntity appWebConf = this.repositoryAppWebConf.loadFirst();
        if (!DESENVOLVIMENTO.equals(appWebConf.getDev())) {
            this.carregarValoresPadrao();
            ((EloMailUtils)SpringContext.getBean(EloMailUtils.class)).sendMail(this.emailVo.getRemetente(), this.emailVo.getDestinatario(), this.emailVo.getComCopia(), this.emailVo.getComCopiaOculta(), this.emailVo.getAssunto(), this.emailVo.getMensagem(), this.emailVo.getAnexos());
        }
    }

    private void carregarValoresPadrao() {
        if (EloStringUtils.isEmpty((String)this.emailVo.getRemetente())) {
            this.emailVo.setRemetente(this.repositoryParametroGeral.getParametro(ParametroGeralEnum.REMETENTEEMAIL.getModulo(), ParametroGeralEnum.REMETENTEEMAIL.name()));
        }
        if (EloStringUtils.isEmpty((String)this.emailVo.getDestinatario())) {
            this.emailVo.setDestinatario(this.repositoryParametroGeral.getParametro(ParametroGeralEnum.EMAILGERENTEMOB.getModulo(), ParametroGeralEnum.EMAILGERENTEMOB.name()));
        }
    }
}

