/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandEnviarEmailDebitosSocios;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvEnviarEmailDebitosSocios;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.util.date.EloDateUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandEnviarEmailDebitosSocios")
@Scope(value="prototype")
public class CommandEnviarEmailDebitosSociosImpl
implements CommandEnviarEmailDebitosSocios {
    private SolicitacaoAlvaraEntity solicitacao;
    @Resource
    private SrvEnviarEmailDebitosSocios srvEnviarEmailDebitosSocios;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;

    public void execute() throws BaseException {
        EntidadeTributacaoEntity entidade = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(entidade.getId().getEntidade(), ParametroAlvaraEnum.ENVIA_EMAIL_DEBITO_SOCIOS);
        if (parametro != null && SimNaoEnum.SIM.getShortText().equals(parametro.getValor())) {
            this.srvEnviarEmailDebitosSocios.enviarEmail(this.solicitacao);
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }
}

