/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandEnviarAnulacaoDocumentoRedeSim;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.service.SrvRespostaDocumentosRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandEnviarAnulacaoDocumentoRedeSim")
@Scope(value="prototype")
public class CommandEnviarAnulacaoDocumentoRedeSimImpl
implements CommandEnviarAnulacaoDocumentoRedeSim {
    @Resource
    private SrvRespostaDocumentosRedeSim srvRespostaDocumentosRedeSim;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;
    private SolicitacaoRedeSimEntity solicitacaoRedeSim;
    private ModeloDocumentoRedeSimEnum modeloDocumento;

    public void execute() throws BaseException {
        this.srvRespostaDocumentosRedeSim.enviarAnulacaoDocumento(this.solicitacaoRedeSim, this.modeloDocumento);
        this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(this.solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ANULADO, Optional.of("Documento: " + this.modeloDocumento.getDescricao()), null);
        this.srvSolicitacaoAlvaraRedeSim.adicionarHistoricoDeAndamento(this.solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.ANALISE, Optional.empty(), null);
    }

    public void setSolicitacaoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        this.solicitacaoRedeSim = solicitacaoRedeSim;
    }

    public void setModeloDocumento(ModeloDocumentoRedeSimEnum modeloDocumento) {
        this.modeloDocumento = modeloDocumento;
    }
}

