/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandConsultaEnderecoImobiliario;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.integration.dto.ws30.ConsultaEnderecoImobiliario;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaEnderecoImobiliario;
import br.com.elotech.spring.SpringContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandConsultaEnderecoImobiliario")
public class CommandConsultaEnderecoImobiliarioImpl
implements CommandConsultaEnderecoImobiliario {
    private String inscricaoImobiliaria;
    private ConsultaEnderecoImobiliario enderecoImobiliario;
    @Resource
    private RepositoryConsultaEnderecoImobiliario repositoryConsultaEnderecoImobiliario;

    public void execute() throws BaseException {
        List lista = this.repositoryConsultaEnderecoImobiliario.getEnderecos(this.inscricaoImobiliaria);
        if (lista.isEmpty()) {
            throw new CadastroImobiliarioNaoEncontradoException("Cadastro Imobili\u00e1rio n\u00e3o encontrado");
        }
        this.enderecoImobiliario = lista.stream().findFirst().orElse(null);
        if (Objects.nonNull(this.enderecoImobiliario.getTipoLogradouro())) {
            this.enderecoImobiliario.setTipoLogradouro(((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getTipoLogradouroRedeSim(this.enderecoImobiliario.getTipoLogradouro()));
        }
    }

    public void setInscricaoImobiliaria(String inscricaoImobiliaria) {
        this.inscricaoImobiliaria = inscricaoImobiliaria;
    }

    public ConsultaEnderecoImobiliario getEndereco() {
        return this.enderecoImobiliario;
    }
}

