/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.portalarrecadacao.command.CommandCarregarSolicitacoesParaGerarProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDocumento;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregarSolicitacoesParaGerarProcessoFiscalizacao")
public class CommandCarregarSolicitacoesSemProcessoFiscalizacaoGeradoImpl
implements CommandCarregarSolicitacoesParaGerarProcessoFiscalizacao {
    private List<SolicitacaoAlvaraEntity> solicitacoes;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private RepositorySolicitacaoAlvaraDocumento repositorySolicitacaoAlvaraDocumento;

    public void execute() {
        this.solicitacoes = this.repositorySolicitacaoAlvara.getSolicitacoesSemProcessoFiscalizacaoGerado();
        if (!EloListUtils.safeIsEmpty((List)this.solicitacoes).booleanValue()) {
            for (SolicitacaoAlvaraEntity solicitacao : this.solicitacoes) {
                solicitacao.setLaudos(this.repositoryLaudoAlvara.buscarLaudoPorSolicitacao(solicitacao.getSolicitacaoAlvara()));
                solicitacao.setDocumentos(this.repositorySolicitacaoAlvaraDocumento.carregaDocumentosEnviados(solicitacao));
            }
        }
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacoes() {
        return this.solicitacoes;
    }
}

