/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.command.CommandCarregarSolicitacaoPorId;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraAtividadeDTO;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraConselhoDTO;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraDTO;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraDocConselhoDTO;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.util.exceptions.FormatError;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandCarregarSolicitacaoPorId")
@Scope(value="prototype")
public class CommandCarregarSolicitacaoPorIdImpl
extends EloLogger
implements CommandCarregarSolicitacaoPorId {
    private Long idSolicitacao;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    private SolicitacaoAlvaraDTO solicitacaoAlvaraDTO;

    public void execute() throws BaseException {
        SolicitacaoAlvaraEntity solicitacaoAlvaraEntity = this.repositorySolicitacaoAlvara.load(this.idSolicitacao);
        this.solicitacaoAlvaraDTO = new SolicitacaoAlvaraDTO();
        this.solicitacaoAlvaraDTO.setId(solicitacaoAlvaraEntity.getSolicitacaoAlvara());
        this.solicitacaoAlvaraDTO.setNumeroSolicitacao(solicitacaoAlvaraEntity.getNumeroSolicitacao());
        this.solicitacaoAlvaraDTO.setExercicio(solicitacaoAlvaraEntity.getExercicio());
        this.solicitacaoAlvaraDTO.setDataSolicitacao(solicitacaoAlvaraEntity.getDataSolicitacao());
        this.solicitacaoAlvaraDTO.setDescricaoTipoInscricao(solicitacaoAlvaraEntity.getTipoDeInscricao().getDescricao());
        if (solicitacaoAlvaraEntity.isSolicitacaoCBO()) {
            this.solicitacaoAlvaraDTO.setDescricaoPessoa("Nome");
        } else {
            this.solicitacaoAlvaraDTO.setDescricaoPessoa("Raz\u00e3o Social da Empresa:");
        }
        this.solicitacaoAlvaraDTO.setNomeRazaoSocial(solicitacaoAlvaraEntity.getNomeRazaoSocial());
        this.solicitacaoAlvaraDTO.setFantasia(solicitacaoAlvaraEntity.getFantasia());
        if ("J".equals(solicitacaoAlvaraEntity.getCadastroMobiliario().getCadastroGeral().getPessoa().getTipoPessoa())) {
            this.solicitacaoAlvaraDTO.setDescricaoTipoPessoa("Jur\u00eddica");
        } else {
            this.solicitacaoAlvaraDTO.setDescricaoTipoPessoa("F\u00edsica");
        }
        this.solicitacaoAlvaraDTO.setCpfCnpj(EloStringUtils.formatCpfCnpjReport((String)solicitacaoAlvaraEntity.getCpfCnpj()));
        this.solicitacaoAlvaraDTO.setCodigoImobiliario(solicitacaoAlvaraEntity.getCadastroImobiliario().getCadastroGeral().getId().getCodigo());
        this.solicitacaoAlvaraDTO.setEndereco(solicitacaoAlvaraEntity.montarEnderecoCorretoDaSolicitacao());
        this.solicitacaoAlvaraDTO.setComplemento(solicitacaoAlvaraEntity.montarComplementoMobiliarioEImobiliario());
        this.solicitacaoAlvaraDTO.setBairro(solicitacaoAlvaraEntity.getCadastroImobiliario().getCadastroGeral().getBairro().getDescricao());
        try {
            this.solicitacaoAlvaraDTO.setTelefone(EloStringUtils.formatFone((String)solicitacaoAlvaraEntity.getTelefonePreenchido()));
        }
        catch (FormatError e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.solicitacaoAlvaraDTO.setEmail(solicitacaoAlvaraEntity.getEmail());
        EnderecoCadastroGeralEntity enderecoPrincipal = ((FacadeCadastroImobiliario)SpringContext.getBean(FacadeCadastroImobiliario.class)).getBuscaEnderecoImobiliarioPrincipal(solicitacaoAlvaraEntity.getCadastroImobiliario().getCadastroGeral().getId().getCodigo());
        if (Objects.nonNull(enderecoPrincipal)) {
            this.solicitacaoAlvaraDTO.setCidade(enderecoPrincipal.getCidade() + " - " + enderecoPrincipal.getPessoaUnidadeFederacao());
        }
        if (solicitacaoAlvaraEntity.isNaturezaMudancaEndereco()) {
            if (Objects.nonNull(solicitacaoAlvaraEntity.getCadastroImobiliario().getCadastroGeral().getCep())) {
                this.solicitacaoAlvaraDTO.setCep(solicitacaoAlvaraEntity.getCadastroImobiliario().getCadastroGeral().getCep().toString());
            }
        } else if (Objects.nonNull(solicitacaoAlvaraEntity.getCadastroMobiliario().getCadastroGeral().getCep())) {
            this.solicitacaoAlvaraDTO.setCep(solicitacaoAlvaraEntity.getCadastroMobiliario().getCadastroGeral().getCep().toString());
        }
        this.solicitacaoAlvaraDTO.setZona(solicitacaoAlvaraEntity.getCadastroImobiliario().getSetorDescr());
        this.solicitacaoAlvaraDTO.setQuadra(solicitacaoAlvaraEntity.getCadastroImobiliario().getQuadraDescr());
        this.solicitacaoAlvaraDTO.setLote(solicitacaoAlvaraEntity.getCadastroImobiliario().getLoteDescr());
        if (solicitacaoAlvaraEntity.isNaturezaMudancaEndereco() || solicitacaoAlvaraEntity.isNaturezaInicial()) {
            String zonaGeo = "";
            if (!Strings.isNullOrEmpty((String)solicitacaoAlvaraEntity.getZonaGeo())) {
                zonaGeo = solicitacaoAlvaraEntity.getZonaGeo();
            }
            String eixoGeo = "";
            if (!Strings.isNullOrEmpty((String)solicitacaoAlvaraEntity.getEixoGeo())) {
                eixoGeo = solicitacaoAlvaraEntity.getEixoGeo();
            }
            this.solicitacaoAlvaraDTO.setZoneamentoExito(zonaGeo + " / " + eixoGeo);
        }
        ArrayList atividadesDto = Lists.newArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvaraEntity.getSolicitacaoAlvaraAtividades()) {
            SolicitacaoAlvaraAtividadeDTO atividadeDto = new SolicitacaoAlvaraAtividadeDTO();
            atividadeDto.setCodigo(atividade.getCodigoAtividade());
            atividadeDto.setDescricao(atividade.getDescricaoAtividade());
            atividadeDto.setPrincipal(atividade.getPrincipal());
            if (atividade.getCnae() != null) {
                this.solicitacaoAlvaraDTO.setNomeAtividade("CNAE");
                atividadeDto.setRisco(atividade.getCnae().getRisco());
            } else if (atividade.getAtividadeMei() != null) {
                this.solicitacaoAlvaraDTO.setNomeAtividade("Atividade MEI");
                atividadeDto.setRisco(atividade.getAtividadeMei().getRisco());
            } else if (atividade.getSequenciaCbo() != null) {
                this.solicitacaoAlvaraDTO.setNomeAtividade("CBO");
                atividadeDto.setRisco(atividade.getSequenciaCbo().getRisco());
            }
            ArrayList conselhosDto = Lists.newArrayList();
            for (SolicitacaoAlvaraNumConselhoEntity numeroConselho : atividade.getNumerosConselho()) {
                SolicitacaoAlvaraConselhoDTO conselhoDto = new SolicitacaoAlvaraConselhoDTO();
                conselhoDto.setId(numeroConselho.getId());
                conselhoDto.setNumeroRegistro(numeroConselho.getNumeroRegistro());
                conselhoDto.setNomeResponsavel(numeroConselho.getNomeResponsavel());
                ArrayList documentos = Lists.newArrayList();
                for (SolicitacaoAlvaraDocumentoConselhoEntity documento : numeroConselho.getDocumentos()) {
                    SolicitacaoAlvaraDocConselhoDTO documentoDto = new SolicitacaoAlvaraDocConselhoDTO();
                    documentoDto.setId(documento.getId());
                    documentoDto.setTipoDocumento(documento.getSolicitacaoAlvaraDocumento().getTipoDocumento().getDescricao());
                    documentos.add(documentoDto);
                }
                conselhoDto.setDocumentos((List)documentos);
                conselhosDto.add(conselhoDto);
            }
            atividadeDto.setConselhos((List)conselhosDto);
            atividadesDto.add(atividadeDto);
        }
        this.solicitacaoAlvaraDTO.setAtividades((List)atividadesDto);
        if (Strings.isNullOrEmpty((String)solicitacaoAlvaraEntity.getDescricaoAtividades())) {
            this.solicitacaoAlvaraDTO.setDescricaoAtividades(solicitacaoAlvaraEntity.getCadastroMobiliario().getAtividadePrincipal());
        } else {
            this.solicitacaoAlvaraDTO.setDescricaoAtividades(solicitacaoAlvaraEntity.getDescricaoAtividades());
        }
        if (Objects.isNull(solicitacaoAlvaraEntity.getAreaConstruida())) {
            this.solicitacaoAlvaraDTO.setAreaConstruida(BigDecimal.ZERO);
        } else {
            this.solicitacaoAlvaraDTO.setAreaConstruida(solicitacaoAlvaraEntity.getAreaConstruida());
        }
        if (Objects.isNull(solicitacaoAlvaraEntity.getAreaPatio())) {
            this.solicitacaoAlvaraDTO.setAreaPatio(BigDecimal.ZERO);
        } else {
            this.solicitacaoAlvaraDTO.setAreaPatio(solicitacaoAlvaraEntity.getAreaPatio());
        }
        if (Objects.isNull(solicitacaoAlvaraEntity.getAreaUtilizada())) {
            this.solicitacaoAlvaraDTO.setArea(BigDecimal.ZERO);
        } else {
            this.solicitacaoAlvaraDTO.setArea(solicitacaoAlvaraEntity.getAreaUtilizada());
        }
    }

    public SolicitacaoAlvaraDTO getSolicitacaoDto() {
        return this.solicitacaoAlvaraDTO;
    }

    public void setIdSolicitacao(Long idSolicitacao) {
        this.idSolicitacao = idSolicitacao;
    }
}

