/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaUltimoContratoSocial;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaUltimoContratoSocial")
public class CommandCarregaUltimoContratoSocialImpl
implements CommandCarregaUltimoContratoSocial {
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;
    private CadastroMobiliarioEntity cadastroMobiliario;
    private ContratoSocialEntity contrato;

    public void execute() throws BaseException {
        this.contrato = this.repositoryContratoSocial.getUltimoContratoSocial(this.cadastroMobiliario);
        if (this.contrato != null) {
            if (this.contrato.getPessoas() == null) {
                this.contrato.setPessoas(new ArrayList());
            } else {
                Hibernate.initialize((Object)this.contrato.getPessoas());
                for (ContratoSocialPessoaEntity contratoPessoa : this.contrato.getPessoas()) {
                    Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getEnderecos());
                    Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getContatos());
                }
            }
        }
    }

    public void setCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliairo) {
        this.cadastroMobiliario = cadastroMobiliairo;
    }

    public ContratoSocialEntity getContratoSocial() {
        return this.contrato;
    }
}

