/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.domain.Page;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaSolicitacoesRedeSimPaginadas;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandCarregaSolicitacoesRedeSimPaginadas")
@Scope(value="prototype")
public class CommandCarregaSolicitacoesRedeSimPaginadasImpl
implements CommandCarregaSolicitacoesRedeSimPaginadas {
    private Page<SolicitacaoRedeSimEntity> solicitacoesRedeSim;
    private Integer pagina;
    private Integer tamanhoPagina;
    private FiltroConsultaRedeSim filtro;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public void execute() throws BaseException {
        this.solicitacoesRedeSim = this.repositoryConsultaRedeSim.getSolicitacoesRedeSimPaginadas(this.filtro, this.pagina, this.tamanhoPagina);
        if (!EloListUtils.safeIsEmpty((List)this.solicitacoesRedeSim.getData()).booleanValue()) {
            for (SolicitacaoRedeSimEntity consultaRedeSim : this.solicitacoesRedeSim.getData()) {
                if (this.filtro.getTipo().equals(TipoSolicitacaoRedeSimEnum.CONSULTA.getSigla())) {
                    consultaRedeSim.setHistoricosExigencias(null);
                } else {
                    Hibernate.initialize((Object)consultaRedeSim.getHistoricosExigencias());
                    if (!EloListUtils.safeIsEmpty((List)consultaRedeSim.getHistoricosExigencias()).booleanValue()) {
                        for (HistoricoExigenciaRedeSimEntity hist : consultaRedeSim.getHistoricosExigencias()) {
                            Hibernate.initialize((Object)hist.getUrlsDocHistoricoExigencia());
                        }
                    }
                }
                if (!EloListUtils.safeIsEmpty((List)consultaRedeSim.getEventos()).booleanValue()) {
                    Hibernate.initialize((Object)consultaRedeSim.getEventos());
                }
                if (Objects.nonNull(consultaRedeSim.getSolicitacaoAlvara())) {
                    if (!EloListUtils.safeIsEmpty((List)consultaRedeSim.getSolicitacaoAlvara().getDebitos()).booleanValue()) {
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getDebitos());
                    }
                    if (Objects.nonNull(consultaRedeSim.getSolicitacaoAlvara().getContratoSocial())) {
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getContratoSocial().getPessoas());
                        for (SolicitacaoContratoSocialPessoaEntity pessoa : consultaRedeSim.getSolicitacaoAlvara().getContratoSocial().getPessoas()) {
                            Hibernate.initialize((Object)pessoa.getPessoa().getEnderecos());
                            Hibernate.initialize((Object)pessoa.getPessoa().getContatos());
                            Hibernate.initialize((Object)pessoa.getPessoa().getContatos());
                        }
                    }
                    Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getNaturezas());
                    Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getDocumentos());
                    Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getLaudos());
                    Optional.ofNullable(consultaRedeSim.getSolicitacaoAlvara().getCadastroImobiliario()).ifPresent(cadastroImobiliario -> {
                        Hibernate.initialize((Object)cadastroImobiliario.getSegmentos());
                        Hibernate.initialize((Object)cadastroImobiliario.getTestadas());
                        Hibernate.initialize((Object)cadastroImobiliario.getTestadasGenericas());
                    });
                    if (!EloListUtils.safeIsEmpty((List)consultaRedeSim.getSolicitacaoAlvara().getSefazDocumentos()).booleanValue()) {
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getSefazDocumentos());
                        consultaRedeSim.getSolicitacaoAlvara().getSefazDocumentos().forEach(sefazDocumento -> Hibernate.initialize((Object)sefazDocumento.getTipoDocumento()));
                    }
                    if (Objects.nonNull(consultaRedeSim.getSolicitacaoAlvara().getContratoSocial())) {
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getContratoSocial().getPessoas());
                        for (SolicitacaoContratoSocialPessoaEntity p2 : consultaRedeSim.getSolicitacaoAlvara().getContratoSocial().getPessoas()) {
                            Hibernate.initialize((Object)p2.getPessoa().getEnderecos());
                            Hibernate.initialize((Object)p2.getPessoa().getContatos());
                        }
                    }
                    Optional.ofNullable(consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario()).ifPresent(cadastroMobiliario -> {
                        Optional.ofNullable(cadastroMobiliario.getCadastroGeral()).ifPresent(cadastroGeral -> {
                            Hibernate.initialize((Object)cadastroGeral.getIsencoes());
                            if (cadastroGeral.getPessoa() != null) {
                                Hibernate.initialize((Object)cadastroGeral.getPessoa().getContatos());
                                Hibernate.initialize((Object)cadastroGeral.getPessoa().getEnderecos());
                            }
                        });
                        Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioServicos());
                        Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioCnaes());
                        Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioSituacao());
                        Hibernate.initialize((Object)cadastroMobiliario.getContratosSociais());
                        cadastroMobiliario.getMobiliarioSituacao().forEach(p -> Hibernate.initialize((Object)p.getSituacaoMobiliario().getSituacoesMobiliarioAlvara()));
                        Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioAtividadeMeis());
                        Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioCbos());
                        Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioHorarioEspecial());
                    });
                    if (Objects.nonNull(consultaRedeSim.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades())) {
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades());
                        consultaRedeSim.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().stream().forEach(p -> Hibernate.initialize((Object)p.getNumerosConselho()));
                    }
                }
                if (consultaRedeSim.isSolicitacaoBaixa()) {
                    Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoBaixaRedeSim());
                }
                Hibernate.initialize((Object)consultaRedeSim.getIndeferimentos());
            }
        }
    }

    public void setFiltro(FiltroConsultaRedeSim filtro) {
        this.filtro = filtro;
    }

    public void setPagina(int pagina) {
        this.pagina = pagina;
    }

    public void setTamanhoPagina(int tamanhoPagina) {
        this.tamanhoPagina = tamanhoPagina;
    }

    public Page<SolicitacaoRedeSimEntity> getSolicitacoes() {
        return this.solicitacoesRedeSim;
    }
}

