/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao")
public class CommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacaoImpl
implements CommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao {
    Date dataInicial;
    Date dataFinal;
    String cpfCnpj;
    TipoLaudoEntity tipoLaudo;
    String numSolicitacao;
    StatusLaudoAlvara situacaoLaudo;
    List<SolicitacaoAlvaraEntity> listaSolicitacao;
    @Resource
    RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        this.listaSolicitacao = this.repositorySolicitacaoAlvara.buscaSolicitacoesParecerDosLaudos(this.numSolicitacao, this.cpfCnpj, this.dataInicial, this.dataFinal, this.tipoLaudo, this.situacaoLaudo);
        for (SolicitacaoAlvaraEntity solicitacao : this.listaSolicitacao) {
            if (solicitacao.getSolicitacaoAlvaraAtividades().size() <= 0) {
                solicitacao.setSolicitacaoAlvaraAtividades(new ArrayList());
            }
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (atividade.getNumerosConselho().size() > 0) continue;
                atividade.setNumerosConselho(new ArrayList());
            }
            if (solicitacao.getCadastroMobiliario().getContratosSociais().size() <= 0) {
                solicitacao.getCadastroMobiliario().setContratosSociais(new ArrayList());
            }
            for (ContratoSocialEntity contrato : solicitacao.getCadastroMobiliario().getContratosSociais()) {
                if (contrato.getPessoas().size() > 0) continue;
                contrato.setPessoas(new ArrayList());
            }
            if (solicitacao.getNaturezas().size() > 0) continue;
            solicitacao.setNaturezas(new ArrayList());
        }
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public void setNumeroSolicitacao(String numero) {
        this.numSolicitacao = numero;
    }

    public void setTipoLaudo(TipoLaudoEntity tipoLaudo) {
        this.tipoLaudo = tipoLaudo;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacao() {
        return this.listaSolicitacao;
    }

    public void setSituacaoLaudo(StatusLaudoAlvara situacaoLaudo) {
        this.situacaoLaudo = situacaoLaudo;
    }
}

