/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaLaudoAlvaraRelatorio;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioLaudoVo;
import br.com.elotech.portalarrecadacao.repository.RepositoryRelatorioLaudo;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandCarregaListaLaudoAlvaraRelatorio")
public class CommandCarregaListaLaudoRelatorioImpl
implements CommandCarregaListaLaudoAlvaraRelatorio {
    @Resource
    private RepositoryRelatorioLaudo repositoryRelatorioLaudo;
    private FiltroRelatorioLaudoVo filtro;
    private List<LaudoAlvaraEntity> listaLaudos;

    public void execute() throws BaseException {
        this.listaLaudos = this.repositoryRelatorioLaudo.carregaListaLaudos(this.filtro);
        for (LaudoAlvaraEntity laudo : this.listaLaudos) {
            Hibernate.initialize((Object)laudo.getObservacoesTipoLaudo());
        }
    }

    public List<LaudoAlvaraEntity> getListaLaudos() {
        return this.listaLaudos;
    }

    public void setFiltroRelatorioLaudoVo(FiltroRelatorioLaudoVo filtro) {
        this.filtro = filtro;
    }
}

