/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandCarregaEventoRedeSim;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.repository.RepositoryEventoRedeSim;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandCarregaEventoRedeSim")
@Scope(value="prototype")
public class CommandCarregaEventoRedeSimImpl
implements CommandCarregaEventoRedeSim {
    private List<Evento> eventos;
    private List<EventoRedeSimEntity> eventosRedeSim;
    @Resource
    private RepositoryEventoRedeSim repositoryEventoRedeSim;

    public void execute() throws BaseException {
        this.eventosRedeSim = Lists.newArrayList();
        for (Evento evento : this.eventos) {
            EventoRedeSimEntity eventoRedeSim = this.repositoryEventoRedeSim.load(new Long(evento.getCo_evento()));
            if (eventoRedeSim == null) continue;
            this.eventosRedeSim.add(eventoRedeSim);
        }
    }

    public void setEventos(List<Evento> eventos) {
        this.eventos = eventos;
    }

    public List<EventoRedeSimEntity> getEventosRedeSim() {
        return this.eventosRedeSim;
    }
}

