/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandBuscarTiposDocumentoResponsavelTecnico;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeAise;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocumento;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandBuscarTiposDocumentoResponsavelTecnico")
public class CommandBuscarTiposDocumentoResponsavelTecnicoImpl
implements CommandBuscarTiposDocumentoResponsavelTecnico {
    private List<TipoDocumentoEntity> tiposDocumento;
    @Resource
    private RepositoryEntidadeAise repositoryEntidadeAise;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryTipoDocumento repositoryTipoDocumento;

    public void execute() throws BaseException {
        this.tiposDocumento = new ArrayList();
        EntidadeAiseEntity entidade = (EntidadeAiseEntity)this.repositoryEntidadeAise.findEntidadePrincipal();
        ParametroAlvaraEntity paramTiposDocumento = this.repositoryParametroAlvara.getParametroAlvara(entidade, ParametroAlvaraEnum.TIPOS_DOCUMENTO_RESP_TECNICO);
        if (Objects.nonNull(paramTiposDocumento) && Objects.nonNull(paramTiposDocumento.getValor())) {
            String[] tiposDocumentoValue;
            for (String tipoStr : tiposDocumentoValue = paramTiposDocumento.getValor().split(",")) {
                TipoDocumentoEntity tipoDocumentoEntity = this.repositoryTipoDocumento.load(Long.valueOf(tipoStr));
                this.tiposDocumento.add(tipoDocumentoEntity);
            }
        }
    }

    public List<TipoDocumentoEntity> getTiposDocumento() {
        return this.tiposDocumento;
    }
}

