/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandBuscarSolicitacoesEncaminhadas;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoEncaminhadaEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroSolicitacaoEncaminhada;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoEncaminhada;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandBuscarSolicitacoesEncaminhadas")
@Scope(value="prototype")
public class CommandBuscarSolicitacoesEncaminhadasImpl
implements CommandBuscarSolicitacoesEncaminhadas {
    private List<SolicitacaoEncaminhadaEntity> solicitacoesEncaminhadas;
    private FiltroSolicitacaoEncaminhada filtro;
    @Resource
    RepositorySolicitacaoEncaminhada repositorySolicitacaoEncaminhada;

    public void execute() throws BaseException {
        this.solicitacoesEncaminhadas = this.repositorySolicitacaoEncaminhada.buscarSolicitacoes(this.filtro);
        for (SolicitacaoEncaminhadaEntity solicitacao : this.solicitacoesEncaminhadas) {
            if (EloListUtils.safeIsEmpty((List)solicitacao.getEventos()).booleanValue()) continue;
            Hibernate.initialize((Object)solicitacao.getEventos());
        }
    }

    public List<SolicitacaoEncaminhadaEntity> getSolicitacoesEncaminhadas() {
        return this.solicitacoesEncaminhadas;
    }

    public void setFiltro(FiltroSolicitacaoEncaminhada filtro) {
        this.filtro = filtro;
    }
}

