/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandBuscaSolicitacoesAlvaraPorProtocoloRedeSim")
public class CommandBuscaSolicitacoesAlvaraPorProtocoloRedeSimImpl
implements CommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim {
    private List<SolicitacaoAlvaraEntity> solicitacoes;
    private String protocolo;
    private Optional<String> tipo;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public void execute() throws BaseException {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getSolicitacaoByProtocolo(this.protocolo, this.tipo);
        this.solicitacoes = solicitacaoRedeSim.getSolicitacoesAlvara();
        if (!EloListUtils.safeIsEmpty((List)this.solicitacoes).booleanValue()) {
            for (SolicitacaoAlvaraEntity solicitacao : this.solicitacoes) {
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).hibernateInitializeSolicitacaoAlvara(solicitacao);
            }
        }
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public List<SolicitacaoAlvaraEntity> getSolicitacoesAlvara() {
        return this.solicitacoes;
    }

    public void setTipoSolicitacao(Optional<String> tipo) {
        this.tipo = tipo;
    }
}

