/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandBuscaLaudosPorSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandBuscaLaudoPorSolicitacaoAlvara")
public class CommandBuscaLaudosPorSolicitacaoAlvaraImpl
implements CommandBuscaLaudosPorSolicitacaoAlvara {
    private Long id;
    private List<LaudoAlvaraEntity> listaLaudos;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudo;

    public void execute() throws BaseException {
        this.listaLaudos = this.repositoryLaudo.buscarLaudoPorSolicitacao(this.id);
        for (LaudoAlvaraEntity laudo : this.listaLaudos) {
            if (laudo.getIdSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().size() <= 0) {
                laudo.getIdSolicitacaoAlvara().setSolicitacaoAlvaraAtividades(new ArrayList());
            }
            Hibernate.initialize((Object)laudo.getIdSolicitacaoAlvara().getSefazDocumentos());
            Hibernate.initialize((Object)laudo.getObservacoesTipoLaudo());
            Hibernate.initialize((Object)laudo.getDocumentos());
            Hibernate.initialize((Object)laudo.getHistoricosRenovacao());
            if (laudo.getIdSolicitacaoAlvara().getNaturezas().size() <= 0) {
                laudo.getIdSolicitacaoAlvara().getNaturezas();
            }
            for (SolicitacaoAlvaraAtividadeEntity atividade : laudo.getIdSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()) {
                if (atividade.getNumerosConselho().size() > 0) continue;
                atividade.setNumerosConselho(new ArrayList());
            }
        }
    }

    public void setIdSolicitacao(Long idSolicitacao) {
        this.id = idSolicitacao;
    }

    public List<LaudoAlvaraEntity> getLaudos() {
        return this.listaLaudos;
    }
}

