/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolic;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import java.util.Objects;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolicitacao")
public class CommandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolicImpl
implements CommandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolic {
    private Long solicitacao;
    private Long exercicio;
    private String cpfCnpj;
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public void execute() throws BaseException {
        this.solicitacaoAlvara = this.repositorySolicitacaoAlvara.buscaConsultaPreviaPorCpfCnpjExercicioNumSolic(this.solicitacao, this.exercicio, this.cpfCnpj);
        if (this.solicitacaoAlvara != null) {
            Hibernate.initialize((Object)this.solicitacaoAlvara.getLaudos());
            Hibernate.initialize((Object)this.solicitacaoAlvara.getNaturezas());
            Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroImobiliario().getSegmentos());
            Hibernate.initialize((Object)this.solicitacaoAlvara.getDebitos());
            Hibernate.initialize((Object)this.solicitacaoAlvara.getDocumentos());
            if (this.solicitacaoAlvara.getCadastroMobiliario() != null) {
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioCnaes());
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioAtividadeMeis());
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioCbos());
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao());
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getContratosSociais());
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioAtividades());
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicos());
                for (ContratoSocialEntity contratoSocial : this.solicitacaoAlvara.getCadastroMobiliario().getContratosSociais()) {
                    Hibernate.initialize((Object)contratoSocial.getPessoas());
                    for (ContratoSocialPessoaEntity contratoPessoa : contratoSocial.getPessoas()) {
                        if (contratoPessoa.getId() == null || contratoPessoa.getId().getPessoa() == null) continue;
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getContatos());
                    }
                }
                Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao());
                this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(s -> Hibernate.initialize((Object)s.getSituacaoMobiliario().getSituacoesMobiliarioAlvara()));
                SituacaoMobiliarioEntity mobiliarioSituacaoAtual = this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioSituacaoAtual();
                Hibernate.initialize((Object)mobiliarioSituacaoAtual.getSituacoesMobiliarioAlvara());
                if (this.solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral() != null) {
                    Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getIsencoes());
                    if (this.solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa() != null) {
                        Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getContatos());
                        Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getEnderecos());
                    }
                }
                if (Objects.nonNull(this.solicitacaoAlvara.getCadastroMobiliario().getCadastroImobiliario())) {
                    Hibernate.initialize((Object)this.solicitacaoAlvara.getCadastroMobiliario().getCadastroImobiliario());
                }
            }
            Hibernate.initialize((Object)this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades());
            for (SolicitacaoAlvaraAtividadeEntity solicitacao : this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                if (solicitacao.getCnae() != null) {
                    Hibernate.initialize((Object)solicitacao.getCnae().getCarteirasProfissionais());
                }
                if (solicitacao.getAtividadeMei() != null) {
                    Hibernate.initialize((Object)solicitacao.getAtividadeMei().getCarteirasProfissionais());
                }
                if (solicitacao.getSequenciaCbo() != null) {
                    Hibernate.initialize((Object)solicitacao.getSequenciaCbo().getCarteirasProfissionais());
                }
                Hibernate.initialize((Object)solicitacao.getNumerosConselho());
            }
            if (this.solicitacaoAlvara.getContratoSocial() != null) {
                Hibernate.initialize((Object)this.solicitacaoAlvara.getContratoSocial().getPessoas());
            }
        }
    }

    public void setSolicitacao(Long solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoAlvara;
    }
}

