/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandAtualizarGrauDeRiscoCnaes;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.aise.RepositoryCnae;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandAtualizarGrauDeRiscoCnaes")
public class CommandAtualizarGrauDeRiscoCnaesImpl
implements CommandAtualizarGrauDeRiscoCnaes {
    @Resource
    private RepositoryCnae repositoryCnae;
    private List<Atividade> cnaes;

    public void execute() throws BaseException {
        List cnaesExistentes = this.repositoryCnae.carregarCnaesPorCodigos(this.cnaes);
        if (!EloListUtils.safeIsEmpty((List)cnaesExistentes).booleanValue()) {
            for (CnaeEntity cnaeExistente : cnaesExistentes) {
                for (Atividade cnae : this.cnaes) {
                    if (!cnaeExistente.getCodigo().equalsIgnoreCase(cnae.getCodigo()) || cnaeExistente.getGrauRisco() != null && cnaeExistente.getGrauRisco().equalsIgnoreCase(cnae.getGrauRisco())) continue;
                    cnaeExistente.setGrauRisco(cnae.getGrauRisco());
                    this.repositoryCnae.saveOrUpdate(cnaeExistente);
                }
            }
        }
    }

    public void setCnaes(List<Atividade> cnaes) {
        this.cnaes = cnaes;
    }
}

