/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandAtualizaSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.domain.SefazDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySefazDocumento;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.util.list.EloListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandAtualizaSolicitacaoAlvara")
public class CommandAtualizaSolicitacaoAlvaraImpl
implements CommandAtualizaSolicitacaoAlvara {
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private RepositorySefazDocumento repositorySefazDocumento;
    private SolicitacaoAlvaraEntity solicitacao;
    private SolicitacaoAlvaraEntity solicitacaoRetorno;

    public void execute() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.solicitacao.getSefazDocumentos()).booleanValue()) {
            for (SefazDocumentoEntity documento : this.solicitacao.getSefazDocumentos()) {
                if (!Objects.isNull(documento.getId())) continue;
                documento.setId(this.repositorySefazDocumento.getSequence());
            }
        }
        if (!EloListUtils.safeIsEmpty((List)this.solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            this.solicitacao.getSolicitacaoAlvaraAtividades().stream().filter(p -> Objects.isNull(p.getNumerosConselho())).forEach(p -> p.setNumerosConselho(new ArrayList()));
        }
        this.solicitacaoRetorno = this.srvSolicitacaoAlvara.atualizarSolicitacaoAlvara(this.solicitacao);
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacao = solicitacaoAlvara;
    }

    public SolicitacaoAlvaraEntity getSolicitacaoAlvara() {
        return this.solicitacaoRetorno;
    }
}

