/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandAlterarSituacaoMobiliario;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@EloCommand(value="commandAlterarSituacaoMobiliario")
public class CommandAlterarSituacaoMobiliarioImpl
implements CommandAlterarSituacaoMobiliario {
    private SolicitacaoAlvaraEntity solicitacao;
    private SituacaoMobiliarioAlvaraEnum situacao;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;

    public void execute() throws BaseException {
        this.srvDebitosPortal.alteraMobiliarioSituacao(this.solicitacao, this.situacao);
        if (Objects.nonNull(this.solicitacao.getCadastroMobiliario()) && !EloListUtils.safeIsEmpty((List)this.solicitacao.getCadastroMobiliario().getMobiliarioSituacao()).booleanValue()) {
            Hibernate.initialize((Object)this.solicitacao.getCadastroMobiliario().getMobiliarioSituacao());
            this.solicitacao.getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(p -> Hibernate.initialize((Object)p.getSituacaoMobiliario().getSituacoesMobiliarioAlvara()));
        }
    }

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum situacao) {
        this.situacao = situacao;
    }
}

