/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.command.impl;

import br.com.elotech.annotations.spring.EloCommand;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.command.CommandAddAndamentoLaudo;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.SrvLaudoAlvara;
import java.net.URISyntaxException;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloCommand(value="commandAddAndamentoLaudo")
@Scope(value="prototype")
public class CommandAddAndamentoLaudoImpl
implements CommandAddAndamentoLaudo {
    private LaudoAlvaraEntity laudo;
    private AndamentoLaudoAlvaraEntity andamentoLaudo;
    private SolicitacaoAlvaraEntity solicitacao;
    @Resource
    private SrvLaudoAlvara srvLaudoAlvara;

    public void execute() throws BaseException {
        try {
            this.srvLaudoAlvara.salvarAndamento(this.laudo, this.andamentoLaudo, this.solicitacao);
        }
        catch (URISyntaxException e) {
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void setLaudo(LaudoAlvaraEntity laudo) {
        this.laudo = laudo;
    }

    public void setAndamentoLaudo(AndamentoLaudoAlvaraEntity andamentoLaudo) {
        this.andamentoLaudo = andamentoLaudo;
    }

    public void setSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        this.solicitacao = solicitacao;
    }
}

