/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento.job;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobIniciaProcessoIntegracaoMeiRedeSim
extends EloLogger
implements Job {
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            List solicitacoesEmAnalise = this.getSolicitacoesMeiInicialEmAnalise();
            for (SolicitacaoRedeSimEntity solicitacaoRedeSim : solicitacoesEmAnalise) {
                try {
                    SolicitacaoAlvaraEntity solicitacaoAlvara = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).iniciarProcessoAutomatizado(solicitacaoRedeSim);
                    this.adicionarHistoricoDeAndamentoAposGerarCadastro(solicitacaoRedeSim, solicitacaoAlvara);
                    this.gerarInscricaoMunicipal(solicitacaoRedeSim);
                    solicitacaoRedeSim = this.recarregarSolicitacaoRedeSim(solicitacaoRedeSim);
                    solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_GERADA, Optional.of("Inscri\u00e7\u00e3o Municipal Emitida"));
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).enviarDocumentoInscricaoMunicipal(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EMITIDO);
                    solicitacaoRedeSim.setAlvaraEnviado(TipoAlvaraEnum.MEI);
                    ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).salvarSolicitacaoRedeSim(solicitacaoRedeSim);
                    this.logger.info((Object)String.format("finalizando loop do agendador %s", solicitacaoAlvara.getProtocoloRedeSim()));
                }
                catch (Exception e) {
                    this.logger.error((Object)String.format("protocolo com erro...:%s...%s", solicitacaoRedeSim.getProtocolo(), e.getMessage()));
                    this.adicionarHistoricoSolicitacaoInconsistente(solicitacaoRedeSim, e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Erro na execu\u00e7\u00e3o do agendador: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void adicionarHistoricoSolicitacaoInconsistente(SolicitacaoRedeSimEntity solicitacaoRedeSim, Exception e) {
        try {
            ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.ofNullable(e.getMessage()));
        }
        catch (Exception ex) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void gerarInscricaoMunicipal(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacaoRedeSim.getSolicitacaoAlvara();
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).gerarInscricaoMunicipal(solicitacaoAlvara);
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).imprimirDocumentoRedeSim(solicitacaoAlvara, DocumentoTipoEnum.INSCRICAO_MUNICIPAL);
    }

    private void adicionarHistoricoDeAndamentoAposGerarCadastro(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.CADASTRO_GERADO_MEI, Optional.of(String.format("O Cadastro foi %s com sucesso", solicitacaoAlvara.isNaturezaInicial() ? "Gerado" : "Atualizado")));
    }

    private List<SolicitacaoRedeSimEntity> getSolicitacoesMeiInicialEmAnalise() throws BaseException {
        ArrayList situacao = Lists.newArrayList();
        FiltroConsultaRedeSim filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        filtro.setTipo("S");
        situacao.add(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
        filtro.setSituacao((List)situacao);
        TipoInscricaoAlvaraEntity tipoInscricaoMEI = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getTipoInscricaoBySigla("M");
        filtro.setTipoInscricao(tipoInscricaoMEI);
        filtro.setEvento(Long.valueOf(101L));
        List solicitacoes = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).carregarListaConsultaRedesim(filtro);
        return EloListUtils.safeIsEmpty((List)solicitacoes) == false ? solicitacoes.stream().filter(solicitacao -> solicitacao.temSolicitacaoAlvara()).collect(Collectors.toList()) : solicitacoes;
    }

    private SolicitacaoRedeSimEntity recarregarSolicitacaoRedeSim(SolicitacaoRedeSimEntity solicitacao) throws BaseException {
        SolicitacaoRedeSimEntity sol = ((FacadeRedeSim)SpringContext.getBean(FacadeRedeSim.class)).getConsultaRedeSim(solicitacao.getProtocolo(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        this.logger.info((Object)String.format("Recarregar solicitacao alvara id %d e prp %s ", sol.getSolicitacaoAlvara().getSolicitacaoAlvara(), sol.getProtocolo()));
        return sol;
    }
}

