/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento.job;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobGeracaoAlvaraIntegracaoRedeSim
extends EloLogger
implements Job {
    private final FacadeRedeSim facadeRedeSim = FacadeRedeSim.facade();

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            this.logger.info((Object)"# JOB - Iniciando");
            this.logger.info((Object)"# JOB * Atualiza\u00e7\u00e3o cadastral");
            this.logger.info((Object)"# JOB * Gera\u00e7\u00e3o de laudos na solicita\u00e7\u00e3o de documentos");
            this.logger.info((Object)"# JOB * Adicionando hist\u00f3rico de d\u00e9bito pago");
            this.facadeRedeSim.atualizarSituacaoParaDebitoPago();
            List solicitacaoDebitoQuitado = this.getSolicitacaoDebitoQuitado();
            this.logger.info((Object)String.format("# JOB - Itens para processar: %d", solicitacaoDebitoQuitado.size()));
            for (SolicitacaoRedeSimEntity solicitacaoRedeSimEntity : solicitacaoDebitoQuitado) {
                try {
                    this.logger.info((Object)String.format("# JOB - Processando protocolo: %s", solicitacaoRedeSimEntity.getProtocolo()));
                    this.facadeRedeSim.generateAndSendAlvaraRedeSim(solicitacaoRedeSimEntity);
                    this.logger.info((Object)String.format("# JOB - Protocolo %s processado com sucesso", solicitacaoRedeSimEntity.getProtocolo()));
                }
                catch (Exception e) {
                    this.logger.error((Object)"# JOB - Erro n\u00e3o esperado ao gerar o alvar\u00e1 autom\u00e1tico via agendador", (Throwable)e);
                    this.addHistoricoAndamentoSolicitacao(solicitacaoRedeSimEntity, Optional.of(e.getMessage()));
                }
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)"# JOB - Erro ao obter as solicita\u00e7\u00f5es com d\u00e9bito quitado", (Throwable)e);
        }
    }

    private void addHistoricoAndamentoSolicitacao(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity, Optional<String> observacao) throws BaseException {
        this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, observacao);
    }

    private List<SolicitacaoRedeSimEntity> getSolicitacaoDebitoQuitado() throws BaseException {
        FiltroConsultaRedeSim filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().situacao(Collections.singletonList(SituacaoConsultaPreviaRedeSimEnum.DEBITO_PAGO.getSigla())).tipo(TipoSolicitacaoRedeSimEnum.SOLICITACAO.getSigla()).grauRisco(GrauDeRiscoEnum.RISCO_ALTO).alvaraEnviado(Boolean.valueOf(false)).redeSim(Boolean.valueOf(true)).build();
        List solicitacaoRedeSimEntities = this.facadeRedeSim.carregarListaConsultaRedesim(filtro);
        return solicitacaoRedeSimEntities.stream().filter(a -> !a.getSolicitacaoAlvara().isSolicitacaoMEI()).collect(Collectors.toList());
    }
}

