/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.agendamento.job.JobIntegracaoWebIss;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import java.util.Objects;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgendaProcessoIntegracaoWebIss
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(AgendaProcessoIntegracaoWebIss.class);
    public static Scheduler scheduler;

    protected void init() throws BaseException, SchedulerException {
        try {
            ParametroAlvaraEntity parametro = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.URL_WEBISS);
            Boolean existUrlWebIss = Objects.nonNull(parametro) && !StringUtils.isEmpty((String)parametro.getValor());
            if (Boolean.TRUE.equals(existUrlWebIss)) {
                String tempo = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TEMPO_SERVICO_WEBISS);
                this.iniciaProcessoIntegracao(tempo);
            }
        }
        catch (Exception e) {
            log.error("Erro ao tentar integrar com o webiss", (Throwable)e);
            throw e;
        }
    }

    private void iniciaProcessoIntegracao(String tempo) throws SchedulerException {
        StdSchedulerFactory schedFactory = new StdSchedulerFactory();
        scheduler = schedFactory.getScheduler();
        log.info("*** Criando Tarefa: JobIntegracaoWebIss ***");
        JobDetail JobIntegracao = JobBuilder.newJob(JobIntegracaoWebIss.class).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(Integer.parseInt(tempo)).repeatForever()).build();
        scheduler.scheduleJob(JobIntegracao, (Trigger)trigger);
        scheduler.start();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.init();
        }
        catch (Exception e) {
            log.error("Erro ao inicializar o contexto.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (Objects.nonNull(scheduler)) {
                scheduler.shutdown(true);
            }
        }
        catch (Exception e) {
            log.error("Erro ao tentar reiniciar as tarefas.", (Throwable)e);
        }
    }
}

