/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.agendamento;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.agendamento.job.JobEnvioEmailAlteracoesSolicitacao;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class AgendaEnvioEmailTramitesLaudo
extends EloLogger
implements ServletContextListener {
    public static Scheduler scheduler;

    protected void init() throws ObjectAlreadyExistsException {
        try {
            String habilitado = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_ENVIO_EMAIL_TRAMITES_LAUDO);
            if (SimNaoEnum.SIM.getShortText().equalsIgnoreCase(habilitado)) {
                StdSchedulerFactory schedFactory = new StdSchedulerFactory();
                scheduler = schedFactory.getScheduler();
                Logger.getLogger(AgendaEnvioEmailTramitesLaudo.class.getName()).log(Level.INFO, "*** Criando Tarefa: JobEnvioEmailTramitesLaudo ***");
                JobDetail jobEnvioEmailTramitesLaudo = JobBuilder.newJob(JobEnvioEmailAlteracoesSolicitacao.class).build();
                SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(4).repeatForever()).build();
                scheduler.scheduleJob(jobEnvioEmailTramitesLaudo, (Trigger)trigger);
                scheduler.start();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Erro no agendamento de envio de emails dos tramites dos laudos. " + e.getMessage()), (Throwable)e);
        }
    }

    public void contextInitialized(ServletContextEvent ce) {
        try {
            this.init();
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Erro ao inicializar o contexto: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        try {
            if (Objects.nonNull(scheduler)) {
                scheduler.shutdown(true);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Erro ao tentar finalizar o agendamento do envio de email dos tramites dos laudos - " + ex.getMessage()), (Throwable)ex);
        }
    }
}

