#
CREATE TABLE ${db.unico.schema}.REVISION (
  REVISIONNUMBER NUMERIC(15,0)  NOT NULL,
  REVISIONDATE TIMESTAMP,
  USERNAME VARCHAR(30),
  REMOTEIPADDRESS VARCHAR(40),
  PRIMARY KEY (REVISIONNUMBER)
)
#
CREATE TABLE ${db.unico.schema}.PAIS_AUD (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100),
                   CODIGOBACEN VARCHAR(5),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKPAIS_AUD  PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.UNIDADEFEDERACAO_AUD (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100),
                   SIGLA VARCHAR(2),
                   PAIS NUMERIC(10,0),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKUNICOUF_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.CIDADE_AUD (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100),
                   CODIGONACIONAL VARCHAR(20),
                   CODIGOIBGE NUMERIC(10,0),
                   UNIDADEFEDERACAO NUMERIC,
                   CODIGOAPLIC NUMERIC(10,0),
                   INATIVO CHAR(1),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKCIDADE_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLOGRADOURO_AUD  (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100),
                   SIGLA VARCHAR(3),  
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKTIPOLOG_AUD  PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.LOGRADOURO_AUD  (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100) ,
                   TIPOLOGRADOURO NUMERIC(10,0),
                   CIDADE NUMERIC(10,0),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKLOGR_AUD  PRIMARY KEY (ID,REV)
                   
)
#
CREATE TABLE ${db.unico.schema}.BAIRRO_AUD (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100),
                   CIDADE NUMERIC(10,0),  
                   INATIVO CHAR(1),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKBAIRRO_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.BANCO_AUD (ID NUMERIC(10,0) NOT NULL,
				   CODIGO NUMERIC(10,0),
  				   DESCRICAO VARCHAR(100), 
  				   SOURCECLASS VARCHAR(50),
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKBANCO_AUD PRIMARY KEY(ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.AGENCIA_AUD (
  				   ID NUMERIC(10,0) NOT NULL,
  				   CODIGO VARCHAR(10),
  				   BANCO NUMERIC(10,0), 
  				   DESCRICAO VARCHAR(50), 
  				   CIDADE NUMERIC(10,0), 
  				   SOURCECLASS VARCHAR(50),
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
   				   CONSTRAINT PKAGENCIA_AUD PRIMARY KEY(ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_AUD (ID NUMERIC(10,0) NOT NULL,
                   NOME VARCHAR(150),
                   TIPOPESSOA VARCHAR(1),
                   CNPJ_CPF VARCHAR(20),
                   RG_NUMERO VARCHAR(20),
                   RG_DATAEMISSAO DATE,
                   RG_ORGAOEMISSOR VARCHAR(20),
                   RESTRICAOJUDICIAL VARCHAR(1),
                   RESPONSAVELLIQUIDACAO VARCHAR(1),
                   MICROEMPRESA VARCHAR(1),
                   RG_UF NUMERIC(10,0),
                   NOMEFANTASIA VARCHAR(150),
                   OBSERVACAO VARCHAR(1000),
                   OBSERVACAOJUDICIAL VARCHAR(1000),
                   IDTCEPR NUMERIC(10,0),
                   DATAALTERACAO TIMESTAMP,
                   DATACADASTRO DATE,
                   DATAINCLUSAO DATE,
                   INSCRICAOESTADUAL VARCHAR(20),
                   PIS VARCHAR(20),
                   INSCRICAOMUNICIPAL VARCHAR(20),
                   AUTONOMO   VARCHAR(1),
				   CONTRIBUINTE   VARCHAR(1),
				   ESTRANGEIRO   VARCHAR(1),
				   FORNECEDOR   VARCHAR(1),
				   PESSOAL   VARCHAR(1),
                   PROTOCOLO   VARCHAR(1),
				   INATIVO   VARCHAR(1),
				   SITUACAO NUMERIC(10,0),
				   ESCOLARIDADE NUMERIC(10,0),
				   TIPOEMPRESA NUMERIC(10,0),
				   DATANASCIMENTO DATE,
				   OPTANTESIMPLES VARCHAR(1),
				   AUDESPGENERICA VARCHAR(20),
				   AUDESPESPECIAL VARCHAR(20),
				   INSCMUNDATARENOVACAO DATE,
				   INSCMUNDATAVIGENCIA DATE,
				   CAU VARCHAR(15),
				   CREA VARCHAR(15),
				   OAB VARCHAR(15),
				   DATAFIMSUSPENSAO DATE,
				   DATAINISUSPENSAO DATE,
				   CARGO VARCHAR(50),
                   MATRICULA VARCHAR(30),
                   DATAABERTURACNPJ DATE,
                   DATAISSQN DATE, 
                   NIRE VARCHAR(12),
                   NIT VARCHAR(12),
                   CODIGOSISTEMAANTERIOR VARCHAR(15),
                   CNAE NUMERIC(10,0),
                   SOURCECLASS VARCHAR(50),
                   CIDADENASCIMENTO NUMERIC(10,0),
                   CIDADETITULO NUMERIC(10,0),
                   CTPS                VARCHAR(20),
                   SERIECTPS                  VARCHAR(20),
                   ESTADOCTPS                 CHAR(2),
                   DATAEXPEDICAOCTPS          DATE,
                   DATAPIS                    DATE,
                   INSCRICAOINSS              VARCHAR(20),
                   DATAINSS                   DATE,
                   CNH                        VARCHAR(20),
                   DATAVALIDADECNH            DATE,
                   CATEGORIACNH               VARCHAR(10),
                   DATAEXPEDICAOCNH           DATE,
                   PRONTUARIOCNH              VARCHAR(20),
                   OBSERVACAOCNH              VARCHAR(1000),
                   SEXO                       CHAR(1),
                   TIPOSANGUINEO              VARCHAR(10),
                   DEFICIENTE                 CHAR(1),
                   ALTURA                     NUMERIC(15,2),
                   PESO                       NUMERIC(15,2),
                   SINAIS                     VARCHAR(60),
                   COR                        NUMERIC(10),
                   CABELO                     NUMERIC(10),
                   OLHOS                      NUMERIC(10),
                   ESTADOCIVIL                NUMERIC(10),
                   NOMEPAI                    VARCHAR(60),
                   NOMEMAE                    VARCHAR(60),
                   NACIONALIDADE              NUMERIC(10),
                   DATACHEGADA                DATE,
                   CARTEIRAMODELO19           VARCHAR(20),
                   DATAOBITO                  DATE,
                   RESERVISTA                 VARCHAR(20),
                   CATEGORIARESERVISTA        VARCHAR(10),
                   REGIAORESERVISTA           VARCHAR(10),
                   TITULOELEITOR              VARCHAR(20),
                   SECAOELEITORAL             VARCHAR(10),
                   ZONAELEITORAL              VARCHAR(10),
                   REGISTROPROFISSIONAL       VARCHAR(20),
                   DATAREGISTROPROFISSIONAL   DATE,
                   ORGAOREGISTROPROFISSIONAL  VARCHAR(20),
                   ALVARAJUDICIAL             CHAR(1),
                   CERTIDAONASCIMENTO         VARCHAR(50),
                   CERTIDAOOBITO              VARCHAR(20),
                   LIVROCERTIDAONASCIMENTO    VARCHAR(20),
                   LIVROCERTIDAOOBITO         VARCHAR(20),
                   FOLHACERTIDAONASCIMENTO    VARCHAR(20),
                   FOLHACERTIDAOOBITO         VARCHAR(20),
                   CAUSAMORTE                 VARCHAR(500),
                   PORTADORMOLESTIAGRAVE      CHAR(1),
                   MOLESTIAGRAVE              VARCHAR(200),
                   DATALAUDOMOLESTIAGRAVE     DATE,   
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKPESSOA_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_CONTATOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0), 
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKPESSOACONTATOPESSOA_AUD PRIMARY KEY(ID,REV) 
)
#
CREATE TABLE ${db.unico.schema}.CONTATOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   NOME VARCHAR(60), 
  				   TELEFONERESIDENCIAL VARCHAR(20), 
  				   TELEFONECOMERCIAL VARCHAR(20), 
  				   TELEFONEFAX VARCHAR(20), 
  				   TELEFONECELULAR VARCHAR(20), 
  				   EMAIL VARCHAR(100), 
  				   HOMEPAGE VARCHAR(100), 
  				   CPF VARCHAR(11), 
  				   REPRESENTANTELEGAL VARCHAR(1), 
  				   REPRESENTANTE NUMERIC(10,0), 
  			       RG VARCHAR(20), 
  				   ORGAOEMISSOR VARCHAR(20), 
  				   DATAJUNTACOMERCIAL DATE, 
  				   BRASILEIRO VARCHAR(1), 
  				   PRINCIPAL VARCHAR(1),
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKCONTATOPESSOA_AUD PRIMARY KEY(ID,REV) 
  				    
)
#
CREATE TABLE ${db.unico.schema}.DOCUMENTO_AUD (
  ID NUMERIC(10,0) NOT NULL,
  TIPODOCUMENTO NUMERIC(10,0),
  DESCRICAO VARCHAR(4000),
  CODIGOTCE NUMERIC(10,0),
  POSSUIVALIDADE VARCHAR(1),
  OBRIGATORIOCERTIDAO VARCHAR(1),
  APRESENTADOPOR VARCHAR(1),
  CLASSIFICACAO VARCHAR(1),
  SOURCECLASS VARCHAR(50),
  REV  NUMERIC(15,0) NOT NULL, 
  REVTYPE  NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKDOCUMENTO_AUD PRIMARY KEY(ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.ENDERECOPESSOA_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   CEP NUMERIC(10,0),  
                   CIDADE NUMERIC(10,0),  
                   LOGRADOURO NUMERIC(10,0),  
                   BAIRRO NUMERIC(10,0),  
                   NUMERO VARCHAR(60),
                   COMPLEMENTO VARCHAR(100),
                   TIPO NUMERIC(10,0),
                   PRINCIPAL VARCHAR(1),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKENDERECOPESSOA_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_ENDERECOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0), 
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKPESSOAENDERECOPESSOA_AUD PRIMARY KEY(ID,REV) 
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_BANCOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0), 
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKPESSOABANCOPESSOA_AUD PRIMARY KEY(ID,REV) 
)
#
CREATE TABLE ${db.unico.schema}.BANCOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL,
  				   CODIGOTCE NUMERIC(10,0),
				   BANCO NUMERIC(10,0), 
  				   AGENCIA NUMERIC(10,0), 
  				   PESSOA NUMERIC(10,0),
  				   CONTA VARCHAR(20), 
  				   TIPOCONTA CHAR(1), 
			       ORDEMBANCARIA VARCHAR(20),
			       DATAABERTURA DATE, 
  				   OPERACAO VARCHAR(10), 
  				   DATAENCERRAMENTO DATE, 
                   PRINCIPAL VARCHAR(1),  
         		   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKBANCOPESSOA_AUD PRIMARY KEY(ID,REV) 
  				   
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_DOCUMENTOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0), 
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKPESSOADOCUMENTOPESSOA_AUD PRIMARY KEY(ID,REV) 
)
#
CREATE TABLE ${db.unico.schema}.DOCUMENTOPESSOA_AUD (
  ID NUMERIC(10,0) NOT NULL, 
  PESSOA NUMERIC(10,0), 			
  DOCUMENTO NUMERIC(10,0),
  NUMERODOCUMENTO VARCHAR(50),
  DATAEMISSAO DATE, 
  DATAALTERACAO DATE,
  DATAVALIDADE DATE,
  IDARQUIVO NUMERIC(10,0), 
  REV  NUMERIC(15,0) NOT NULL, 
  REVTYPE  NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKDOCUMENTOPESSOA_AUD PRIMARY KEY(ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_SOCIOPESSOA_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0), 
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKPESSOASOCIOPESSOA_AUD PRIMARY KEY(ID,REV) 
)
#
CREATE TABLE ${db.unico.schema}.SOCIOPESSOA_AUD (
  ID NUMERIC(10,0) NOT NULL,
  SOCIO NUMERIC(10,0),
  NOME VARCHAR(60), 
  TIPOPESSOA VARCHAR(1), 
  CNPJ_CPF VARCHAR(20), 
  FUNCAO NUMERIC(10,0), 
  TIPOREGISTRO NUMERIC(10,0), 
  DATAREGISTRO DATE, 
  NUMEROREGISTRO VARCHAR(30), 
  REV  NUMERIC(15,0) NOT NULL, 
  REVTYPE  NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKSOCIOPESSOA_AUD PRIMARY KEY(ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.RAMOATIVIDADE_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(500),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKRAMOATIVIDADEAUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.CNAE_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   CODIGO VARCHAR(250),
                   DESCRICAO VARCHAR(250),
                   ADMITEMOVIMENTO CHAR(1),
                   SOURCECLASS VARCHAR(50),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKCNAEAUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_RAMOATIVIDADE_AUD
(
  PESSOA NUMERIC(10,0) NOT NULL,
  RAMOATIVIDADE NUMERIC(10,0) NOT NULL,
  REV  NUMERIC(15,0) NOT NULL, 
  REVTYPE  NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKUPESSOARAMOAT_AUD PRIMARY KEY (PESSOA, RAMOATIVIDADE,REV)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_PESSOAALTERARAZAO_AUD (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0), 
  				   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
  				   CONSTRAINT PKPESSOAALTERARAZAO_AUD PRIMARY KEY(ID,REV) 
)
#
CREATE TABLE ${db.unico.schema}.PESSOAALTERARAZAO_AUD
(
  ID NUMERIC(10,0) NOT NULL,
  NOMEANTIGO VARCHAR(80),
  NOMENOVO VARCHAR(80),
  MOTIVACAO VARCHAR(250),
  INICIOVIGENCIA DATE,
  REV  NUMERIC(15,0) NOT NULL, 
  REVTYPE  NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKUPESSOAALTERARAZAOAUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.ENTIDADE_AUD
(
  ID                   NUMERIC(10) NOT NULL,
  NOME                 VARCHAR(100),
  CNPJ                 VARCHAR(20),
  CIDADE               NUMERIC(10),
  BAIRRO               NUMERIC(10),
  LOGRADOURO           NUMERIC(10),
  NUMERO               VARCHAR(10),
  COMPLEMENTO          VARCHAR(60),
  CEP                  VARCHAR(10),
  ENTIDADEPRINCIPAL    CHAR(1),
  TIPOENTIDADE         CHAR(1),
  TELEFONE             VARCHAR(20),
  IDENTIFICACAOTCE     VARCHAR(10),
  CNAE                 NUMERIC(10),
  EMAIL                VARCHAR(60), 
  GPS                  NUMERIC(10),
  FPAS                 NUMERIC(10),
  TIPOSISTEMA          VARCHAR(1),
  CONSOLIDA            VARCHAR(1),
  CODAUDESP            NUMERIC(10),
  CODMUNICAUDESP       NUMERIC(10),
  CLIENTEELOTECH       CHAR(1),
  PERCENTUALISENCAOFILANTROPICA NUMERIC(8,4),
  SOURCECLASS VARCHAR(50),
  HASHSTRING VARCHAR(200),  
  REV  NUMERIC(15,0) NOT NULL, 
  REVTYPE  NUMERIC(10,0) NOT NULL,
  CONSTRAINT XPKENTIDADEAUX PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.LEIATO_AUD
(
   ID                          NUMERIC(10,0)           NOT NULL,
   ENTIDADE                    NUMERIC(10,0),           
   NUMERO                      NUMERIC(10,0),
   ANO                         NUMERIC(10,0),
   TIPOLEIDOCUMENTO            NUMERIC(10,0),
   TIPOLEIESCOPO               NUMERIC(10,0),
   TIPOLEINATUREZA             NUMERIC(10,0),   
   VALORSUPLEMENTAR 		   NUMERIC(15,4), 
   VALORESPECIAL 			   NUMERIC(15,4), 
   VALOREXTRAORDINARIO 		   NUMERIC(15,4), 
   VALORSUPERAVIT 			   NUMERIC(15,4), 
   VALORSUPERAVITVINCULADO     NUMERIC(15,4), 
   VALOREXCESSO 			   NUMERIC(15,4), 
   VALOREXCESSOVINCULADO 	   NUMERIC(15,4), 
   VALORANULACAO 			   NUMERIC(15,4), 
   VALOROPERACAODECREDITO 	   NUMERIC(15,4), 
   VALORSEMDESPCORRESPONDENTE  NUMERIC(15,4),
   PERCSUPLEMENTACAO 		   NUMERIC(15,4), 
   PERCOPCREDARO 			   NUMERIC(15,4), 
   PERCOPCREDINT 			   NUMERIC(15,4), 
   DATAATO                     DATE,
   DATAPUBLICACAO              DATE,
   DATACADASTRO                DATE,
   DATAGERACAOTC			   DATE,
   ANOINICIO                   NUMERIC(10,0),
   PAGINA                      VARCHAR(50),
   ANOEDICAO                   NUMERIC(10,0),
   NUMEROEDICAO                NUMERIC(10,0),
   IDTCE                       NUMERIC(10),
   SUMULA					   VARCHAR(4000),
   MOSTRAPORTAL                CHAR(1),
   DATAINICIOVIGENCIA		   DATE,
   DATAFIMVIGENCIA			   DATE,
   SITUACAO	                   CHAR(1),
   VEICULOPUBLICACAO 		   NUMERIC(10,0),
   ESFERAGOVERNO               CHAR(1),
   NUMEROTCE                   VARCHAR(20),
   IDUNICOATOISS			   NUMERIC(10,0),
   LEIAUTORIZATIVA			   NUMERIC(10,0),	
   MODULO					   NUMERIC(10,0),	
   SOURCECLASS VARCHAR(50),
   HASHSTRING VARCHAR(200),
   REV  NUMERIC(15,0) NOT NULL, 
   REVTYPE  NUMERIC(10,0) NOT NULL,
   CONSTRAINT PKLEIATO_AUD PRIMARY KEY (ID, REV)
)
#
CREATE TABLE ${db.unico.schema}.VEICULOPUBLICACAO_AUD
(
   ID              NUMERIC(10,0) NOT NULL,
   CODIGOOPERACAO  NUMERIC(10,0),
   CODIGOATOSPESSOAL VARCHAR(50),
   DATAALTERACAO     DATE,
   DATACADASTRO      DATE,
   DESCRICAO     VARCHAR(250),
   DATAENVIO     DATE,
   MOTIVOBAIXA  VARCHAR(250),
   OBSERVACAO  VARCHAR(250),
   DATABAIXA     DATE,
   ANOLICITACAO NUMERIC(10,0),
   NUMEROLICITACAO NUMERIC(10,0),
   POSSUILICITACAO VARCHAR(1),
   ENTIDADELICITACAO NUMERIC(10,0),
   PESSOA NUMERIC(10,0),
   ENTIDADE NUMERIC(10,0),
   TIPOLICITACAO NUMERIC(10,0),
   TIPOVEICULOPUBLICACAO NUMERIC(10,0),
   LEIATO                NUMERIC(10,0),
   SOURCECLASS 				   VARCHAR(50),
   HASHSTRING 				   VARCHAR(200),
   REV  NUMERIC(15,0) NOT NULL, 
   REVTYPE  NUMERIC(10,0) NOT NULL,
   CONSTRAINT PKVEICULOPUBLI_AUD PRIMARY KEY (ID,REV)   
)
#
CREATE TABLE ${db.unico.schema}.LEIATO_LEIATOPUBLICACAO_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   LEIATO NUMERIC(10,0) NOT NULL,
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKLEI_LEIATOPUBLI_AUD PRIMARY KEY (ID,LEIATO,REV)
)
#
CREATE TABLE ${db.unico.schema}.LEIATOPUBLICACAO_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   PRINCIPAL VARCHAR(1),
                   VEICULOPUBLICACAO NUMERIC(10,0),
                   NUMEROEDICAO NUMERIC(10,0),
                   ANOEDICAO NUMERIC(10,0),
                   DATAPUBLICACAO DATE,
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKLEIATOPUBLI_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.LEIATO_LEIATOARQUIVO_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   LEIATO NUMERIC(10,0) NOT NULL,
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKLEI_LEIATOARQ_AUD PRIMARY KEY (ID,LEIATO,REV)
)
#
CREATE TABLE ${db.unico.schema}.LEIATOARQUIVO_AUD (
                   ID NUMERIC(10,0) NOT NULL,
                   PRINCIPAL VARCHAR(1),
                   IDARQUIVO NUMERIC(10,0),
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   CONSTRAINT PKLEIATOARQ_AUD PRIMARY KEY (ID,REV)
)
#
CREATE TABLE ${db.unico.schema}.MODULO_AUD (
                   REV  NUMERIC(15,0) NOT NULL, 
                   REVTYPE  NUMERIC(10,0) NOT NULL,
                   MODULO NUMERIC(10,0) NOT NULL,
  				   DESCRICAO VARCHAR(30), 
  				   PATH VARCHAR(100), 
  				   TIPOMODULO CHAR(1), 
  				   CONTROLAACESSORELATORIO CHAR(1),
  				   CONSTRAINT PKMODULO_AUD PRIMARY KEY (MODULO, REV)
)
#
CREATE TABLE ${db.unico.schema}.USUARIO_AUD(
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    ID     NUMERIC(10,0) NOT NULL,
	ATIVO 		CHAR(1),
    CONTABLOQUEADA VARCHAR(1),
	DATAEXPIRACAO   DATE, 
	EMAIL     	VARCHAR(100),
    SENHAEXPIRADA VARCHAR(1),
    USUARIO 	VARCHAR(60),
	PESSOA      NUMERIC(10,0),
    USUARIORESPONSAVEL NUMERIC(10,0),
    MODOAUTENTICACAO VARCHAR(1),
	CONSTRAINT PKUSUARIO_AUD PRIMARY KEY (ID,REV)	
)
#
CREATE TABLE ${db.unico.schema}.USUARIO_USUARIOENTIDADE_AUD(
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    ID     NUMERIC(10,0) NOT NULL,
    USUARIO   NUMERIC(10,0),
	CONSTRAINT PKUSUARIOUSRENTIDADE_AUD PRIMARY KEY (ID,REV)	
)
#
CREATE TABLE ${db.unico.schema}.USUARIO_USUARIOMODULO_AUD(
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    ID     NUMERIC(10,0) NOT NULL,
    USUARIO   NUMERIC(10,0),
	CONSTRAINT PKUSUARIOUSRMODULO_AUD PRIMARY KEY (ID,REV)	
)
#
CREATE TABLE ${db.unico.schema}.USUARIOENTIDADE_AUD (
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    ID     NUMERIC(10,0) NOT NULL,
    ENTIDADE   NUMERIC(10,0),
    PRINCIPAL VARCHAR(1),
	CONSTRAINT PKUSUARIOENTIDADE_AUD PRIMARY KEY (ID,REV)	
)
#
CREATE TABLE ${db.unico.schema}.USUARIOMODULO_AUD (
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    ID     NUMERIC(10,0) NOT NULL,
    MODULO   NUMERIC(10,0),
    PRINCIPAL VARCHAR(1),
	CONSTRAINT PKUSUARIOMODULO_AUD PRIMARY KEY (ID,REV)	
)
#
CREATE TABLE ${db.unico.schema}.USUARIOGRUPO_AUD (
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    USUARIO   NUMERIC(10,0) NOT NULL,
    GRUPO   NUMERIC(10,0) NOT NULL,
	CONSTRAINT PKUSUARIOUSRGRUPO_AUD PRIMARY KEY (REV,USUARIO,GRUPO)	
)
#
CREATE TABLE ${db.unico.schema}.USUARIORECURSO_AUD (
    REV  NUMERIC(15,0) NOT NULL, 
    REVTYPE  NUMERIC(10,0) NOT NULL,
    USUARIO   NUMERIC(10,0) NOT NULL,
    RECURSO   NUMERIC(10,0) NOT NULL,
	CONSTRAINT PKUSUARIOUSRRECURSO_AUD PRIMARY KEY (REV,USUARIO,RECURSO)	
)

