CREATE TABLE ${db.contabilidade.schema}.MODULO (
  MODULO VARCHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(30), 
  PATH VARCHAR(100), 
  BASEDADOS VARCHAR(100), 
  VERSAOBASE VARCHAR(30), 
  VERSAOBASE_AUX VARCHAR(30), 
  BLOCKUPDATE VARCHAR(80), 
  BLOCKUPDATEKEY VARCHAR(250), 
  DIASSEMUTILIZACAO NUMERIC(10,0), 
  CONSTRAINT PKMODULO PRIMARY KEY(MODULO)
);

CREATE TABLE ${db.contabilidade.schema}.EXERCICIO_MES
(
  ENTIDADE NUMERIC(10,0) NOT NULL,
  EXERCICIO NUMERIC(10,0) NOT NULL,
  MES NUMERIC(10,0) NOT NULL,
  SITUACAO CHAR(1),
  CORRECAOORCAMENTO NUMERIC(10,0),
  SITUACAO_SIGELO CHARACTER(1),
  CONSTRAINT PKEXERCICIO_MES PRIMARY KEY (ENTIDADE, EXERCICIO, MES)
);

CREATE TABLE ${db.contabilidade.schema}.TIPOLOGRADOURO (
  TIPOLOGRADOURO NUMERIC(10,0) NOT NULL, 
  DESCRICAO VARCHAR(100), 
  CONSTRAINT PK_TIPOLOGRADOURO PRIMARY KEY(TIPOLOGRADOURO)
);


CREATE TABLE ${db.contabilidade.schema}.UNIDADEFEDERACAO
(
  UNIDADEFEDERACAO CHAR(2) NOT NULL,
  DESCRICAO VARCHAR(50),
  CONSTRAINT PK_UNIDADEFEDERACAO PRIMARY KEY (UNIDADEFEDERACAO)
);

CREATE TABLE ${db.contabilidade.schema}.CIDADE
(
  CIDADE NUMERIC(10,0) NOT NULL,
  UNIDADEFEDERACAO CHAR(2) NOT NULL,
  DESCRICAO VARCHAR(100),
  IBGE VARCHAR(10),
  IDMT NUMERIC(10,0),
  CONSTRAINT PK_CIDADE PRIMARY KEY (CIDADE),
  CONSTRAINT FKUF_CIDADE FOREIGN KEY (UNIDADEFEDERACAO) REFERENCES ${db.contabilidade.schema}.UNIDADEFEDERACAO (UNIDADEFEDERACAO)
);

CREATE TABLE ${db.contabilidade.schema}.BAIRRO
(  
    CIDADE NUMERIC(10) NOT NULL, 
	BAIRRO NUMERIC(10) NOT NULL, 
	DESCRICAO VARCHAR(100), 
	CONSTRAINT XPKBAIRRO PRIMARY KEY (BAIRRO),
	CONSTRAINT FKCIDADE_BAIRRO FOREIGN KEY (CIDADE) REFERENCES ${db.contabilidade.schema}.CIDADE (CIDADE)
);


CREATE TABLE ${db.contabilidade.schema}.LOGRADOURO (
  LOGRADOURO NUMERIC(10,0) NOT NULL, 
  TIPOLOGRADOURO NUMERIC(10,0), 
  CIDADE NUMERIC(10,0), 
  DESCRICAO VARCHAR(100), 
  CONSTRAINT PK_LOGRADOURO PRIMARY KEY(LOGRADOURO), 
  CONSTRAINT FKLOG_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.contabilidade.schema}.CIDADE(CIDADE),
  CONSTRAINT FKLOG_TIPOLOGRADOURO FOREIGN KEY (TIPOLOGRADOURO) REFERENCES ${db.contabilidade.schema}.TIPOLOGRADOURO(TIPOLOGRADOURO)
);


CREATE TABLE ${db.contabilidade.schema}.FORNECEDOR
(
  FORNECEDOR NUMERIC(10,0) NOT NULL,
  NOME VARCHAR(150),
  FANTASIA VARCHAR(150),
  ENDERECO VARCHAR(250),
  CIDADE VARCHAR(50),
  UF VARCHAR(2),
  CEP VARCHAR(10),
  DDD VARCHAR(4),
  DDDFAX VARCHAR(4),
  FAX VARCHAR(20),
  CAIXAPOSTAL VARCHAR(8),
  CNPJ VARCHAR(15),
  BANCO NUMERIC(10,0),
  AGENCIA VARCHAR(10),
  CONTA VARCHAR(25),
  CGCM VARCHAR(20),
  INSCEST VARCHAR(20),
  CONTATO VARCHAR(60),
  HOMEPAGE VARCHAR(100),
  EMAIL VARCHAR(100),
  BAIRRO VARCHAR(60),
  TIPOPESSOA VARCHAR(1),
  SITUACAO NUMERIC(10,0),
  DATAVIGENCIA DATE,
  DATARENOVACAO DATE,
  ORGAOEMISSOR VARCHAR(20),
  OBSERVACAO VARCHAR(1000),
  DATAALTERACAO DATE,
  VALIDO VARCHAR(1),
  MESCRIACAO NUMERIC(10,0),
  TIPOEMPRESA NUMERIC(10,0),
  DATACADASTRO DATE,
  CONTASUBVENCAO VARCHAR(35),
  TEL VARCHAR(20),
  DATAABERTURACONTA DATE,
  INSCRICAOGENERICA VARCHAR(20),
  MICROPEQUENA CHARACTER(1),
  PIS VARCHAR(20),
  IDENTIFICACAOESPECIAL VARCHAR(20),
  CONSORCIO VARCHAR(1),
  PERCENTUAL NUMERIC(10,0),
  IDCIDADE NUMERIC(10,0),
  RESPONSAVELLIQUIDACAO CHARACTER(1),
  ESCOLARIDADE NUMERIC(10,0),
  IDTCEPR NUMERIC(10,0),
  RESTRICAOJUDICIAL CHARACTER(1),
  OBSERVACAOJUDICIAL VARCHAR(1000),  
  CONSTRAINT PKFORNECEDOR PRIMARY KEY (FORNECEDOR)
);

CREATE TABLE ${db.contabilidade.schema}.BANCO (
  BANCO NUMERIC(10,0) NOT NULL, 
  DESCRICAO VARCHAR(100), 
  CONSTRAINT PKBANCO PRIMARY KEY(BANCO)
);

CREATE TABLE ${db.contabilidade.schema}.FORNECEDORBANCO (
  ID NUMERIC(10,0) NOT NULL, 
  FORNECEDOR NUMERIC(10,0) NOT NULL, 
  BANCO NUMERIC(10,0), 
  AGENCIA VARCHAR(10), 
  CONTA VARCHAR(25), 
  DATAABERTURACONTA DATE, 
  OPERACAO VARCHAR(10), 
  DATAENCERRAMENTO DATE, 
  CIDADE NUMERIC(10,0),
  PRINCIPAL VARCHAR(1), 
  CONSTRAINT FORNECEDORBANCO_PKEY PRIMARY KEY(ID, FORNECEDOR), 
  CONSTRAINT FK_FORNEBANCO_CIDADE FOREIGN KEY (CIDADE)
    REFERENCES ${db.contabilidade.schema}.CIDADE(CIDADE)
);

CREATE TABLE ${db.contabilidade.schema}.TIPOCERTIDAO (
  TIPO VARCHAR(1) NOT NULL, 
  DESCRICAO VARCHAR(250), 
  VALIDA VARCHAR(1), 
  CONSTRAINT TIPOCERTIDAO_PKEY PRIMARY KEY(TIPO)
);

CREATE TABLE ${db.contabilidade.schema}.FORNECEDORNEGATIVA (
  ID NUMERIC(10,0) NOT NULL,
  FORNECEDOR NUMERIC(10,0) NOT NULL, 
  TIPO VARCHAR(1) NOT NULL, 
  DATAEMISSAO DATE, 
  VALIDADE DATE, 
  NUMERO VARCHAR(50), 
  CONSTRAINT FORNECEDORNEGATIVA_PKEY PRIMARY KEY(ID), 
  CONSTRAINT FK_CERTIDAOFORNECEDOR FOREIGN KEY (FORNECEDOR) REFERENCES ${db.contabilidade.schema}.FORNECEDOR(FORNECEDOR), 
  CONSTRAINT FK_TIPOCERTIDAO FOREIGN KEY (TIPO) REFERENCES ${db.contabilidade.schema}.TIPOCERTIDAO(TIPO)
);


CREATE TABLE ${db.contabilidade.schema}.ENTIDADE
(
   ENTIDADE           NUMERIC(10,0) NOT NULL,
   NOME               VARCHAR(100),
   CNPJ               VARCHAR(15),
   LOGRADOURO         VARCHAR(100),
   BAIRRO             VARCHAR(40),
   CIDADE             VARCHAR(40),
   UF                 VARCHAR(2),
   CEP                VARCHAR(10),
   ENTIDADEPRINCIPAL  NUMERIC(10,0),
   TIPOENTIDADE       CHAR(1),
   IDENTIFICACAOTCE   VARCHAR(10),
   BRASAO             ${blob.type},
   ENTIDADEORCAMENTO  NUMERIC(10,0),
   TELEFONE           VARCHAR(20),
   CONSOLIDA          VARCHAR(1),
   COD_AUDESP         NUMERIC(10,0),
   COD_MUNIC_AUDESP   NUMERIC(10,0),
   CLIENTEELOTECHSN   CHAR(1) DEFAULT 'N',
   CONSTRAINT PKENTIDADE PRIMARY KEY(ENTIDADE)    
);

CREATE TABLE ${db.contabilidade.schema}.TIPOESCOPO
(
   ID            NUMERIC(10,0)          NOT NULL,
   CODIGO        NUMERIC(10,0),
   DESCRICAO     VARCHAR(250),
   VERSAO        NUMERIC(10,0),
   FLPLURIANUAL  CHAR(1),
   CONSTRAINT TIPOESCOPO_PKEY PRIMARY KEY (ID)
);


CREATE TABLE ${db.contabilidade.schema}.TIPODOCUMENTOLEGAL
(
   ID              NUMERIC(10,0)          NOT NULL,
   CODIGO          NUMERIC(10,0),
   DESCRICAO       VARCHAR(250),
   EXIGENUMERODOC  CHAR(1),
   CONSTRAINT PK_TIPODOCLEGAL PRIMARY KEY (ID)
);

CREATE TABLE ${db.contabilidade.schema}.NATUREZALEI
(
   ID         NUMERIC(10,0)          NOT NULL,
   CODIGO     NUMERIC(10,0),
   DESCRICAO  VARCHAR(250),
   CONSTRAINT NATUREZALEI_PKEY PRIMARY KEY (ID)
);


CREATE TABLE ${db.contabilidade.schema}.TIPOORGAOOFICIAL
(
   ID                  NUMERIC(10)     NOT NULL,
   IDTIPOORGAOOFICIAL  NUMERIC(10),
   DSTIPOORGAOOFICIAL  VARCHAR(250),
   UF                  VARCHAR(2),
   CONSTRAINT TIPOORGAOOFICIAL_PKEY PRIMARY KEY (ID)
);


CREATE TABLE ${db.contabilidade.schema}.ORGAOOFICIAL
(
   ENTIDADE               NUMERIC(10,0)   NOT NULL,
   ID                     NUMERIC(10)     NOT NULL,
   CDOPERACAO             NUMERIC(10)     NOT NULL,
   FORNECEDOR             NUMERIC(10,0),
   DTINICIO               DATE,
   FLLICITACAO            CHAR(1),
   ENTIDADELICITACAO      NUMERIC(10,0),
   NRLICITACAO            NUMERIC(10,0),
   NRANOLICITACAO         NUMERIC(10,0),
   IDMODALIDADELICITACAO  VARCHAR(2),
   IDTIPOORGAOOFICIAL     NUMERIC(10),
   CDCONTROLELEIATO       NUMERIC(10,0),
   DSOBSERVACAO           VARCHAR(250),
   DTBAIXA                DATE,
   DSMOTIVOBAIXA          VARCHAR(250),
   DATAENVIO              DATE,
   CONSTRAINT ORGAOOFICIAL_PKEY PRIMARY KEY (ENTIDADE, ID),
   CONSTRAINT FK_TIPOORGAOOFICIAL FOREIGN KEY (IDTIPOORGAOOFICIAL)  REFERENCES ${db.contabilidade.schema}.TIPOORGAOOFICIAL (ID)
); 

CREATE TABLE ${db.contabilidade.schema}.LEIS_ATOS
(
   ID                          NUMERIC(10,0)           NOT NULL,
   ENTIDADE                    NUMERIC(10,0)           NOT NULL,
   EXERCICIO                   NUMERIC(10,0)           NOT NULL,
   ESCOPO                      NUMERIC(10,0)           NOT NULL,
   NATUREZA                    NUMERIC(10,0)           NOT NULL,
   NUMERO                      NUMERIC(10,0)           NOT NULL,
   TIPOANEXO                   NUMERIC(10,0)           NOT NULL,
   DATA                        DATE,
   DATAPUBLICACAO              DATE,
   DATACADASTRO                DATE,
   ANOINICIO                   NUMERIC(10,0),
   ANEXO                       ${blob.type},
   NOMEARQUIVO                 VARCHAR(250),
   VALORSUPLEMENTAR            NUMERIC(10,0),
   VALORESPECIAL               NUMERIC(10,0),
   VALOREXTRAORDINARIO         NUMERIC(10,0),
   VALORSUPERAVIT              NUMERIC(10,0),
   VALORSUPERAVITVINCULADO     NUMERIC(10,0),
   VALOREXCESSO                NUMERIC(10,0),
   VALOREXCESSOVINCULADO       NUMERIC(10,0),
   VALORANULACAO               NUMERIC(10,0),
   VALOROPERACAODECREDITO      NUMERIC(10,0),
   ID_LEI_ALTERA               NUMERIC(10,0),
   PERCSUPLEMENTACAO           NUMERIC(10,0),
   PERCOPCREDARO               NUMERIC(10,0),
   PERCOPCREDINT               NUMERIC(10,0),
   TIPODOCUMENTOLEGAL          NUMERIC(10,0),
   IDORGAOOFICIAL              NUMERIC(10),
   IDTCE                       NUMERIC(10),
   ENTIDADEORIGEM              NUMERIC(10,0),
   PAGINA                      VARCHAR(50),
   NUMEROEDICAO                VARCHAR(50),
   TIPOANEXO2                  NUMERIC(10,0),
   NOMEARQUIVO2                VARCHAR(250),
   ANEXO2                      ${blob.type},
   MOSTRARPORTAL               VARCHAR(1),
   VALORSEMDESPCORRESPONDENTE  NUMERIC(10,0),
   SUMULA                      VARCHAR(4000),
   CONSTRAINT LEIS_ATOS_PKEY PRIMARY KEY (ID),
   CONSTRAINT FK_TIPODOCLEGAL FOREIGN KEY (TIPODOCUMENTOLEGAL)  REFERENCES ${db.contabilidade.schema}.TIPODOCUMENTOLEGAL (ID),
   CONSTRAINT FK_LEIS_ATOS_ENTIDADE FOREIGN KEY (ENTIDADE)  REFERENCES ${db.contabilidade.schema}.ENTIDADE (ENTIDADE),
   CONSTRAINT FK_LEIATOORGAOOFICIAL FOREIGN KEY (ENTIDADE, IDORGAOOFICIAL) REFERENCES ${db.contabilidade.schema}.ORGAOOFICIAL (ENTIDADE, ID)
);

CREATE TABLE ${db.contabilidade.schema}.TIPOSLICITACAO
(
   TIPOLICITACAO  VARCHAR(2)       NOT NULL,
   DESCRICAO      VARCHAR(40),
   VALORMINIMO    NUMERIC(15,6),
   VALORMAXIMO    NUMERIC(15,6),
   CODIGOTCEPR    NUMERIC(10),
   CONSTRAINT PKTIPOSLICITACAO PRIMARY KEY (TIPOLICITACAO)
);

CREATE TABLE ${db.contabilidade.schema}.USUARIO (
  USUARIO VARCHAR(15) NOT NULL, 
  NOME CHAR(150), 
  SENHA CHAR(15), 
  NIVEL NUMERIC(15,6), 
  TEMPO NUMERIC(15,6), 
  TEMPOREQFEC NUMERIC(15,6), 
  TEMPOREQ NUMERIC(15,6), 
  ROOT VARCHAR(20), 
  ATIVO VARCHAR(1), 
  CPF VARCHAR(20), 
  RG VARCHAR(20), 
  ORGAOEMISSOR VARCHAR(20), 
  DESCRICAOCARGO VARCHAR(60), 
  MATRICULA VARCHAR(30), 
  TIPOORDEM CHAR(1) DEFAULT 'A', 
  OPERADORCOLETOR CHAR(1) DEFAULT 'N', 
  EMAIL VARCHAR(100),
  CONSTRAINT PKUSUARIO PRIMARY KEY(USUARIO)
);

CREATE TABLE ${db.contabilidade.schema}.USUARIOENTIDADE (
  USUARIO VARCHAR(15) NOT NULL, 
  ENTIDADE NUMERIC(10,0) NOT NULL, 
  PADRAO CHAR(1), 
  CONSTRAINT XPKUSUARIOENTIDADE PRIMARY KEY(USUARIO, ENTIDADE), 
  CONSTRAINT FKENTIDADE_USUENTIDADE FOREIGN KEY (ENTIDADE)
    REFERENCES ${db.contabilidade.schema}.ENTIDADE(ENTIDADE), 
  CONSTRAINT R_166 FOREIGN KEY (USUARIO)
    REFERENCES ${db.contabilidade.schema}.USUARIO(USUARIO)
);


CREATE TABLE ${db.contabilidade.schema}.ARQUIVO
(
   ID           NUMERIC(10,0)      NOT NULL,
   NOMEARQUIVO  VARCHAR(2000),
   DATAARQUIVO  DATE,
   DATA         DATE,
   USUARIO      VARCHAR(15),
   TELA         VARCHAR(100),
   RESUMO       VARCHAR(4000),
   IDARQUIVO    NUMERIC(10,0),
   CONSTRAINT PK_ARQUIVO PRIMARY KEY (ID)
);

CREATE TABLE ${db.contabilidade.schema}.LEIS_ATOSARQUIVO
(
   ID          NUMERIC(10,0)    NOT NULL,
   IDLEISATOS  NUMERIC(10,0),
   IDARQUIVO   NUMERIC(10,0),
   CONSTRAINT PKLEIS_ATOSARQUIVO PRIMARY KEY (ID),
   CONSTRAINT FKLEISATOS_LEISARQ FOREIGN KEY (IDLEISATOS) REFERENCES ${db.contabilidade.schema}.LEIS_ATOS (ID),
   CONSTRAINT FKLEISATOS_ARQUIVO FOREIGN KEY (IDARQUIVO) REFERENCES ${db.contabilidade.schema}.ARQUIVO (ID)
);


CREATE TABLE ${db.contabilidade.schema}.USUARIO_ENTIDADE
(
   USUARIO   VARCHAR(15)    NOT NULL,
   ENTIDADE  NUMERIC(10,0)  NOT NULL,
   PADRAO    CHAR(1),
   CONSTRAINT PKUSUARIO_ENTIDADE PRIMARY KEY (USUARIO, ENTIDADE),
   CONSTRAINT FK_ENTIDADEUSUARIO FOREIGN KEY (ENTIDADE)  REFERENCES ${db.contabilidade.schema}.ENTIDADE (ENTIDADE)  ON DELETE CASCADE,
   CONSTRAINT FK_ENTIDADEUSUARIOUSU FOREIGN KEY (USUARIO)  REFERENCES ${db.contabilidade.schema}.USUARIO (USUARIO)  ON DELETE CASCADE 
);


CREATE TABLE ${db.contabilidade.schema}.USRXMOD
(
   MODULO           VARCHAR(2)     NOT NULL,
   USUARIO          VARCHAR(15)    NOT NULL,
   PRIORITARIO      CHAR(1),
   NOVIDADES        VARCHAR(10),
   PUBLICIDADE      VARCHAR(10),
   DISPONIVELWEBSN  CHAR(1),
   ROOT             VARCHAR(20),
   DATADESBLOQUEIO  TIMESTAMP,
   BLOQUEADO        CHAR(1),
   ULTIMOACESSO     TIMESTAMP,
   ISROOT           VARCHAR(50),
   CONSTRAINT PKUSRXMOD PRIMARY KEY (MODULO, USUARIO),
   CONSTRAINT FK_USUARIO_USRXMOD FOREIGN KEY (USUARIO) REFERENCES ${db.contabilidade.schema}.USUARIO (USUARIO),
   CONSTRAINT FK_USRXMOD FOREIGN KEY (MODULO) REFERENCES ${db.contabilidade.schema}.MODULO (MODULO)
);

CREATE TABLE ${db.contabilidade.schema}.USRXPROG 
(
  USUARIO VARCHAR(15) NOT NULL, 
  MODULO VARCHAR(2) NOT NULL, 
  PROGRAMA VARCHAR(30) NOT NULL, 
  AUTOGRAVA CHAR(1), 
  CONTADOR NUMERIC(10,0), 
  REAPROVEITA CHAR(1), 
  IMPRESSORA NUMERIC(10,0), 
  ACESSO NUMERIC(10,0), 
  FAVORITO CHAR(1), 
  ULTIMOREG CHAR(245), 
  AUTOINSERI CHAR(1), 
  INSERIR CHAR(1), 
  ALTERAR CHAR(1), 
  EXCLUIR CHAR(1), 
  FUNCAOESPECIAL CHAR(1), 
  CONSTRAINT PKUSRXPROG PRIMARY KEY (MODULO, USUARIO, PROGRAMA)
);

CREATE TABLE ${db.contabilidade.schema}.LOGUPDATEDATABASE
(
   ID          INTEGER       NOT NULL,
   MODULO      VARCHAR(2)    NOT NULL,
   VERSAOBASE  INTEGER       NOT NULL,
   DATAINICIO  DATE          NOT NULL,
   DATAFIM     DATE,
   CONSTRAINT PKLOGUPDATE PRIMARY KEY (ID, MODULO)
);

CREATE TABLE ${db.contabilidade.schema}.SELETOR
(
   PROGRAMA    VARCHAR(50)   NOT NULL,
   MODULO      VARCHAR(2)    NOT NULL,
   DESCRICAO   CHAR(60),
   NIVEL       NUMERIC(10,0),
   TIPO        CHAR(1),
   ORDEM       NUMERIC(10,0),
   ATIVO       CHAR(1),
   ACESSO      NUMERIC(10,0),
   CRIADO      CHAR(1),
   CONSTRAINT PKSELETOR PRIMARY KEY (MODULO, PROGRAMA),
   CONSTRAINT FK_MODULOSELETOR FOREIGN KEY (MODULO) REFERENCES ${db.contabilidade.schema}.MODULO(MODULO)
);

CREATE TABLE ${db.contabilidade.schema}.EMPENHO
(
   ENTIDADE                     NUMERIC(10,0)            NOT NULL,
   EXERCICIO                    NUMERIC(10,0)            NOT NULL,
   EMPENHO                      NUMERIC(10,0)            NOT NULL,
   UNIDADEORCAMENTARIA          VARCHAR(8)      NOT NULL,
   FORNECEDOR                   NUMERIC(10,0),
   CONSTRAINT PKEMPENHO PRIMARY KEY (EMPENHO, ENTIDADE, EXERCICIO,  UNIDADEORCAMENTARIA)
); 

CREATE TABLE ${db.contabilidade.schema}.FORNECEDORALTERARAZAO
(
   CODIGO            NUMERIC(10,0)   NOT NULL,
   FORNECEDOR        NUMERIC(10,0)   NOT NULL,
   NOMEANTIGO        VARCHAR(80),
   NOMENOVO          VARCHAR(80),
   MOTIVACAO         VARCHAR(250),
   INICIOVIGENCIA    TIMESTAMP,
   CONSTRAINT PKFORNECEDORALTERARAZAO PRIMARY KEY (CODIGO, FORNECEDOR),
   CONSTRAINT FK_FORNECEDORALTERARAZAO FOREIGN KEY (FORNECEDOR) REFERENCES ${db.contabilidade.schema}.FORNECEDOR(FORNECEDOR)
); 
   

