CREATE TABLE ${db.protocolo.schema}.MODULO (
  MODULO VARCHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(30), 
  PATH VARCHAR(100), 
  BASEDADOS VARCHAR(100), 
  VERSAOBASE VARCHAR(30), 
  VERSAOBASE_AUX VARCHAR(30), 
  BLOCKUPDATE VARCHAR(80), 
  BLOCKUPDATEKEY VARCHAR(120), 
  CONSTRAINT PKMODULO PRIMARY KEY(MODULO)
);

CREATE TABLE ${db.protocolo.schema}.TIPOLOGRADOURO
(
  TIPOLOGRADOURO NUMERIC(10,0) NOT NULL,
  DESCRICAO      VARCHAR(100),
  CONSTRAINT PKTIPOLOG PRIMARY KEY (TIPOLOGRADOURO)
);  


CREATE TABLE ${db.protocolo.schema}.UNIDADEFEDERACAO
(
  UNIDADEFEDERACAO CHAR(2) NOT NULL,
  DESCRICAO        VARCHAR(50),
  CONSTRAINT PKUNIDADEFEDERACAO PRIMARY KEY (UNIDADEFEDERACAO)
);  

CREATE TABLE ${db.protocolo.schema}.CIDADE (
  CIDADE NUMERIC(10,0) NOT NULL, 
  UNIDADEFEDERACAO CHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(100), 
  BO_ATIVO VARCHAR(1), 
  ID_CIDADEAISE NUMERIC(10,0), 
  CONSTRAINT PKCIDADE PRIMARY KEY(CIDADE),
  CONSTRAINT FKUF_CIDADE FOREIGN KEY (UNIDADEFEDERACAO)
    REFERENCES ${db.protocolo.schema}.UNIDADEFEDERACAO(UNIDADEFEDERACAO)
  
);

CREATE TABLE ${db.protocolo.schema}.BAIRRO
(  
    CIDADE NUMERIC(10) NOT NULL, 
	BAIRRO NUMERIC(10) NOT NULL, 
	DESCRICAO VARCHAR(100), 
	BO_ATIVO VARCHAR(1),                         
    ID_BAIRROAISE NUMERIC(10),  
	CONSTRAINT PKBAIRRO PRIMARY KEY (CIDADE, BAIRRO),
	CONSTRAINT FKCIDADE_BAIRRO FOREIGN KEY (CIDADE) REFERENCES ${db.protocolo.schema}.CIDADE (CIDADE)
);

CREATE TABLE ${db.protocolo.schema}.LOGRADOURO (
  LOGRADOURO NUMERIC(10) NOT NULL,
  BAIRRO NUMERIC(10) NOT NULL, 
  CIDADE NUMERIC(10) NOT NULL, 
  TIPOLOGRADOURO NUMERIC(10) NOT NULL,
  CEP VARCHAR(10), 
  DESCRICAO VARCHAR(100), 
  BO_ATIVO VARCHAR(1), 
  ID_LOGRADOUROAISE NUMERIC(10),
  CONSTRAINT PKLOGRADOURO PRIMARY KEY(LOGRADOURO), 
  CONSTRAINT FKCIDADE FOREIGN KEY (CIDADE)
    REFERENCES ${db.protocolo.schema}.CIDADE(CIDADE)
);

CREATE TABLE ${db.protocolo.schema}.PESSOA (
  CODPESSOA NUMERIC(10) NOT NULL, 
  NOME VARCHAR(150), 
  TELEFONE VARCHAR(40), 
  RG VARCHAR(20), 
  PESSOA VARCHAR(1), 
  ENDIMOVEL VARCHAR(80), 
  INSCRIMOVEL VARCHAR(40), 
  EMAIL VARCHAR(100), 
  CELULAR VARCHAR(60), 
  SEQUENCIAENDERECO NUMERIC(10), 
  CNPJ_CPF VARCHAR(20), 
  SEQUENCIACORRESPONDENCIA NUMERIC(10), 
  CARGO VARCHAR(50), 
  ATIVO VARCHAR(1),
  DATANASCIMENTO DATE,
  IDUNICO NUMERIC(10),
  CONSTRAINT PESSOA_PKEY PRIMARY KEY(CODPESSOA)
);

CREATE TABLE ${db.protocolo.schema}.ENDERECOPESSOA (
  CODPESSOA NUMERIC(10) NOT NULL, 
  SEQUENCIA NUMERIC(10) NOT NULL, 
  TIPOENDERECO VARCHAR(1), 
  ENDERECO VARCHAR(100), 
  NUMERO VARCHAR(10), 
  COMPLEMENTO VARCHAR(100), 
  UF CHAR(2), 
  CEP VARCHAR(10), 
  BAIRROAUX VARCHAR(50), 
  CIDADEAUX VARCHAR(50), 
  LOGRADOURO NUMERIC(10), 
  UNIDADEFEDERACAO CHAR(2), 
  BAIRRO NUMERIC(10), 
  CIDADE NUMERIC(10), 
  CONSTRAINT ENDERECOPESSOA_PKEY PRIMARY KEY(CODPESSOA, SEQUENCIA),
  CONSTRAINT FKENDPESSOA_BAIRRO FOREIGN KEY (CIDADE, BAIRRO)
	REFERENCES ${db.protocolo.schema}.BAIRRO(CIDADE, BAIRRO), 
  CONSTRAINT FKENDPESSOA_CIDADE FOREIGN KEY (CIDADE)
	REFERENCES ${db.protocolo.schema}.CIDADE (CIDADE), 
  CONSTRAINT FKENDPESSOA_LOGRADOURO FOREIGN KEY (LOGRADOURO)
	REFERENCES ${db.protocolo.schema}.LOGRADOURO (LOGRADOURO), 
  CONSTRAINT FKENDPESSOA_UF FOREIGN KEY (UNIDADEFEDERACAO)
	REFERENCES ${db.protocolo.schema}.UNIDADEFEDERACAO (UNIDADEFEDERACAO), 
  CONSTRAINT FKENDPESSOA_PESSOA FOREIGN KEY (CODPESSOA)
    REFERENCES ${db.protocolo.schema}.PESSOA (CODPESSOA) 
);

CREATE TABLE ${db.protocolo.schema}.ENTIDADE
(
   ENTIDADE           NUMERIC(10,0) NOT NULL,
   NOME               VARCHAR(100),
   CNPJ               VARCHAR(15),
   UF                 VARCHAR(2),
   CEP                VARCHAR(10),
   ENTIDADEPRINCIPAL  NUMERIC(10,0),
   TIPOENTIDADE       VARCHAR(1),
   IDENTIFICACAOTCE   VARCHAR(10),
   BRASAO             ${blob.type},
   ENTIDADEORCAMENTO  NUMERIC(10,0),
   TELEFONE           VARCHAR(20),
   BAIRROAUX          VARCHAR(50),
   CIDADEAUX          VARCHAR(50),
   LOGRADOUROAUX      VARCHAR(50),
   UNIDADEFEDERACAO   CHAR(2) NOT NULL,
   NUMERO             VARCHAR(10),
   LOGRADOURO         NUMERIC(10,0) NOT NULL,
   BAIRRO             NUMERIC(10,0) NOT NULL,
   CIDADE             NUMERIC(10,0) NOT NULL,
   CLIENTEELOTECHSN   CHAR(1) DEFAULT 'N',
   CONSTRAINT PKENTIDADE PRIMARY KEY (ENTIDADE),
   CONSTRAINT FKENDENTIDADE_BAIRRO FOREIGN KEY (CIDADE,BAIRRO) REFERENCES ${db.protocolo.schema}.BAIRRO (CIDADE,BAIRRO),
   CONSTRAINT FKENDENTIDADE_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.protocolo.schema}.CIDADE (CIDADE),
   CONSTRAINT FKENDENTIDADE_LOGRADOURO FOREIGN KEY (LOGRADOURO) REFERENCES ${db.protocolo.schema}.LOGRADOURO (LOGRADOURO),
   CONSTRAINT FKENDENTIDADE_UF FOREIGN KEY (UNIDADEFEDERACAO) REFERENCES ${db.protocolo.schema}.UNIDADEFEDERACAO (UNIDADEFEDERACAO)
);

CREATE TABLE ${db.protocolo.schema}.USUARIO (
  LOGIN1 VARCHAR(15) NOT NULL, 
  NOME VARCHAR(150), 
  SENHA VARCHAR(15), 
  LOCAL NUMERIC(10,0), 
  VISUALIZA VARCHAR(1), 
  NIVELTRAMITE VARCHAR(1), 
  NIVELACESSO NUMERIC(10,0), 
  NOMEPROG VARCHAR(60), 
  USUARIO NUMERIC(10,0), 
  PADRAO VARCHAR(1), 
  VERIFICAMENSAGENS VARCHAR(1), 
  TEMPOVERIFICACAO NUMERIC(10,0), 
  ATIVO VARCHAR(1),
  EMAIL VARCHAR(100), 
  BO_ANEXARARQUIVO VARCHAR(1),
  CPF VARCHAR(20), 
  CONSTRAINT USUARIO_PKEY PRIMARY KEY(LOGIN1)
);


CREATE TABLE ${db.protocolo.schema}.USRXMOD
(
   MODULO       VARCHAR(2)     NOT NULL,
   USUARIO      VARCHAR(15)    NOT NULL,
   PRIORITARIO  VARCHAR(1),
   NOVIDADES    VARCHAR(10),
   CONSTRAINT PK_USRXMOD PRIMARY KEY (MODULO, USUARIO),
   CONSTRAINT FK_USUARIOMOD_MODULO FOREIGN KEY (MODULO)
    REFERENCES ${db.protocolo.schema}.MODULO(MODULO),
   CONSTRAINT FK_USUARIOMOD_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES ${db.protocolo.schema}.USUARIO(LOGIN1) 
);


CREATE TABLE ${db.protocolo.schema}.USUARIO_ENTIDADE
(
   USUARIO   VARCHAR(15)    NOT NULL,
   ENTIDADE  NUMERIC(10,0)  NOT NULL,
   PADRAO    VARCHAR(1),
   CONSTRAINT PKUSUARIO_ENTIDADE PRIMARY KEY (USUARIO, ENTIDADE),
   CONSTRAINT FK_USUARIOENT_ENTIDADE FOREIGN KEY (ENTIDADE)
    REFERENCES ${db.protocolo.schema}.ENTIDADE(ENTIDADE),
   CONSTRAINT FK_USUARIOENT_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES ${db.protocolo.schema}.USUARIO(LOGIN1) 
);


CREATE TABLE ${db.protocolo.schema}.USUARIOSELETOR 
(
   MODULO VARCHAR(2) NOT NULL, 
   SELETOR VARCHAR(50) NOT NULL, 
   USUARIO VARCHAR(15) NOT NULL, 
   AUTOGRAVA VARCHAR(1), 
   REAPROVEITA VARCHAR(1), 
   ACESSO NUMERIC(10,0), 
   FAVORITO VARCHAR(1), 
   ULTIMOREGISTRO VARCHAR(245), 
   AUTOINSERI VARCHAR(1), 
   INSERIR VARCHAR(1), 
   ALTERAR VARCHAR(1), 
   EXCLUIR VARCHAR(1), 
   FUNCAOESPECIAL VARCHAR(1), 
   PESQUISAVAZIA VARCHAR(1), 
   PRIMARY KEY (MODULO, SELETOR, USUARIO)
);	

CREATE TABLE ${db.protocolo.schema}.LOGUPDATEDATABASE
(
   ID          INTEGER       NOT NULL,
   MODULO      VARCHAR(2)    NOT NULL,
   VERSAOBASE  INTEGER       NOT NULL,
   DATAINICIO  DATE          NOT NULL,
   DATAFIM     DATE,
   CONSTRAINT PKLOGUPDATE PRIMARY KEY (ID, MODULO)
);

CREATE TABLE ${db.protocolo.schema}.SELETOR
(
   NOMEPROG    VARCHAR(50)   NOT NULL,
   DESCRICAO   VARCHAR(60),
   NIVEL       NUMERIC(10,0),
   ORDEM       NUMERIC(10,0),
   CONSTRAINT SELETOR_PKEY PRIMARY KEY (NOMEPROG)
);
