CREATE TABLE ${db.compras.schema}.MODULO (
  MODULO VARCHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(30), 
  PATH VARCHAR(100), 
  VERSAOBASE VARCHAR(30), 
  VERSAOBASE_AUX VARCHAR(30), 
  BLOCKUPDATE VARCHAR(80), 
  BLOCKUPDATEKEY VARCHAR(120), 
  CONSTRAINT PKMODULO PRIMARY KEY(MODULO)
);

CREATE TABLE ${db.compras.schema}.TIPOLOGRADOURO
(
  TIPOLOGRADOURO NUMERIC(10,0) NOT NULL,
  DESCRICAO      VARCHAR(100),
  CONSTRAINT PKTIPOLOGRAD PRIMARY KEY (TIPOLOGRADOURO)
);  


CREATE TABLE ${db.compras.schema}.UNIDADEFEDERACAO
(
  UNIDADEFEDERACAO CHAR(2) NOT NULL,
  DESCRICAO        VARCHAR(50),
  CONSTRAINT XPKUNIDADEFEDERACAO PRIMARY KEY (UNIDADEFEDERACAO)
);  

CREATE TABLE ${db.compras.schema}.CIDADE (
  CIDADE NUMERIC(10,0) NOT NULL, 
  UNIDADEFEDERACAO CHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(100), 
  IBGE VARCHAR(10), 
  CODAPLIC VARCHAR(10), 
  CONSTRAINT PKCIDADE PRIMARY KEY(CIDADE) 
);

CREATE TABLE ${db.compras.schema}.BAIRRO
(  
    CIDADE NUMERIC(10) NOT NULL, 
	BAIRRO NUMERIC(10) NOT NULL, 
	DESCRICAO VARCHAR(100), 
	CONSTRAINT XPKBAIRRO PRIMARY KEY (CIDADE, BAIRRO),
	CONSTRAINT FKCIDADE_BAIRRO FOREIGN KEY (CIDADE) REFERENCES ${db.compras.schema}.CIDADE (CIDADE)
);

CREATE TABLE ${db.compras.schema}.LOGRADOURO 
(
    LOGRADOURO NUMERIC(10) NOT NULL, 
    TIPOLOGRADOURO NUMERIC(10), 
    DESCRICAO VARCHAR(100), 
    CIDADE NUMERIC(10) NOT NULL, 
    CONSTRAINT PKLOGRADOURO PRIMARY KEY(CIDADE, LOGRADOURO), 
    CONSTRAINT FKCIDADE_LOGRADOURO FOREIGN KEY (CIDADE) 
      REFERENCES ${db.compras.schema}.CIDADE(CIDADE), 
    CONSTRAINT FKLOG_TIPOLOGRADOURO FOREIGN KEY (TIPOLOGRADOURO) 
      REFERENCES ${db.compras.schema}.TIPOLOGRADOURO(TIPOLOGRADOURO)
);

CREATE TABLE ${db.compras.schema}.BANCO (
  BANCO NUMERIC(10,0) NOT NULL, 
  DESCRICAO VARCHAR(100), 
  CONSTRAINT PKBANCO PRIMARY KEY(BANCO)
);

CREATE TABLE ${db.compras.schema}.PESSOA
(
  PESSOA NUMERIC(10,0) NOT NULL,
  TIPOPESSOA VARCHAR(1),
  NOME VARCHAR(150),
  NOMEFANTASIA VARCHAR(150),
  CNPJ_CPF VARCHAR(20),
  RG VARCHAR(20),
  ORGAOEMISSOR VARCHAR(20),
  DATAEMISSAO DATE,
  INSCRICAOESTADUAL VARCHAR(20),
  SEQUENCIAENDERECO NUMERIC(10,0),
  SEQUENCIACONTATO NUMERIC(10,0),
  SEQUENCIABANCO NUMERIC(10,0),
  CONTRIBUINTE VARCHAR(1),
  FORNECEDOR VARCHAR(1),
  PESSOAL VARCHAR(1),
  ESTADOEMISSOR VARCHAR(2),
  DATAINCLUSAO DATE,
  MODULO NUMERIC(10,0),
  USUARIO VARCHAR(15),
  OBSERVACAO VARCHAR(1000),
  BANCO NUMERIC(10,0),
  AGENCIA VARCHAR(10),
  CONTA VARCHAR(25),
  CARGO VARCHAR(50),
  MATRICULA VARCHAR(20),
  MICROPEQUENA VARCHAR(1) DEFAULT 'N',
  DATAALTERACAO DATE,
  DATACADASTRO DATE,
  TIPOEMPRESA NUMERIC(10,0),
  FONECOMERCIAL VARCHAR(20),
  FONEFAX VARCHAR(20),
  EMAIL VARCHAR(100),
  HOMEPAGE VARCHAR(100),
  FOLHAPAGAMENTO VARCHAR(1),
  SITUACAO NUMERIC(10,0),
  TIPOMICRO NUMERIC(10,0),
  OPTANTESIMPLES VARCHAR(1),
  PIS VARCHAR(20),
  CNAE VARCHAR(7),
  CONSORCIO VARCHAR(1),
  PERCENTUAL NUMERIC(10,0),
  DATAINISUSPENSAO DATE,
  DATAFINSUSPENSAO DATE,
  OK VARCHAR(1),
  OAB VARCHAR(15),
  CREA VARCHAR(15),
  CAU VARCHAR(15),
  ESTRANGEIRO NUMERIC(10,0),
  INSCRICAOMUNICIPAL VARCHAR(20),
  ESCOLARIDADE VARCHAR(2),
  EMPRESAREGIONAL CHAR(1),
  AGRICULTORFAMILIAR CHAR(1),
  CAPITALSOCIAL NUMERIC(15,2),
  DATACAPITALSOCIAL DATE,
  INABILITADOCONTRATOSFUTUROS VARCHAR(1),
  CONSTRAINT PKPESSOA PRIMARY KEY (PESSOA)
);

CREATE TABLE ${db.compras.schema}.ENDERECOPESSOA
(
  PESSOA                      NUMERIC(10,0) NOT NULL,
  SEQUENCIA                   NUMERIC(10,0) NOT NULL,
  TIPOENDERECO                CHAR(1),
  DOMICILIOFISCALESTABELECIDO CHAR(1),
  LOGRADOURO                  NUMERIC(10,0) NOT NULL,
  NUMERO                      VARCHAR(10),
  COMPLEMENTO                 VARCHAR(100),
  CIDADE                      NUMERIC(10,0) NOT NULL,
  BAIRRO                      NUMERIC(10,0) NOT NULL,
  CEP                         VARCHAR(10),
  ESTADO                      VARCHAR(2),
  CAIXAPOSTAL                 VARCHAR(15),
  CONSTRAINT PKENDERECOPESSOA PRIMARY KEY (PESSOA, SEQUENCIA),
  CONSTRAINT FKEND_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.compras.schema}.PESSOA (PESSOA),
  CONSTRAINT FKEP_BAIRRO FOREIGN KEY (CIDADE, BAIRRO) REFERENCES ${db.compras.schema}.BAIRRO (CIDADE, BAIRRO),
  CONSTRAINT FKEP_LOGRADOURO FOREIGN KEY (CIDADE, LOGRADOURO) REFERENCES ${db.compras.schema}.LOGRADOURO (CIDADE, LOGRADOURO)
);

CREATE TABLE ${db.compras.schema}.BANCOPESSOA (
  PESSOA NUMERIC(10,0) NOT NULL, 
  SEQUENCIA NUMERIC(10,0) NOT NULL, 
  AGENCIA VARCHAR(15), 
  CONTA VARCHAR(20), 
  BANCO NUMERIC(10,0) NOT NULL, 
  DATAABERTURA DATE, 
  OPERACAO VARCHAR(10), 
  DATAENCERRAMENTO DATE, 
  CIDADE NUMERIC(10,0), 
  CONSTRAINT PKBANCOPESSOA PRIMARY KEY(SEQUENCIA, BANCO, PESSOA), 
  CONSTRAINT FKBP_BANCO FOREIGN KEY (BANCO)
    REFERENCES ${db.compras.schema}.BANCO(BANCO), 
  CONSTRAINT FKBP_PESSOA FOREIGN KEY (PESSOA)
    REFERENCES ${db.compras.schema}.PESSOA(PESSOA)
);

CREATE TABLE ${db.compras.schema}.CONTATOPESSOA (
  PESSOA NUMERIC(10,0) NOT NULL, 
  SEQUENCIA NUMERIC(10,0) NOT NULL, 
  NOME VARCHAR(60), 
  TELEFONERESIDENCIAL VARCHAR(20), 
  TELEFONECOMERCIAL VARCHAR(20), 
  TELEFONEFAX VARCHAR(20), 
  TELEFONECELULAR VARCHAR(20), 
  EMAIL VARCHAR(100), 
  HOMEPAGE VARCHAR(100), 
  CPF VARCHAR(11), 
  REPRESENTANTELEGAL CHAR(1) NOT NULL, 
  REPRESENTANTE NUMERIC(10,0), 
  RG VARCHAR(20), 
  ORGAOEMISSOR VARCHAR(20), 
  DATAJUNTACOMERCIAL DATE, 
  NACIONALIDADE VARCHAR(1), 
  CONSTRAINT PKCONTATOPESSOA PRIMARY KEY(PESSOA, SEQUENCIA), 
  CONSTRAINT FKCONTATOPESSOA_REPRES FOREIGN KEY (REPRESENTANTE) REFERENCES ${db.compras.schema}.PESSOA(PESSOA), 
  CONSTRAINT FKCP_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.compras.schema}.PESSOA(PESSOA)
);

CREATE TABLE ${db.compras.schema}.CLDOCUMENTACAO (
  DOCUMENTACAO NUMERIC(10,0) NOT NULL, 
  CLASSIFICACAO CHAR(1), 
  POSSUIVALIDADE CHAR(1), 
  FISICAJURIDICA CHAR(1), 
  OBRIGATORIOCERTIDAO CHAR(1), 
  TIPO VARCHAR(10), 
  DESCRICAO VARCHAR(4000), 
  CODIGOTCE NUMERIC(10,0), 
  CONSTRAINT PKCLDOCUMENTACAO PRIMARY KEY(DOCUMENTACAO)
);


CREATE TABLE ${db.compras.schema}.ARQUIVO
(
   ID           NUMERIC(10,0)      NOT NULL,
   NOMEARQUIVO  VARCHAR(2000),
   ARQUIVO      ${blob.type},
   DATA         DATE,
   USUARIO      VARCHAR(250),
   TELA         VARCHAR(100),
   IDARQUIVO    NUMERIC(10,0),
   CONSTRAINT PK_ARQUIVO PRIMARY KEY (ID)
);


CREATE TABLE ${db.compras.schema}.PESSOADOCUMENTACAO (
  ID NUMERIC(10,0) NOT NULL, 
  PESSOA NUMERIC(10,0) NOT NULL, 
  DOCUMENTACAO NUMERIC(10,0) NOT NULL, 
  DATAEMISSAODOCUMENTO DATE NOT NULL, 
  NUMERODOCUMENTO VARCHAR(50) NOT NULL, 
  VALIDADEDOCUMENTO DATE, 
  DATAINCLUSAO DATE,
  IDARQUIVO NUMERIC(10,0),
  CONSTRAINT PKPESSOADOC PRIMARY KEY(ID), 
  CONSTRAINT FK_PESSOADOCARQ FOREIGN KEY (IDARQUIVO)
      REFERENCES ${db.compras.schema}.ARQUIVO (ID),
  CONSTRAINT FKPESSOADOCUMENTACAO_DOC FOREIGN KEY (DOCUMENTACAO)
      REFERENCES ${db.compras.schema}.CLDOCUMENTACAO (DOCUMENTACAO) ON DELETE CASCADE,
  CONSTRAINT FKPESSOADOCUMENTACAO_PESSOA FOREIGN KEY (PESSOA)
      REFERENCES ${db.compras.schema}.PESSOA (PESSOA) ON DELETE CASCADE 
);

CREATE TABLE ${db.compras.schema}.PESSOASOCIOS (
  PESSOA NUMERIC(10,0) NOT NULL, 
  CODIGOPESSOA NUMERIC(10,0) NOT NULL, 
  SEQUENCIA NUMERIC(10,0) NOT NULL, 
  NOME VARCHAR(60), 
  TIPOPESSOA CHAR(1), 
  CNPJ_CPF VARCHAR(20), 
  FUNCAO NUMERIC(10,0), 
  TIPOREGISTRO NUMERIC(10,0), 
  DATAREGISTRO DATE, 
  NUMEROREGISTRO VARCHAR(30), 
  CONSTRAINT PK_PESSOASOCIOS PRIMARY KEY(PESSOA, SEQUENCIA)
);

CREATE TABLE ${db.compras.schema}.CLRAMOATIVIDADE
(
  RAMOATIVIDADE NUMERIC(10,0) NOT NULL,
  DESCRICAO CHARACTER VARYING(500) NOT NULL,
  CONSTRAINT PKRAMOATIV PRIMARY KEY (RAMOATIVIDADE)
);

CREATE TABLE ${db.compras.schema}.CNAENACIONAL
(
  CODIGO CHARACTER VARYING(7) NOT NULL,
  DESCRICAO CHARACTER VARYING(250),
  CONSTRAINT PK_CNAENACIONAL PRIMARY KEY (CODIGO)
);


CREATE TABLE ${db.compras.schema}.PESSOARAMOATIVIDADE
(
  PESSOA NUMERIC(10,0) NOT NULL,
  RAMOATIVIDADE NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKPESSOARAMOAT PRIMARY KEY (PESSOA, RAMOATIVIDADE),
  CONSTRAINT FKPESSOARAMOATIVIDADE_PESSOA FOREIGN KEY (PESSOA)   REFERENCES ${db.compras.schema}.PESSOA (PESSOA),
  CONSTRAINT FKPESSOARAMOATIVIDADE_RAMO FOREIGN KEY (RAMOATIVIDADE)   REFERENCES ${db.compras.schema}.CLRAMOATIVIDADE (RAMOATIVIDADE)
);

CREATE TABLE ${db.compras.schema}.PESSOAALTERARAZAO
(
  CODIGO NUMERIC(10,0) NOT NULL,
  PESSOA NUMERIC(10,0) NOT NULL,
  NOMEANTIGO VARCHAR(80),
  NOMENOVO VARCHAR(80),
  MOTIVACAO VARCHAR(250),
  INICIOVIGENCIA DATE,
  CONSTRAINT PESSOAALTERARAZAO_PKEY PRIMARY KEY (CODIGO, PESSOA),
  CONSTRAINT FKPESSOAALTERARAZAO FOREIGN KEY (PESSOA)
      REFERENCES ${db.compras.schema}.PESSOA (PESSOA)
);

CREATE TABLE ${db.compras.schema}.ENTIDADE
(
   ENTIDADE           NUMERIC(10,0)    NOT NULL,
   NOME               VARCHAR(100),
   LOGRADOURO         NUMERIC(10,0)    NOT NULL,
   NUMERO             VARCHAR(10),
   BAIRRO             NUMERIC(10,0)    NOT NULL,
   CIDADE             NUMERIC(10,0)    NOT NULL,
   CEP                VARCHAR(10),
   CNPJ               VARCHAR(20),
   ENTIDADEPRINCIPAL  CHAR(1),
   TIPOENTIDADE       CHAR(1),
   IDENTIFICACAOTCE   VARCHAR(10),
   BRASAO             ${blob.type},
   ENTIDADEORCAMENTO  NUMERIC(10,0),
   TELEFONE           VARCHAR(20),
   UNIDADEFEDERACAO   CHAR(2),
   CLIENTEELOTECHSN   CHAR(1)        DEFAULT 'N',
   AJUSTEEXECUTADO    CHAR(1),
   CONSTRAINT PKENTIDADE PRIMARY KEY (ENTIDADE),
   CONSTRAINT FKENTIDADE_CIDADE FOREIGN KEY (CIDADE)
      REFERENCES ${db.compras.schema}.CIDADE (CIDADE),
   CONSTRAINT FKBAIRRO_ENTIDADE FOREIGN KEY (CIDADE, BAIRRO)
      REFERENCES ${db.compras.schema}.BAIRRO (CIDADE,BAIRRO),
   CONSTRAINT FKENT_UF FOREIGN KEY (UNIDADEFEDERACAO)  
      REFERENCES ${db.compras.schema}.UNIDADEFEDERACAO (UNIDADEFEDERACAO),
   CONSTRAINT FKLOGRADOURO_ENTIDADE FOREIGN KEY (CIDADE, LOGRADOURO) 
      REFERENCES ${db.compras.schema}.LOGRADOURO (CIDADE,LOGRADOURO)

);

CREATE TABLE ${db.compras.schema}.NIVELUSUARIO (
  	NIVELUSUARIO NUMERIC(10,0) NOT NULL, 
  	DESCRICAO VARCHAR(50), 
  	CONSTRAINT PKNIVELUSUA PRIMARY KEY(NIVELUSUARIO)
);

CREATE TABLE ${db.compras.schema}.USUARIO (
  	USUARIO VARCHAR(15) NOT NULL, 
  	NOME VARCHAR(150), 
  	SENHA VARCHAR(15), 
  	NIVELUSUARIO NUMERIC(10,0), 
  	ATIVO CHAR(1) DEFAULT 'S', 
  	PUBLICIDADE CHAR(1) DEFAULT 'N', 
  	APROVASOLICITACAO CHAR(1), 
  	CPF VARCHAR(20), 
  	RG VARCHAR(20), 
  	ORGAOEMISSOR VARCHAR(20), 
  	DESCRICAOCARGO VARCHAR(60), 
  	ACESSAREL CHAR(1), 
  	MATRICULA VARCHAR(30), 
  	SUBNIVEL NUMERIC(10,0), 
  	ARQUIVOANEXO CHAR(1), 
  	LOTACAO VARCHAR(100), 
  	CONSTRAINT PKUSUARIO PRIMARY KEY(USUARIO), 
  	CONSTRAINT PKUSUARIO_NIVELUSUARIO FOREIGN KEY (NIVELUSUARIO)
	    REFERENCES ${db.compras.schema}.NIVELUSUARIO(NIVELUSUARIO)
);

CREATE TABLE ${db.compras.schema}.USUARIOENTIDADE (
  USUARIO VARCHAR(15) NOT NULL, 
  ENTIDADE NUMERIC(10,0) NOT NULL, 
  PADRAO CHAR(1), 
  CONSTRAINT PKUSUARIOENTIDADE PRIMARY KEY(USUARIO, ENTIDADE), 
  CONSTRAINT FKUXE_ENTIDADE FOREIGN KEY (ENTIDADE)
    REFERENCES ${db.compras.schema}.ENTIDADE(ENTIDADE),
  CONSTRAINT FKUXE_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES ${db.compras.schema}.USUARIO(USUARIO)
);

CREATE TABLE ${db.compras.schema}.USUARIOMODULO (
  MODULO VARCHAR(2) NOT NULL, 
  USUARIO VARCHAR(15) NOT NULL, 
  PRIORITARIO CHAR(1), 
  NOVIDADES VARCHAR(10), 
  CONSTRAINT PKUSUARIOMODULO PRIMARY KEY(MODULO, USUARIO), 
  CONSTRAINT FKUSMOD_MODULO FOREIGN KEY (MODULO)
    REFERENCES ${db.compras.schema}.MODULO(MODULO),
  CONSTRAINT FKUXM_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES ${db.compras.schema}.USUARIO(USUARIO)
);

  CREATE TABLE ${db.compras.schema}.USUARIOSELETOR ( 
    MODULO VARCHAR(2) NOT NULL, 
	SELETOR VARCHAR(50) NOT NULL, 
	USUARIO VARCHAR(15) NOT NULL, 
	AUTOGRAVA CHAR(1), 
	REAPROVEITA CHAR(1), 
	ACESSO NUMERIC(10,0), 
	FAVORITO CHAR(1), 
	ULTIMOREGISTRO VARCHAR(245), 
	AUTOINSERI CHAR(1), 
	INSERIR CHAR(1), 
	ALTERAR CHAR(1), 
	EXCLUIR CHAR(1), 
	FUNCAOESPECIAL CHAR(1), 
	PESQUISAVAZIA CHAR(1), 
	CONSTRAINT PKUSUARIOSELETOR PRIMARY KEY (MODULO, SELETOR, USUARIO)
);


CREATE TABLE ${db.compras.schema}.LOGUPDATEDATABASE
(
   ID          INTEGER       NOT NULL,
   MODULO      VARCHAR(2)    NOT NULL,
   VERSAOBASE  INTEGER       NOT NULL,
   DATAINICIO  DATE          NOT NULL,
   DATAFIM     DATE,
   CONSTRAINT PKLOGUPDATE PRIMARY KEY (ID, MODULO)
);

CREATE TABLE ${db.compras.schema}.SELETOR
(
   MODULO      VARCHAR(2)    NOT NULL,
   SELETOR     VARCHAR(50)   NOT NULL,
   ORDEM       NUMERIC(10,0),
   DESCRICAO   VARCHAR(60),
   NIVEL       NUMERIC(10,0),
   ATIVO       CHAR(1),
   TIPO        CHAR(1),
   LOG         CHAR(1),
   CONSTRAINT PKSELETOR PRIMARY KEY (MODULO, SELETOR),
   CONSTRAINT FKSEL_MODULO FOREIGN KEY (MODULO) REFERENCES ${db.compras.schema}.MODULO(MODULO)
);

CREATE TABLE ${db.compras.schema}.CLORGAOPUBLICACAO
(
   ORGAOPUBLICACAO    NUMERIC(10,0)    NOT NULL,
   DESCRICAO          VARCHAR(200),
   OFICIAL            CHAR(1), 
   TIPOORGAO          NUMERIC(10,0), 
   NUMEROLEI          VARCHAR(15),
   DATALEI            DATE,
   DATAPUBLICACAOLEI  DATE,
   CNPJ               VARCHAR(20),
   PESSOA             NUMERIC(10,0),
   DATAINI            DATE,
   DATAFIN            DATE,
   POSSUILICITACAO    CHAR(1),
   TIPOLICITACAO      NUMERIC(10,0),
   NUMEROLICITACAO    NUMERIC(10,0),
   ANOLICITACAO       NUMERIC(10,0),
   OBSERVACAO         VARCHAR(250),
   ---INUTIL??
   INEXISTENCIA       NUMERIC(10,0),  
   MURAL              NUMERIC(10,0), 
   LEIATO             NUMERIC(10,0),
   IDTCE              NUMERIC(10,0)
);

ALTER TABLE ${db.compras.schema}.CLORGAOPUBLICACAO  ADD CONSTRAINT PKORGAOPUB  PRIMARY KEY (ORGAOPUBLICACAO);

ALTER TABLE ${db.compras.schema}.CLORGAOPUBLICACAO  ADD CONSTRAINT FK_ORGAOP FOREIGN KEY (PESSOA)
 REFERENCES ${db.compras.schema}.PESSOA (PESSOA);
