CREATE TABLE ${db.aise.schema}.MODULO (
  MODULO VARCHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(30), 
  PATH VARCHAR(100), 
  VERSAOBASE VARCHAR(30), 
  TIPO CHAR(1), 
  VERSAOATUALIZACAO NUMERIC(10,0), 
  DATAATUALIZACAO DATE, 
  DATAVERIFICACAO DATE, 
  ACESSORELATORIO CHAR(1), 
  VERSAOBASE_AUX VARCHAR(30), 
  BLOCKUPDATE VARCHAR(80), 
  BLOCKUPDATEKEY VARCHAR(128), 
  CONSTRAINT XPKMODULO PRIMARY KEY(MODULO)
);

CREATE TABLE ${db.aise.schema}.TIPOLOGRADOURO
(
  TIPOLOGRADOURO NUMERIC(10,0) NOT NULL,
  DESCRICAO      VARCHAR(100),
  SIGLA          VARCHAR(3),
  CONSTRAINT XPKTIPOLOGRADOURO PRIMARY KEY (TIPOLOGRADOURO)
);  

CREATE TABLE ${db.aise.schema}.PAIS
(
  PAIS        NUMERIC(10,0) NOT NULL,
  DESCRICAO   VARCHAR(60),
  CODIGOBACEN VARCHAR(5),
  CONSTRAINT XPKPAIS PRIMARY KEY (PAIS)
);

CREATE TABLE ${db.aise.schema}.UNIDADEFEDERACAO
(
  PAIS             NUMERIC(10) NOT NULL,
  UNIDADEFEDERACAO CHAR(2) NOT NULL,
  DESCRICAO        VARCHAR(50),
  CONSTRAINT XPKUNIDADEFEDERACAO PRIMARY KEY (PAIS, UNIDADEFEDERACAO),
  CONSTRAINT FKPAIS_UNIDADEFEDERACAO FOREIGN KEY (PAIS) REFERENCES ${db.aise.schema}.PAIS(PAIS)
);  

CREATE TABLE ${db.aise.schema}.CIDADE
(  
    CIDADE NUMERIC(10) NOT NULL, 
	UNIDADEFEDERACAO VARCHAR(2), 
	DESCRICAOABREVIADA VARCHAR(100), 
	DESCRICAO VARCHAR(100), 
	CODIGONACIONAL VARCHAR(20), 
	PAIS NUMERIC(10), 
	CODIGOIBGE NUMERIC(10), 
	ATIVA CHAR(1) DEFAULT 'S',
	CONSTRAINT XPKCIDADE PRIMARY KEY (CIDADE)	
);

CREATE TABLE ${db.aise.schema}.BAIRRO
(  
    CIDADE NUMERIC(10) NOT NULL, 
	BAIRRO NUMERIC(10) NOT NULL, 
	DESCRICAO VARCHAR(100), 
	CORRETO CHAR(1),
	INATIVO CHAR(1) DEFAULT 'N',
	EXCLUSAOLOGICA CHAR(1) DEFAULT 'N',
	CONSTRAINT XPKBAIRRO PRIMARY KEY (CIDADE, BAIRRO),
	CONSTRAINT FKCIDADE_BAIRRO FOREIGN KEY (CIDADE) REFERENCES ${db.aise.schema}.CIDADE (CIDADE)
);


CREATE TABLE ${db.aise.schema}.LOGRADOURO (
  CIDADE NUMERIC(10) NOT NULL, 
  LOGRADOURO NUMERIC(10) NOT NULL, 
  TIPOLOGRADOURO NUMERIC(10), 
  DESCRICAO VARCHAR(100), 
  CORRETO CHAR(1), 
  LOCALIZACAO VARCHAR(60), 
  DESCLOGRADOUROINICIO VARCHAR(60), 
  INATIVO CHAR(1), 
  DESCRICAOANTERIOR VARCHAR(100), 
  LOGRADOUROINICIO NUMERIC(10), 
  CONSTRAINT XPKLOGRADOURO PRIMARY KEY(CIDADE, LOGRADOURO), 
  CONSTRAINT FKCIDADE_LOGRADOURO FOREIGN KEY (CIDADE) REFERENCES ${db.aise.schema}.CIDADE(CIDADE),
  CONSTRAINT FKTPLOGRADOURO_LOGRADOURO FOREIGN KEY (TIPOLOGRADOURO) REFERENCES ${db.aise.schema}.TIPOLOGRADOURO(TIPOLOGRADOURO)
);

CREATE TABLE ${db.aise.schema}.PESSOA
(
   PESSOA                 NUMERIC(10) NOT NULL,
   TIPOPESSOA             CHAR(1),
   NOME                   VARCHAR(150),
   NOMEFANTASIA           VARCHAR(150),
   CNPJ_CPF               VARCHAR(20),
   RG                     VARCHAR(20),
   ORGAOEMISSOR           VARCHAR(20),
   DATAEMISSAO            DATE,
   INSCRICAOESTADUAL      VARCHAR(20),
   SEQUENCIAENDERECO      NUMERIC(10),
   SEQUENCIACONTATO       NUMERIC(10),
   SEQUENCIABANCO         NUMERIC(10),
   CONTRIBUINTE           CHAR(1),
   FORNECEDOR             CHAR(1),
   PESSOAL                CHAR(1),
   DATAINCLUSAO           DATE,
   OBSERVACAO             VARCHAR(1000),
   USUARIOINCLUSAO        VARCHAR(15),
   ESTADOEMISSOR          CHAR(2),
   MICROEMPRESA           CHAR(1),
   DATAALTERACAO          DATE,
   ESTRANGEIRO            CHAR(1),
   AUTONOMO               CHAR(1),
   ATIVIDADEPRINCIPAL     VARCHAR(1000),
   INSCRICAOISSQN         VARCHAR(20),
   DATAISSQN              DATE,
   FORNECEDORSISCOP       NUMERIC(10),
   PAIS                   NUMERIC(10),
   CODIGOSISTEMAANTERIOR  VARCHAR(18),
   INATIVO                CHAR(1)     DEFAULT 'N',
   SEQUENCIAIMAGEM        NUMERIC(10),
   ACTIVEFORMORIGEM       VARCHAR(60),
   DATANASCIMENTO         DATE,
   NIT                    VARCHAR(12),
   PISPASEP               VARCHAR(20),
   DATAABERTURACNPJ       DATE,
   NIRE                   VARCHAR(12),
   CODIGOTCE              VARCHAR(20),
   IDUNICO                NUMERIC(10),
   NOMESOCIAL             VARCHAR(150),
   CONSTRAINT XPKPESSOA PRIMARY KEY (PESSOA)
);


CREATE TABLE ${db.aise.schema}.IMAGEM
(
   PESSOA     NUMERIC(10)    NOT NULL,
   SEQUENCIA  NUMERIC(10)    NOT NULL,
   IDARQUIVO  NUMERIC(10),
   CONSTRAINT XPKIMAGEM PRIMARY KEY (PESSOA, SEQUENCIA),
   CONSTRAINT FKRHFOTO_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.aise.schema}.PESSOA (PESSOA)
);


CREATE TABLE ${db.aise.schema}.BANCO (
  BANCO NUMERIC(10,0) NOT NULL, 
  DESCRICAO VARCHAR(100) NOT NULL, 
  TAXADOC NUMERIC(15,4), 
  CONSTRAINT XPKBANCO PRIMARY KEY(BANCO)
);

CREATE TABLE ${db.aise.schema}.AGENCIA (
  BANCO NUMERIC(10,0) NOT NULL, 
  AGENCIA VARCHAR(10) NOT NULL, 
  NOMEAGENCIA VARCHAR(50), 
  CIDADE NUMERIC(10,0), 
  CONSTRAINT XPKAGENCIA PRIMARY KEY(BANCO, AGENCIA), 
  CONSTRAINT FKAGENCIA_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.aise.schema}.CIDADE(CIDADE), 
  CONSTRAINT R_181 FOREIGN KEY (BANCO) REFERENCES ${db.aise.schema}.BANCO(BANCO)
 );
 
 CREATE TABLE ${db.aise.schema}.BANCOPESSOA (
  PESSOA NUMERIC(10,0) NOT NULL, 
  SEQUENCIA NUMERIC(10,0) NOT NULL, 
  BANCO NUMERIC(10,0), 
  AGENCIA VARCHAR(10), 
  CONTA VARCHAR(20), 
  TIPOCONTA CHAR(1), 
  ENTIDADE NUMERIC(10,0), 
  CONTABANCARIA NUMERIC(10,0), 
  ORDEMBANCARIA VARCHAR(20), 
  CONSTRAINT XPKBANCOPESSOA PRIMARY KEY(PESSOA, SEQUENCIA), 
  CONSTRAINT FKBANCOPESSOA_AGENCIA FOREIGN KEY (BANCO, AGENCIA)
    REFERENCES ${db.aise.schema}.AGENCIA(BANCO, AGENCIA), 
  CONSTRAINT FKBANCOPESSOA_BANCO FOREIGN KEY (BANCO)
    REFERENCES ${db.aise.schema}.BANCO(BANCO), 
  CONSTRAINT FKBANCOPESSOA_PESSOA FOREIGN KEY (PESSOA)
    REFERENCES ${db.aise.schema}.PESSOA(PESSOA)
);

CREATE TABLE ${db.aise.schema}.ENDERECOPESSOA (
  PESSOA NUMERIC(10,0) NOT NULL, 
  SEQUENCIA NUMERIC(10,0) NOT NULL, 
  TIPOENDERECO CHAR(1), 
  DOMICILIOFISCALESTABELECIDO CHAR(1), 
  LOGRADOURO NUMERIC(10,0), 
  NUMERO VARCHAR(10), 
  COMPLEMENTO VARCHAR(100), 
  CIDADE NUMERIC(10,0), 
  BAIRRO NUMERIC(10,0), 
  CEP NUMERIC(10,0), 
  UNIDADEFEDERACAO CHAR(2), 
  ESTADO CHAR(2), 
  DATAALTERACAO DATE, 
  PAIS NUMERIC(10,0), 
  TIPOENDERECOANTIGO CHAR(1), 
  CONSTRAINT XPKENDERECOPESSOA PRIMARY KEY(PESSOA, SEQUENCIA), 
  CONSTRAINT FKENDERECOPESSOA_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.aise.schema}.CIDADE(CIDADE),
  CONSTRAINT FKENDERECOPESSOA_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.aise.schema}.PESSOA(PESSOA), 
  CONSTRAINT UF_ENDPESSOA FOREIGN KEY (PAIS, UNIDADEFEDERACAO) REFERENCES ${db.aise.schema}.UNIDADEFEDERACAO(PAIS, UNIDADEFEDERACAO)
);

CREATE TABLE ${db.aise.schema}.CONTATOPESSOA (
  PESSOA NUMERIC(10,0) NOT NULL, 
  SEQUENCIA NUMERIC(10,0) NOT NULL, 
  NOME VARCHAR(60), 
  TELEFONERESIDENCIAL VARCHAR(20), 
  TELEFONECOMERCIAL VARCHAR(20), 
  TELEFONEFAX VARCHAR(20), 
  TELEFONECELULAR VARCHAR(20), 
  EMAIL VARCHAR(100), 
  HOMEPAGE VARCHAR(100), 
  REPRESENTANTELEGAL CHAR(1), 
  CONSTRAINT XPKCONTATOPESSOA PRIMARY KEY(PESSOA, SEQUENCIA), 
  CONSTRAINT FKCONTATOPESSOA_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.aise.schema}.PESSOA(PESSOA)
);

CREATE TABLE ${db.aise.schema}.PESSOADOCUMENTO (
  PESSOA NUMERIC(10,0) NOT NULL, 
  PESSOADOCUMENTO NUMERIC(10,0) NOT NULL, 
  TIPODOCUMENTO NUMERIC(10,0),
  DATAINCLUSAO DATE, 
  DATAALTERACAO DATE, 
  IDARQUIVO    NUMERIC(10,0),
  CONSTRAINT XPKPESSOADOCUMENTO PRIMARY KEY(PESSOA, PESSOADOCUMENTO), 
  CONSTRAINT FKPESSOADOCUMENTO_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.aise.schema}.PESSOA(PESSOA)
);

CREATE TABLE ${db.aise.schema}.TIPOESCOPOLEI
(
  ID         NUMERIC(10) NOT NULL,
  CODIGO     NUMERIC(10) NOT NULL,
  DESCRICAO  VARCHAR(100),
  PLURIANUAL CHAR(1),
  CONSTRAINT PKTIPOESCOPOLEI PRIMARY KEY (ID)
);  

CREATE TABLE ${db.aise.schema}.TIPODOCUMENTOLEGAL
(
  ID             NUMERIC(10) NOT NULL,
  CODIGO         NUMERIC(10) NOT NULL,
  DESCRICAO      VARCHAR(100),
  EXIGENUMERODOC CHAR(1),
  CONSTRAINT PKTIPODOCUMENTOLEGAL PRIMARY KEY (ID)	  
);

CREATE TABLE ${db.aise.schema}.CGTIPOATO
(
  TIPOATO   NUMERIC(10) NOT NULL,
  DESCRICAO VARCHAR(60),
  CODIGOTCE VARCHAR(10),
  CONSTRAINT XPKCGTIPOATO PRIMARY KEY (TIPOATO)
);

CREATE TABLE ${db.aise.schema}.ENTIDADE
(
  ENTIDADE             NUMERIC(10) NOT NULL,
  NOME                 VARCHAR(100),
  COMPLEMENTO          VARCHAR(60),
  LOGRADOURO           NUMERIC(10),
  NUMERO               VARCHAR(10),
  BAIRRO               NUMERIC(10),
  CIDADE               NUMERIC(10),
  CEP                  VARCHAR(10),
  CNPJ                 VARCHAR(20),
  ENTIDADEPRINCIPAL    CHAR(1),
  TIPOENTIDADE         CHAR(1),
  TELEFONE             VARCHAR(20),
  IDENTIFICACAOTCE     VARCHAR(10),
  CODIGO               VARCHAR(20),
  SECAO                VARCHAR(2),
  CNAE                 NUMERIC(10),
  EMAIL                VARCHAR(60),
  UNIDADEFEDERACAO     VARCHAR(2),
  BRASAO               ${blob.type},
  CARIMBOCARNECORREIOS ${blob.type},
  GPS                  NUMERIC(10) DEFAULT 2402,
  FPAS                 NUMERIC(10) DEFAULT 582,
  TIPOSISTEMA          VARCHAR(1) DEFAULT 'A',
  PERCENTUALISENCAOFILANTROPICA  NUMERIC(8,4)    DEFAULT 0,
CONSTRAINT XPKENTIDADE PRIMARY KEY (ENTIDADE),
CONSTRAINT FKBAIRRO_ENTIDADE FOREIGN KEY (CIDADE, BAIRRO) REFERENCES ${db.aise.schema}.BAIRRO (CIDADE, BAIRRO),
CONSTRAINT FKENTIDADE_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.aise.schema}.CIDADE (CIDADE),
CONSTRAINT FKLOGRADOURO_ENTIDADE FOREIGN KEY (CIDADE, LOGRADOURO) REFERENCES ${db.aise.schema}.LOGRADOURO (CIDADE, LOGRADOURO)
);
  
CREATE TABLE ${db.aise.schema}.CGATO
(
  ENTIDADE             NUMERIC(10) NOT NULL,
  IDATO                NUMERIC(10) NOT NULL,
  TIPOATO              NUMERIC(10),
  NUMEROATO            NUMERIC(10),
  ANOATO               NUMERIC(10),
  ESFERA               CHAR(1),
  DATAATO              DATE,
  DATAPUBLICACAO       DATE,
  DATAINICIOVIGENCIA   DATE,
  DATAFIMVIGENCIA      DATE,
  SITUACAO             CHAR(1),
  ENTIDADELEIAUTOR     NUMERIC(10),
  LEIAUTORIZATIVA      NUMERIC(10),
  DESCRICAO            VARCHAR(4000),
  NUMEROATOTCE         VARCHAR(20),
  NUMEROEDICAO         NUMERIC(10),
  ANOEDICAO            NUMERIC(10),
  DATAGERACAOTC        DATE,
  IDTIPODOCUMENTOLEGAL NUMERIC(10),
  IDTIPOESCOPOLEI      NUMERIC(10),
  IDTCE                NUMERIC(10),
  VEICULOPUBLICACAO    NUMERIC(10,0),
  DATACADASTRO         DATE,
  MODULO               VARCHAR(2),
  IDUNICOATOISS        NUMERIC(10),
  IDARQUIVO            NUMERIC(10),
  CONSTRAINT XPKCGATO PRIMARY KEY (ENTIDADE, IDATO),
  CONSTRAINT UK_IDUNICOATOISS UNIQUE (IDUNICOATOISS),
  CONSTRAINT FKATO_TIPODOCLEGAL FOREIGN KEY (IDTIPODOCUMENTOLEGAL) REFERENCES ${db.aise.schema}.TIPODOCUMENTOLEGAL (ID),
  CONSTRAINT FKATO_TIPOESCOPOLEI FOREIGN KEY (IDTIPOESCOPOLEI) REFERENCES ${db.aise.schema}.TIPOESCOPOLEI (ID),
  CONSTRAINT FKCIATO_ENTIDADE FOREIGN KEY (ENTIDADE) REFERENCES ${db.aise.schema}.ENTIDADE (ENTIDADE),
  CONSTRAINT FKLEIAUTOR_CGATO FOREIGN KEY (ENTIDADELEIAUTOR, LEIAUTORIZATIVA) REFERENCES ${db.aise.schema}.CGATO (ENTIDADE, IDATO),
  CONSTRAINT FKTIPOATO_ATO FOREIGN KEY (TIPOATO) REFERENCES ${db.aise.schema}.CGTIPOATO (TIPOATO)
);


CREATE TABLE ${db.aise.schema}.CNAE
(
   CNAE               NUMERIC(10)     NOT NULL,
   DESCRICAO          VARCHAR(250),
   INICIOVALIDADE     DATE,
   CODIGO             VARCHAR(20),
   SECAO              VARCHAR(10),
   MOVSN              CHAR(1),
   SITUACAOMEI        CHAR(1),
   SITUACAOSNA        CHAR(1),
   GRAURISCO          CHAR(1),
   VALORBASECALCULO   NUMERIC(10,2),
   CLASSIFICACAOATIVIDADE NUMERIC(10),
   CONSTRAINT XPKCNAE PRIMARY KEY (CNAE)
);

CREATE TABLE ${db.aise.schema}.RHPESSOA
(
   PESSOA              NUMERIC(10)      NOT NULL,
   CTPS                VARCHAR(20),
   SERIECTPS                  VARCHAR(20),
   ESTADOCTPS                 CHAR(2),
   DATAEXPEDICAOCTPS          DATE,
   PIS                        VARCHAR(20),
   DATAPIS                    DATE,
   INSCRICAOINSS              VARCHAR(20),
   DATAINSS                   DATE,
   CNH                        VARCHAR(20),
   DATAVALIDADECNH            DATE,
   CATEGORIACNH               VARCHAR(10),
   DATAEXPEDICAOCNH           DATE,
   PRONTUARIOCNH              VARCHAR(20),
   OBSERVACAOCNH              VARCHAR(1000),
   SEXO                       CHAR(1),
   TIPOSANGUINEO              VARCHAR(10),
   DEFICIENTE                 CHAR(1),
   ALTURA                     NUMERIC(15,2),
   PESO                       NUMERIC(15,2),
   SINAIS                     VARCHAR(60),
   COR                        NUMERIC(10),
   CABELO                     NUMERIC(10),
   OLHOS                      NUMERIC(10),
   GRAUINSTRUCAO              NUMERIC(10),
   ESTADOCIVIL                NUMERIC(10),
   NOMEPAI                    VARCHAR(60),
   NOMEMAE                    VARCHAR(60),
   NACIONALIDADE              NUMERIC(10),
   DATACHEGADA                DATE,
   CARTEIRAMODELO19           VARCHAR(20),
   REGISTROGERAL              VARCHAR(20),
   DATANASCIMENTO             DATE,
   DATAOBITO                  DATE,
   RESERVISTA                 VARCHAR(20),
   CATEGORIARESERVISTA        VARCHAR(10),
   REGIAORESERVISTA           VARCHAR(10),
   TITULOELEITOR              VARCHAR(20),
   SECAOELEITORAL             VARCHAR(10),
   ZONAELEITORAL              VARCHAR(10),
   REGISTROPROFISSIONAL       VARCHAR(20),
   DATAREGISTROPROFISSIONAL   DATE,
   ORGAOREGISTROPROFISSIONAL  VARCHAR(20),
   ALVARAJUDICIAL             CHAR(1),
   CIDADETITULO               NUMERIC(10),
   CIDADENASCIMENTO           NUMERIC(10),
   CERTIDAONASCIMENTO         VARCHAR(50),
   CERTIDAOOBITO              VARCHAR(100),
   LIVROCERTIDAONASCIMENTO    VARCHAR(20),
   LIVROCERTIDAOOBITO         VARCHAR(20),
   FOLHACERTIDAONASCIMENTO    VARCHAR(20),
   FOLHACERTIDAOOBITO         VARCHAR(20),
   CAUSAMORTE                 VARCHAR(500),
   CONSTRAINT XPKRHPESSOA PRIMARY KEY (PESSOA),
   CONSTRAINT FKPESSOAADICIONAL_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.aise.schema}.PESSOA (PESSOA),
   CONSTRAINT FKRHPESSOA_CIDADENASCIMENTO FOREIGN KEY (CIDADENASCIMENTO) REFERENCES ${db.aise.schema}.CIDADE (CIDADE),
   CONSTRAINT fkrhpessoa_cidadetitulo FOREIGN KEY (cidadetitulo) REFERENCES ${db.aise.schema}.cidade (cidade)
);


CREATE TABLE ${db.aise.schema}.NIVELUSUARIO (
  	NIVELUSUARIO NUMERIC(10,0) NOT NULL, 
  	DESCRICAO VARCHAR(50), 
  	CONSTRAINT XPKNIVELUSUARIO PRIMARY KEY(NIVELUSUARIO)
);

CREATE TABLE ${db.aise.schema}.USUARIO (
  	USUARIO VARCHAR(15) NOT NULL, 
  	SENHA VARCHAR(60), 
  	NIVELUSUARIO NUMERIC(10,0), 
	PESSOA NUMERIC(10,0),
  	ATIVO CHAR(1), 
  	CARGO NUMERIC(10,0),
  	USUARIORESPONSAVEL VARCHAR(15),
  	USUARIOPROTOCOLO VARCHAR(15),
  	NOVIDADES CHAR(1) DEFAULT 'S',
  	SALVAFILTROPESQUISA CHAR(1) DEFAULT 'N',
  	CONSTRAINT XPKUSUARIO PRIMARY KEY(USUARIO),
  	CONSTRAINT FKUSUARIO_USURESPONSAVEL FOREIGN KEY (USUARIORESPONSAVEL)
    	REFERENCES ${db.aise.schema}.USUARIO(USUARIO),
  	CONSTRAINT r_71 FOREIGN KEY (NIVELUSUARIO)
	    REFERENCES ${db.aise.schema}.NIVELUSUARIO(NIVELUSUARIO),
	CONSTRAINT r_73 FOREIGN KEY (PESSOA)
    	REFERENCES ${db.aise.schema}.PESSOA(PESSOA)	    
);

CREATE TABLE ${db.aise.schema}.USUARIOENTIDADE (
  USUARIO VARCHAR(15) NOT NULL, 
  ENTIDADE NUMERIC(10,0) NOT NULL, 
  PADRAO CHAR(1), 
  CONSTRAINT XPKUSUARIOENTIDADE PRIMARY KEY(USUARIO, ENTIDADE), 
  CONSTRAINT R_167 FOREIGN KEY (ENTIDADE)
    REFERENCES ${db.aise.schema}.ENTIDADE(ENTIDADE),
  CONSTRAINT FK_USUARIOENTI_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES ${db.aise.schema}.USUARIO(USUARIO) 
);

CREATE TABLE ${db.aise.schema}.USUARIOMODULO (
  MODULO VARCHAR(2) NOT NULL, 
  USUARIO VARCHAR(15) NOT NULL, 
  ULTIMOACESSO CHAR(2), 
  NOVIDADES CHAR(1), 
  CONSTRAINT XPKUSUARIOMODULO PRIMARY KEY(MODULO, USUARIO), 
  CONSTRAINT R_168 FOREIGN KEY (MODULO)
    REFERENCES ${db.aise.schema}.MODULO(MODULO),
  CONSTRAINT FK_USUARIOMOD_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES ${db.aise.schema}.USUARIO(USUARIO) 
);

CREATE TABLE ${db.aise.schema}.VEICULOPUBLICACAO
(
   VEICULOPUBLICACAO  NUMERIC(10,0)    NOT NULL,
   DESCRICAO          VARCHAR(60),
   CNPJ               VARCHAR(20),
   DATACADASTRO       DATE,
   DATAALTERACAO      DATE,
   TIPO               VARCHAR(3),
   CODIGOTCE          VARCHAR(50),
   ENTIDADE           NUMERIC(10,0) NOT NULL,
   CODIGO             NUMERIC(10,0),
   CONSTRAINT XPKVEICULOPUBLICACAO PRIMARY KEY (VEICULOPUBLICACAO),
   CONSTRAINT FKVEICULOPUBLICACAO_ENTIDADE FOREIGN KEY (ENTIDADE) REFERENCES ${db.aise.schema}.ENTIDADE (ENTIDADE)
);

CREATE TABLE ${db.aise.schema}.CGATOVEICULOPUBLICACAO
(
   ENTIDADE           NUMERIC(10,0)    NOT NULL,
   IDATO              NUMERIC(10,0)    NOT NULL,
   IDSEQUENCIA        NUMERIC(10,0)    NOT NULL,
   VEICULOPUBLICACAO  NUMERIC(10,0),
   NUMEROEDICAO       NUMERIC(10,0),
   ANOEDICAO          NUMERIC(10,0),
   DATAPUBLICACAO     DATE,
   CONSTRAINT XPKCGATOVEICULOPUBLICACAO PRIMARY KEY (ENTIDADE, IDATO, IDSEQUENCIA),
   CONSTRAINT FKATO_VEICULO FOREIGN KEY (ENTIDADE, IDATO)  REFERENCES ${db.aise.schema}.CGATO (ENTIDADE,IDATO),
   CONSTRAINT FKVEICULO_CGATO FOREIGN KEY (VEICULOPUBLICACAO) REFERENCES ${db.aise.schema}.VEICULOPUBLICACAO (VEICULOPUBLICACAO)
);

CREATE TABLE  ${db.aise.schema}.USUARIOSELETORGERAL
(	
   MODULO VARCHAR(2) NOT NULL, 
   SELETOR VARCHAR(50) NOT NULL, 
   USUARIO VARCHAR(15) NOT NULL, 
   FAVORITO CHAR(1), 
   INSERIR CHAR(1), 
   ALTERAR CHAR(1), 
   EXCLUIR CHAR(1), 
   FUNCAOESPECIAL CHAR(1), 
   CONSTRAINT XPKUSUARIOSELETORGERAL PRIMARY KEY (MODULO, SELETOR, USUARIO)
);


CREATE TABLE ${db.aise.schema}.LOGUPDATEDATABASE
(
   ID          INTEGER       NOT NULL,
   MODULO      VARCHAR(2)    NOT NULL,
   VERSAOBASE  INTEGER       NOT NULL,
   DATAINICIO  DATE          NOT NULL,
   DATAFIM     DATE,
   CONSTRAINT PKLOGUPDATE PRIMARY KEY (ID, MODULO)
);

CREATE TABLE ${db.aise.schema}.SELETOR
(
   MODULO      VARCHAR(2)    NOT NULL,
   SELETOR     VARCHAR(50)   NOT NULL,
   DESCRICAO   VARCHAR(60),
   NIVEL       NUMERIC(10,0),
   ATIVO       CHAR(1),
   TIPO        CHAR(1),
   HELPCONTEXT NUMERIC(10,0),
   CONSTRAINT XPKSELETOR PRIMARY KEY (MODULO, SELETOR),
   CONSTRAINT FK_MODULO FOREIGN KEY (modulo) REFERENCES ${db.aise.schema}.modulo(modulo)
);

CREATE TABLE ${db.aise.schema}.USUARIOSELETOR 
(
    ENTIDADE NUMERIC(10,0) NOT NULL,
    MODULO VARCHAR(2) NOT NULL,
    SELETOR VARCHAR(50) NOT NULL,
    USUARIO VARCHAR(15) NOT NULL,
    FAVORITO CHAR(1),
    INSERIR CHAR(1),
    ALTERAR CHAR(1),
    EXCLUIR CHAR(1),
    FUNCAOESPECIAL CHAR(1),
    CONSTRAINT XPKUSUARIOSELETOR PRIMARY KEY (ENTIDADE,MODULO,SELETOR,USUARIO),
    CONSTRAINT FK_ENTIDADE FOREIGN KEY (ENTIDADE) REFERENCES ${db.aise.schema}.ENTIDADE(ENTIDADE),
    CONSTRAINT FK_USUARIOMODULO FOREIGN KEY (MODULO,USUARIO) REFERENCES ${db.aise.schema}.USUARIOMODULO(MODULO,USUARIO),
    CONSTRAINT FK_USUARIO FOREIGN KEY (USUARIO) REFERENCES ${db.aise.schema}.USUARIO(USUARIO),
    CONSTRAINT FK_USUARIOENTIDADE FOREIGN KEY (USUARIO,ENTIDADE) REFERENCES ${db.aise.schema}.USUARIOENTIDADE(USUARIO,ENTIDADE),
    CONSTRAINT FK_SELETOR FOREIGN KEY (MODULO,SELETOR) REFERENCES ${db.aise.schema}.SELETOR(MODULO,SELETOR)
);

CREATE TABLE ${db.aise.schema}.REGISTRO
(
  NOME          VARCHAR(100) NOT NULL,
  MODULO        VARCHAR(2) NOT NULL,
  VALIDADE      DATE NOT NULL,
  DATALIBERACAO DATE,
  SITUACAO      CHAR(1),
  ENTIDADE      NUMERIC(10),
  QTDENTIDADES  NUMERIC(10),
  CODIGO        VARCHAR(10),
  SENHA         VARCHAR(30),
  HASH          VARCHAR(400),
  CONSTRAINT PKREGISTRO PRIMARY KEY (MODULO, NOME, VALIDADE)
);

CREATE TABLE ${db.aise.schema}.TRIBCADASTROGERAL
(
   TIPOCADASTRO                NUMERIC(10)           NOT NULL,
   CADASTROGERAL               NUMERIC(10)           NOT NULL,
   PESSOA                      NUMERIC(10),
   CONSTRAINT XPKTRIBCADASTROGERAL   PRIMARY KEY (TIPOCADASTRO, CADASTROGERAL),
   CONSTRAINT FKPESSOA_CADGERAL FOREIGN KEY (PESSOA)  REFERENCES ${db.aise.schema}.PESSOA (PESSOA) 
);

